/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.run;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.statistics.FusCollectSettingChangesRunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.cucumber.CucumberUtil;
import org.jetbrains.plugins.ruby.cucumber.run.BaseCucumberRunConfiguration;
import org.jetbrains.plugins.ruby.cucumber.run.BaseCucumberRunConfigurationUtil;
import org.jetbrains.plugins.ruby.cucumber.run.CucumberRunCommandLineState;
import org.jetbrains.plugins.ruby.cucumber.run.CucumberRunConfigurationEditor;
import org.jetbrains.plugins.ruby.cucumber.run.CucumberRunConfigurationExternalizer;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractTestRunConfigurationWithTestPath;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.statistic.RubyRunConfigurationSettingChangesCollector;
import org.jetbrains.plugins.ruby.testing.PreloadedTestRunConfiguration;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

public final class CucumberRunConfiguration
extends AbstractTestRunConfigurationWithTestPath<CucumberRunConfiguration>
implements BaseCucumberRunConfiguration,
PreloadedTestRunConfiguration,
FusCollectSettingChangesRunConfiguration {
    @NonNls
    public static final String DEFAULT_TESTS_SEARCH_MASK = "**/*." + GherkinFileType.INSTANCE.getDefaultExtension();
    private String myRunnerArgs = "";
    private String myNamesFilter = "";
    private String myTagsFilter = "";
    private boolean myVerboseEnabled = false;
    private boolean myBacktraceEnabled = false;
    @NotNull
    private PreLoadUtil.PreLoadServer myPreloadServer = PreLoadUtil.PreLoadServer.None;
    private boolean myUseCustomCucumberRunner = false;
    private String myCustomCucumberRunnerPath = "";
    @NotNull
    private List<String> myTestScriptsPaths = Collections.emptyList();

    public CucumberRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
        this.registerLog("RUBY_CUCUMBER");
    }

    protected String getSerializationId() {
        return "CUCUMBER_RUN_CONFIG_SETTINGS_ID";
    }

    protected void validateConfiguration() throws RuntimeConfigurationException {
        RunConfigurationUtil.inspectSDK((AbstractRubyRunConfiguration)this);
        RunConfigurationUtil.inspectWorkingDirectory((boolean)false, (AbstractRubyRunConfigurationParams)this);
        BaseCucumberRunConfigurationUtil.inspectFeatureFileOrFolderPath(this);
        this.inspectConfiguredCucumberSupport();
        if (this.shouldUseCustomCucumberRunner()) {
            this.inspectCustomRunnerScript();
        } else {
            this.inspectCucumberExecutable();
        }
        this.inspectCucumberVersion();
        PreLoadUtil.checkPreloadServerSupportEnabled((PreLoadUtil.PreLoadServer)this.myPreloadServer);
    }

    private void inspectCustomRunnerScript() throws RuntimeConfigurationException {
        String scriptPath = this.getCustomCucumberRunnerPath().trim();
        if (StringUtil.isEmpty((String)scriptPath)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.run.configuration.test.custom.runner.not.exists"));
        }
        VirtualFile script = LocalFileSystem.getInstance().findFileByPath(scriptPath);
        if (script == null || !script.exists()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.run.configuration.test.custom.runner.not.exists"));
        }
        if (script.isDirectory()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.run.configuration.test.script.is.dir", (Object[])new Object[]{scriptPath}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void inspectCucumberVersion() throws RuntimeConfigurationException {
        String attachedCucumberGemVersion;
        GemInfo attachedCucumberGem;
        Sdk sdk = this.getSdk();
        if (sdk == null) {
            return;
        }
        if (!this.isGUIRunnerEnabled()) {
            return;
        }
        if (this.shouldUseAlternativeSdk()) {
            if (this.shouldUseCustomCucumberRunner()) return;
            GemInfo installedCucumberGem = CucumberUtil.findLatestCucumberGemIn(this.getModule(), sdk);
            if (installedCucumberGem == null) throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.run.configuration.test.no.gem.in.sdk", (Object[])new Object[]{sdk.getName()}));
            if (CucumberUtil.checkIfVersionIsSupported(installedCucumberGem.getVersion())) return;
            throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.run.configuration.cucumber.gem.version.isnt.supported", (Object[])new Object[]{installedCucumberGem, CucumberUtil.getMinimalSupportedVersion(), sdk.getName()}));
        }
        Module module = this.getModule();
        if (module == null || (attachedCucumberGem = CucumberUtil.getAttachedCucumberGem(module)) == null || CucumberUtil.checkIfVersionIsSupported(attachedCucumberGemVersion = attachedCucumberGem.getVersion())) return;
        throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.run.configuration.cucumber.gem.version.isnt.supported", (Object[])new Object[]{attachedCucumberGemVersion, CucumberUtil.getMinimalSupportedVersion(), sdk.getName()}));
    }

    private void inspectConfiguredCucumberSupport() throws RuntimeConfigurationException {
        Module module = this.getModule();
        if (module == null) {
            return;
        }
        Sdk sdk = this.getSdk();
        assert (sdk != null);
        if (RailsFacetUtil.hasRailsSupport((Module)module) && !CucumberUtil.isCucumberRailsSupportProbablyEnabled(module, sdk)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.run.configuration.cucumber.rails.support.isnt.attached"));
        }
    }

    private void inspectCucumberExecutable() throws RuntimeConfigurationException {
        if (!this.shouldUseCustomCucumberRunner()) {
            Sdk sdkForModule;
            Module module = this.getModule();
            if (module != null && RailsFacetUtil.hasRailsSupport((Module)module)) {
                if (!CucumberUtil.isCucumberScriptSupportInstalledInRailsProject(module)) {
                    throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.run.configuration.test.no.rails.cucumber.scrip.error.run.generator", (Object[])new Object[]{"cucumber:install"}));
                }
                return;
            }
            String cucumberExecutablePath = CucumberUtil.determinePreferredCucumberExecutablePath(module, this.getAlternativeSdk());
            if (cucumberExecutablePath != null) {
                return;
            }
            Sdk alternativeSdk = this.getAlternativeSdk();
            if (alternativeSdk != null) {
                throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.run.configuration.test.no.gem.in.sdk", (Object[])new Object[]{alternativeSdk.getName()}));
            }
            if (module != null && (sdkForModule = RModuleUtil.getInstance().findRubySdkForModule(module)) != null) {
                throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.run.configuration.test.no.gem.in.sdk", (Object[])new Object[]{sdkForModule.getName()}));
            }
            throw new RuntimeConfigurationError(RBundle.message((String)"jdk.no.specified"));
        }
    }

    @NotNull
    protected SettingsEditor<CucumberRunConfiguration> createConfigurationEditor() {
        return new CucumberRunConfigurationEditor(this.getProject(), this);
    }

    protected RubyAbstractCommandLineState createCommandLineState(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(0);
        }
        return new CucumberRunCommandLineState(this, env);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(1);
        }
        super.readExternal(element);
        CucumberRunConfigurationExternalizer.getInstance().readExternal(this, element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(2);
        }
        super.writeExternal(element);
        CucumberRunConfigurationExternalizer.getInstance().writeExternal(this, element);
    }

    @Override
    public String getTagsFilters() {
        return this.myTagsFilter;
    }

    @Override
    public void setTagsFilter(String tagsFilter) {
        this.myTagsFilter = StringUtil.notNullize((String)tagsFilter);
    }

    @Override
    public String getFeatureElementNameFilter() {
        return this.myNamesFilter;
    }

    @Override
    public void setFeatureElementNameFilter(String nameFilter) {
        this.myNamesFilter = StringUtil.notNullize((String)nameFilter);
    }

    @Override
    public String getRunnerOptions() {
        return this.myRunnerArgs;
    }

    @Override
    public void setRunnerOptions(String specArgs) {
        this.myRunnerArgs = StringUtil.notNullize((String)specArgs);
    }

    @Override
    @NotNull
    public List<String> getTestScriptsPaths() {
        List<String> list = Collections.unmodifiableList(this.myTestScriptsPaths);
        if (list == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void setTestScriptsPaths(@NotNull List<String> paths) {
        if (paths == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(4);
        }
        this.myTestScriptsPaths = new ArrayList<String>(paths);
    }

    @Override
    public boolean isBacktraceEnabled() {
        return this.myBacktraceEnabled;
    }

    @Override
    public void setBacktraceEnabled(boolean enabled) {
        this.myBacktraceEnabled = enabled;
    }

    @Override
    public boolean isVerboseEnabled() {
        return this.myVerboseEnabled;
    }

    @Override
    public void setVerboseEnabled(boolean isEnabled) {
        this.myVerboseEnabled = isEnabled;
    }

    protected String getLogTitle() {
        return RBundle.message((String)"cucumber.run.configuration.log.tab.name");
    }

    @NotNull
    protected String getDefaultLogFileName() {
        return "cucumber.log";
    }

    @Override
    public String getCustomCucumberRunnerPath() {
        return StringUtil.notNullize((String)this.myCustomCucumberRunnerPath).trim();
    }

    @Override
    public void setCustomCucumberRunnerPath(String specsRunnerPath) {
        this.myCustomCucumberRunnerPath = CucumberRunConfiguration.asSysIndependentPath((String)specsRunnerPath);
    }

    @Override
    public void setShouldUseCustomCucumberRunner(boolean useCustomRunner) {
        this.myUseCustomCucumberRunner = useCustomRunner;
    }

    @Override
    public boolean shouldUseCustomCucumberRunner() {
        return this.myUseCustomCucumberRunner;
    }

    @Override
    @NotNull
    public PreLoadUtil.PreLoadServer getPreloadServer() {
        PreLoadUtil.PreLoadServer preLoadServer = this.myPreloadServer;
        if (preLoadServer == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(5);
        }
        return preLoadServer;
    }

    @Override
    public void setPreloadServer(@NotNull PreLoadUtil.PreLoadServer server) {
        if (server == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(6);
        }
        this.myPreloadServer = server;
    }

    public boolean isBundlerContextAllowed() {
        return CucumberRunConfiguration.isBundlerContextAllowed((PreLoadUtil.PreLoadServer)this.getPreloadServer(), (Module)this.getModule());
    }

    @NotNull
    public SupportedTestFramework getTestFramework() {
        SupportedTestFramework supportedTestFramework = SupportedTestFramework.CUCUMBER;
        if (supportedTestFramework == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(7);
        }
        return supportedTestFramework;
    }

    public boolean shouldAttachTestRunnerConsole() {
        return this.isGUIRunnerEnabled();
    }

    public boolean isGUIRunnerEnabled() {
        String options = this.getRunnerOptions();
        return !CucumberRunConfiguration.containsOptionKey((String)options, (String)"--format") && !CucumberRunConfiguration.containsOptionKey((String)options, (String)"-f") && !CucumberRunConfiguration.containsOptionKey((String)options, (String)"--drb");
    }

    @Nullable
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        if (executor == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(8);
        }
        return this.shouldAttachTestRunnerConsole() ? super.createTestConsoleProperties(executor) : null;
    }

    @NotNull
    protected String doGetActionName() {
        String string = RBundle.message((String)"cucumber.run.configuration.prefix", (Object[])new Object[]{this.getName()});
        if (string == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void collectSettingChangesOnApply(@NotNull FusCollectSettingChangesRunConfiguration oldRunConfiguration) {
        if (oldRunConfiguration == null) {
            CucumberRunConfiguration.$$$reportNull$$$0(10);
        }
        super.collectSettingChangesOnApply(oldRunConfiguration);
        if (this.getClass() == oldRunConfiguration.getClass()) {
            CucumberRunConfiguration oldRspecConfiguration = (CucumberRunConfiguration)oldRunConfiguration;
            PreLoadUtil.PreLoadServer newPreloadServerType = this.getPreloadServer();
            PreLoadUtil.PreLoadServer oldPreloadServerType = oldRspecConfiguration.getPreloadServer();
            if (oldPreloadServerType != newPreloadServerType) {
                RubyRunConfigurationSettingChangesCollector.logPreloadServerChange((ConfigurationType)this.getType(), (PreLoadUtil.PreLoadServer)oldPreloadServerType, (PreLoadUtil.PreLoadServer)newPreloadServerType);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/cucumber/run/CucumberRunConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/run/CucumberRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestScriptsPaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreloadServer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFramework";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLineState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTestScriptsPaths";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setPreloadServer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectSettingChangesOnApply";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 9 -> new IllegalStateException(string);
        };
    }
}

