/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.run;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;
import org.jetbrains.plugins.cucumber.psi.GherkinPsiUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFileImpl;
import org.jetbrains.plugins.ruby.cucumber.CucumberUtil;
import org.jetbrains.plugins.ruby.cucumber.run.BaseCucumberRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.testing.RubyTestFrameworksUtil;

public abstract class BaseCucumberRunConfigurationProducer
extends LazyRunConfigurationProducer<BaseCucumberRunConfiguration> {
    private static final Logger LOG = Logger.getInstance(BaseCucumberRunConfigurationProducer.class);

    protected abstract boolean isSameRunConfigurationType(RunConfiguration var1);

    protected abstract void applyExtensionsToConfiguration(Location var1, RunConfiguration var2);

    protected abstract boolean isApplicable(@NotNull PsiElement var1, @Nullable Module var2);

    public boolean isConfigurationFromContext(@NotNull BaseCucumberRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Location location;
        if (configuration == null) {
            BaseCucumberRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            BaseCucumberRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if ((location = context.getLocation()) == null) {
            LOG.debug("No location in context");
            return false;
        }
        PsiElement locationElement = location.getPsiElement();
        if (!this.isApplicable(locationElement, context.getModule())) {
            LOG.debug("Location element is not applicable. Element: ", new Object[]{locationElement, "; module: ", context.getModule()});
            return false;
        }
        PsiElement[] psiArray = RubyTestFrameworksUtil.getPsiElementArray((DataContext)context.getDataContext());
        if (psiArray.length == 1 && psiArray[0] instanceof PsiDirectory) {
            LOG.debug("Psi directory in the context: ", new Object[]{psiArray[0]});
            return false;
        }
        Set featureFilesPaths = ContainerUtil.map2Set(BaseCucumberRunConfigurationProducer.getFeatureFiles(context, location), file -> file.getPath());
        if (featureFilesPaths.isEmpty()) {
            LOG.debug("No features files path");
            return false;
        }
        if (!this.isSameRunConfigurationType(configuration)) {
            LOG.debug("Same run configuration type with ", new Object[]{configuration});
            return false;
        }
        if (configuration.getTestType() != AbstractRubyTestsRunConfigurationParams.TestType.CUSTOM_SET_OF_FILES) {
            LOG.debug("Wrong test type: ", new Object[]{configuration.getTestType()});
            return false;
        }
        HashSet<String> paths = new HashSet<String>(configuration.getTestScriptsPaths());
        if (!paths.equals(featureFilesPaths)) {
            LOG.debug("Paths mismatch. paths: ", new Object[]{paths, "; featureFilesPaths: ", featureFilesPaths});
            return false;
        }
        String candidateFeatureElemFilter = configuration.getFeatureElementNameFilter();
        String filter = StringUtil.notNullize((String)CucumberUtil.determineCurrentScenarioName(locationElement));
        return candidateFeatureElemFilter.equals(filter);
    }

    public boolean setupConfigurationFromContext(@NotNull BaseCucumberRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref sourceElement) {
        Module module;
        Location location;
        if (configuration == null) {
            BaseCucumberRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (context == null) {
            BaseCucumberRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (sourceElement == null) {
            BaseCucumberRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        PsiElement locationElement = location.getPsiElement();
        if (!this.isApplicable(locationElement, module = ModuleUtilCore.findModuleForPsiElement((PsiElement)locationElement))) {
            return false;
        }
        PsiElement[] psiArray = RubyTestFrameworksUtil.getPsiElementArray((DataContext)context.getDataContext());
        if (psiArray.length == 1 && psiArray[0] instanceof PsiDirectory) {
            return false;
        }
        Project project = location.getProject();
        List<VirtualFile> featureFiles = BaseCucumberRunConfigurationProducer.getFeatureFiles(context, location);
        if (featureFiles.isEmpty()) {
            return false;
        }
        if (module == null) {
            return false;
        }
        configuration.setModule(module);
        GherkinStepsHolder scenario = (GherkinStepsHolder)PsiTreeUtil.getNonStrictParentOfType((PsiElement)locationElement, (Class[])new Class[]{GherkinStepsHolder.class});
        String scenarioName = null;
        Object configurationName = RubyTestFrameworksUtil.createConfName(featureFiles);
        if (scenario != null && !BaseCucumberRunConfigurationProducer.isScenarioBackground(scenario)) {
            scenarioName = scenario.getScenarioName();
            configurationName = scenario.getScenarioKeyword() + ": " + scenarioName;
        }
        configuration.setName((String)configurationName);
        RunConfigurationUtil.setCucumberWorkingDirectoryIfNecessary((AbstractRubyRunConfigurationParams)configuration, (VirtualFile)featureFiles.get(0), (Project)project, (Module)module);
        this.initCucumberSpecificSettings(configuration, project, module, featureFiles, scenarioName);
        this.applyExtensionsToConfiguration(location, configuration);
        return true;
    }

    private static boolean isScenarioBackground(@Nullable GherkinStepsHolder scenario) {
        return scenario instanceof GherkinScenario && ((GherkinScenario)scenario).isBackground();
    }

    @Nullable
    private static VirtualFile getFeatureFileByLocation(@NotNull Location<?> location) {
        if (location == null) {
            BaseCucumberRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        GherkinFileImpl containingFile = GherkinPsiUtil.getGherkinFile((PsiElement)location.getPsiElement());
        VirtualFile file = location.getVirtualFile();
        if (containingFile == null || file == null) {
            return null;
        }
        assert (FileTypeRegistry.getInstance().isFileOfType(file, (FileType)GherkinFileType.INSTANCE));
        return file;
    }

    protected void initCucumberSpecificSettings(@NotNull BaseCucumberRunConfiguration conf, @NotNull Project project, @Nullable Module module, @NotNull List<VirtualFile> files, @Nullable String scenarioName) {
        if (conf == null) {
            BaseCucumberRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (project == null) {
            BaseCucumberRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (files == null) {
            BaseCucumberRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        conf.setTestType(AbstractRubyTestsRunConfigurationParams.TestType.CUSTOM_SET_OF_FILES);
        conf.setTestScriptsPaths(ContainerUtil.map(files, file -> file.getPath()));
        JRubySdkUtil.enableObjectSpaceIfNotOverriddenByUser((AbstractRubyRunConfigurationParams)conf);
        if (!StringUtil.isEmpty((String)scenarioName)) {
            conf.setFeatureElementNameFilter("^" + RubyTextUtil.escapeRegexSpecialCharacters((String)scenarioName, (Character[])new Character[0]) + "$");
        }
    }

    @NotNull
    private static List<VirtualFile> getFeatureFiles(@NotNull ConfigurationContext context, @NotNull Location<?> location) {
        List files;
        if (context == null) {
            BaseCucumberRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if (location == null) {
            BaseCucumberRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        if ((files = RubyTestFrameworksUtil.getAndFlattenAllSelectedFiles((DataContext)context.getDataContext(), (Condition)Conditions.alwaysTrue())).isEmpty()) {
            VirtualFile fileByLocation = BaseCucumberRunConfigurationProducer.getFeatureFileByLocation(location);
            List list = ContainerUtil.createMaybeSingletonList((Object)fileByLocation);
            if (list == null) {
                BaseCucumberRunConfigurationProducer.$$$reportNull$$$0(11);
            }
            return list;
        }
        List list = ContainerUtil.filter((Collection)files, file -> FileTypeRegistry.getInstance().isFileOfType(file, (FileType)GherkinFileType.INSTANCE));
        if (list == null) {
            BaseCucumberRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/cucumber/run/BaseCucumberRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/run/BaseCucumberRunConfigurationProducer";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureFileByLocation";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "initCucumberSpecificSettings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureFiles";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12 -> new IllegalStateException(string);
        };
    }
}

