/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.ruby.steps;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.AbstractStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.ruby.cucumber.inspections.StepDefinitionsSnippetsFactory;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RRegexpLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

final class RubyStepDefinitionCreator
extends AbstractStepDefinitionCreator {
    private static final String RUBY_FILE_EXTENSION = "." + RubyFileType.RUBY.getDefaultExtension();

    RubyStepDefinitionCreator() {
    }

    @NotNull
    public PsiFile createStepDefinitionContainer(@NotNull PsiDirectory dir, @NotNull String name) {
        if (dir == null) {
            RubyStepDefinitionCreator.$$$reportNull$$$0(0);
        }
        if (name == null) {
            RubyStepDefinitionCreator.$$$reportNull$$$0(1);
        }
        PsiFile psiFile = (PsiFile)WriteAction.compute(() -> dir.createFile(name + RUBY_FILE_EXTENSION));
        if (psiFile == null) {
            RubyStepDefinitionCreator.$$$reportNull$$$0(2);
        }
        return psiFile;
    }

    public boolean createStepDefinition(@NotNull GherkinStep step, @NotNull PsiFile file, boolean withTemplate) {
        if (step == null) {
            RubyStepDefinitionCreator.$$$reportNull$$$0(3);
        }
        if (file == null) {
            RubyStepDefinitionCreator.$$$reportNull$$$0(4);
        }
        if (!(file instanceof RFile)) {
            return false;
        }
        Project project = file.getProject();
        this.closeActiveTemplateBuilders(file);
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        String text = StepDefinitionsSnippetsFactory.getInstance().makeSnippet(step);
        RDoBlockCall element = (RDoBlockCall)RubyElementFactoryCore.createElementFromText((PsiElement)file, (String)text);
        file.add(RubyElementFactoryCore.createNewLine((PsiElement)file));
        file.add(RubyElementFactoryCore.createNewLine((PsiElement)file));
        RDoBlockCall addedElement = (RDoBlockCall)file.add((PsiElement)element);
        addedElement = (RDoBlockCall)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)addedElement);
        RCall call = (RCall)addedElement.getCall();
        RRegexpLiteral regexpLiteral = (RRegexpLiteral)call.getArguments().get(0);
        int regexpLiteralLength = regexpLiteral.getTextLength();
        List statements = addedElement.getBlock().getCompoundStatement().getStatements();
        if (!withTemplate) {
            return true;
        }
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)addedElement);
        builder.replaceElement((PsiElement)regexpLiteral, new TextRange(2, regexpLiteralLength - 2), regexpLiteral.getText().substring(2, regexpLiteralLength - 2));
        RBlockArgumentList blockVars = addedElement.getBlock().getBlockArguments();
        if (blockVars != null) {
            for (RArgument var : blockVars.getArguments()) {
                builder.replaceElement((PsiElement)var, var.getName());
            }
        }
        if (!statements.isEmpty()) {
            builder.replaceElement((PsiElement)statements.get(0), "pending");
        }
        assert (editor != null);
        builder.run(editor, false);
        return true;
    }

    @NotNull
    public String getDefaultStepFileName(@NotNull GherkinStep step) {
        if (step == null) {
            RubyStepDefinitionCreator.$$$reportNull$$$0(5);
        }
        return "my_steps";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/cucumber/ruby/steps/RubyStepDefinitionCreator";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/ruby/steps/RubyStepDefinitionCreator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepDefinitionContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinitionContainer";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStepFileName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

