/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.ruby.steps;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.steps.AbstractCucumberExtension;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.ruby.cucumber.CucumberUtil;
import org.jetbrains.plugins.ruby.cucumber.ruby.RubyCucumberCallData;
import org.jetbrains.plugins.ruby.cucumber.ruby.RubyCucumberCallIndex;
import org.jetbrains.plugins.ruby.cucumber.ruby.steps.RubyStep3Definition;
import org.jetbrains.plugins.ruby.cucumber.ruby.steps.RubyStepDefinition;
import org.jetbrains.plugins.ruby.cucumber.ruby.steps.RubyStepDefinitionCreator;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;

final class RubyCucumberExtension
extends AbstractCucumberExtension {
    RubyCucumberExtension() {
    }

    public boolean isStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            RubyCucumberExtension.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            RubyCucumberExtension.$$$reportNull$$$0(1);
        }
        return parent instanceof PsiDirectory && child instanceof RFile;
    }

    public boolean isWritableStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        Module[] modules;
        if (child == null) {
            RubyCucumberExtension.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            RubyCucumberExtension.$$$reportNull$$$0(3);
        }
        if (!this.isStepLikeFile(child, parent)) {
            return false;
        }
        for (Module module : modules = ModuleManager.getInstance((Project)child.getProject()).getModules()) {
            if (!module.getModuleScope(true).uniteWith(module.getModuleContentScope()).accept(child.getContainingFile().getVirtualFile())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public BDDFrameworkType getStepFileType() {
        return new BDDFrameworkType((FileType)RubyFileType.RUBY);
    }

    @NotNull
    public StepDefinitionCreator getStepDefinitionCreator() {
        return new RubyStepDefinitionCreator();
    }

    @Nullable
    public String getStepName(@NotNull PsiElement step) {
        if (step == null) {
            RubyCucumberExtension.$$$reportNull$$$0(4);
        }
        if (step instanceof RListOfExpressions) {
            RCall stepCall = CucumberUtil.getStepInvocation(step);
            if (stepCall == null) {
                return null;
            }
            PsiElement parameter = (PsiElement)stepCall.getArguments().get(0);
            return CucumberUtil.getStepNameFromStepCall(parameter);
        }
        return super.getStepName(step);
    }

    public static List<AbstractStepDefinition> getAllStepDefinitions(@NotNull Module module) {
        if (module == null) {
            RubyCucumberExtension.$$$reportNull$$$0(5);
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)true).uniteWith(module.getModuleContentWithDependenciesScope());
        Collection cucumberCalls = (Collection)ReadAction.compute(() -> RubyCucumberCallIndex.getInstance().getElements(module.getProject(), (SearchScope)scope, "step"));
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        for (RCall call : cucumberCalls) {
            Object callData = call.getData(new RubyCallType[0]);
            if (!(callData instanceof RubyCucumberCallData)) continue;
            RubyStepDefinition stepDefinition = ((RubyCucumberCallData)callData).isRegex() ? new RubyStepDefinition((PsiElement)call) : new RubyStep3Definition((PsiElement)call);
            result.add(stepDefinition);
        }
        return result;
    }

    public List<AbstractStepDefinition> loadStepsFor(@Nullable PsiFile featureFile, @NotNull Module module) {
        if (module == null) {
            RubyCucumberExtension.$$$reportNull$$$0(6);
        }
        return RubyCucumberExtension.getAllStepDefinitions(module);
    }

    public Collection<? extends PsiFile> getStepDefinitionContainers(@NotNull GherkinFile file) {
        Module module;
        if (file == null) {
            RubyCucumberExtension.$$$reportNull$$$0(7);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            return Collections.emptySet();
        }
        List stepDefs = org.jetbrains.plugins.cucumber.CucumberUtil.loadFrameworkSteps((CucumberJvmExtensionPoint)this, (PsiFile)file, (Module)module);
        HashSet<PsiFile> result = new HashSet<PsiFile>();
        for (AbstractStepDefinition stepDef : stepDefs) {
            PsiFile psiFile;
            PsiElement stepDefElement = stepDef.getElement();
            if (stepDefElement == null || !this.isWritableStepLikeFile((PsiElement)(psiFile = stepDefElement.getContainingFile()), (PsiElement)psiFile.getParent())) continue;
            result.add(psiFile);
        }
        return result;
    }

    public boolean isGherkin6Supported(@NotNull Module module) {
        GemInfo cucumberGemInfo;
        if (module == null) {
            RubyCucumberExtension.$$$reportNull$$$0(8);
        }
        if ((cucumberGemInfo = RubyProjectGemSearchService.Companion.findGem(module, "cucumber")) != null) {
            return VersionComparatorUtil.compare((String)"4.0.0.a", (String)cucumberGemInfo.getVersion()) <= 0;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/ruby/steps/RubyCucumberExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isStepLikeFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isWritableStepLikeFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getStepName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllStepDefinitions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "loadStepsFor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getStepDefinitionContainers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isGherkin6Supported";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

