/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.inspections;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinPystring;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCell;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;
import org.jetbrains.plugins.ruby.cucumber.inspections.CucumberOriginalStepDefinitionsSnippetProvider;
import org.jetbrains.plugins.ruby.cucumber.inspections.MultilineArgClassStub;
import org.jetbrains.plugins.ruby.cucumber.inspections.StepDefinitionsSnippetProvider;

public class StepDefinitionsSnippetsFactory {
    private final StepDefinitionsSnippetProvider myProvider = new CucumberOriginalStepDefinitionsSnippetProvider();
    private static final Logger LOG = Logger.getInstance(StepDefinitionsSnippetsFactory.class);
    private static final String TO_STRING_CELL_DELIMITER = ", ";
    private static final String TABLE_TO_STRING_PREFIX = "table.hashes.keys # => [";

    public static StepDefinitionsSnippetsFactory getInstance() {
        return (StepDefinitionsSnippetsFactory)ApplicationManager.getApplication().getService(StepDefinitionsSnippetsFactory.class);
    }

    public String makeSnippet(@NotNull GherkinStep step) {
        GherkinKeywordProvider keywordProvider;
        String baseKeyword;
        if (step == null) {
            StepDefinitionsSnippetsFactory.$$$reportNull$$$0(0);
        }
        String keyword = (baseKeyword = (keywordProvider = JsonGherkinKeywordProvider.getKeywordProvider()).getBaseKeyword("en", step.getKeyword().getText())) == null ? "When" : baseKeyword;
        String stepName = step.getName();
        MultilineArgClassStub multilineArgClass = StepDefinitionsSnippetsFactory.getMultiLineArgClass(step);
        try {
            return this.myProvider.makeSnippet(keyword, stepName, multilineArgClass);
        }
        catch (Throwable e) {
            LOG.warn("Snippet provider wasn't able to process keyword=[" + keyword + "], stepName=[" + stepName + "], multilineArg=[" + String.valueOf(multilineArgClass) + "]. Exception message: " + e.getMessage() + "(" + e.getClass().getName() + ").Default dummy implementation will be used", e);
            return StepDefinitionsSnippetsFactory.generateStupidDefinition(keyword, stepName);
        }
    }

    @Nullable
    private static MultilineArgClassStub getMultiLineArgClass(@NotNull GherkinStep step) {
        GherkinPystring pystring;
        if (step == null) {
            StepDefinitionsSnippetsFactory.$$$reportNull$$$0(1);
        }
        if ((pystring = step.getPystring()) != null) {
            return new MultilineArgClassStub(MultilineArgClassStub.Type.TEXT, pystring.getText());
        }
        GherkinTable table = step.getTable();
        if (table != null) {
            GherkinTableRow headerRowElement = table.getHeaderRow();
            StringBuilder sb = new StringBuilder(TABLE_TO_STRING_PREFIX);
            if (headerRowElement != null && !headerRowElement.getPsiCells().isEmpty()) {
                boolean smthAdded = false;
                for (GherkinTableCell cell : headerRowElement.getPsiCells()) {
                    String cellName = cell.getName();
                    if (cellName == null || cellName.isEmpty()) continue;
                    smthAdded = true;
                    sb.append(':').append(cellName).append(TO_STRING_CELL_DELIMITER);
                }
                if (smthAdded) {
                    sb.delete(sb.length() - TO_STRING_CELL_DELIMITER.length(), sb.length());
                }
            }
            sb.append("]");
            return new MultilineArgClassStub(MultilineArgClassStub.Type.TABLE, sb.toString());
        }
        return null;
    }

    private static String generateStupidDefinition(@NotNull String keyword, @NotNull String stepName) {
        if (keyword == null) {
            StepDefinitionsSnippetsFactory.$$$reportNull$$$0(2);
        }
        if (stepName == null) {
            StepDefinitionsSnippetsFactory.$$$reportNull$$$0(3);
        }
        String regexpText = "/^" + StringUtil.escapeToRegexp((String)stepName) + "$/";
        return keyword + "(" + regexpText + ") do\n  pending\nend\n";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/inspections/StepDefinitionsSnippetsFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "makeSnippet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getMultiLineArgClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "generateStupidDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

