/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.inspections;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.ruby.cucumber.inspections.MultilineArgClassStub;
import org.jetbrains.plugins.ruby.cucumber.inspections.StepDefinitionsSnippetProvider;

public class CucumberOriginalStepDefinitionsSnippetProvider
implements StepDefinitionsSnippetProvider {
    public static final String ESCAPED_PARAM_PATTERN = "(<[^>]*>)|(\\d+)[ ,.]|(\"([^\\\\\"]*)\")";
    private static final Pattern ESCAPED_PARAM_REGEXP = Pattern.compile("(<[^>]*>)|(\\d+)[ ,.]|(\"([^\\\\\"]*)\")");
    public static final String ARGUMENT_TEMPLATE = "arg";

    protected static String snippetText(@NotNull String stepKeyword, @NotNull String stepName, @Nullable MultilineArgClassStub multilineArgName) {
        List<String> argumentsBlock;
        if (stepKeyword == null) {
            CucumberOriginalStepDefinitionsSnippetProvider.$$$reportNull$$$0(0);
        }
        if (stepName == null) {
            CucumberOriginalStepDefinitionsSnippetProvider.$$$reportNull$$$0(1);
        }
        String escaped = Pattern.quote(stepName);
        escaped = StringUtil.trimEnd((String)StringUtil.trimStart((String)escaped, (String)"\\Q"), (String)"\\E");
        escaped = CucumberUtil.prepareStepRegexp((String)escaped);
        ArrayList<String> arguments = new ArrayList<String>();
        Matcher m = ESCAPED_PARAM_REGEXP.matcher(stepName);
        while (m.find()) {
            String argument = m.group();
            if (argument.startsWith("<")) {
                arguments.add(argument.substring(1, argument.length() - 1));
                continue;
            }
            arguments.add(ARGUMENT_TEMPLATE);
        }
        if (multilineArgName != null) {
            arguments.add(multilineArgName.defaultArgName());
        }
        String prepearedArguments = !(argumentsBlock = CucumberOriginalStepDefinitionsSnippetProvider.prepareBlockArguments(arguments)).isEmpty() ? String.format("|%s|", StringUtil.join(argumentsBlock, (String)", ")) : "";
        String multilieArgComment = "";
        if (multilineArgName != null && multilineArgName.isTable()) {
            multilieArgComment = String.format("# %s is a %s\n", multilineArgName.defaultArgName(), multilineArgName.toString());
        }
        return String.format("%s(/^%s$/) do %s\n  %spending\nend", stepKeyword, escaped, prepearedArguments, multilieArgComment);
    }

    private static String prepareBlockArgument(@NotNull String argument) {
        if (argument == null) {
            CucumberOriginalStepDefinitionsSnippetProvider.$$$reportNull$$$0(2);
        }
        StringBuilder result = new StringBuilder();
        boolean lastWasAccepted = false;
        for (int i = 0; i < argument.length(); ++i) {
            char c = argument.charAt(i);
            if (c == '_' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') {
                result.append(c);
                lastWasAccepted = true;
                continue;
            }
            if (lastWasAccepted) {
                result.append('_');
            }
            lastWasAccepted = false;
        }
        if (result.charAt(result.length() - 1) == '_') {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    private static List<String> prepareBlockArguments(@NotNull List<String> arguments) {
        if (arguments == null) {
            CucumberOriginalStepDefinitionsSnippetProvider.$$$reportNull$$$0(3);
        }
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<Integer> resultNumbers = new ArrayList<Integer>();
        HashMap<String, Integer> parametersCount = new HashMap<String, Integer>();
        for (String argument : arguments) {
            argument = CucumberOriginalStepDefinitionsSnippetProvider.prepareBlockArgument(argument);
            int count = parametersCount.merge(argument, 1, Integer::sum);
            result.add(argument);
            resultNumbers.add(count);
        }
        for (int i = 0; i < result.size(); ++i) {
            if ((Integer)parametersCount.get(result.get(i)) <= 1) continue;
            result.set(i, (String)result.get(i) + String.valueOf(resultNumbers.get(i)));
        }
        return result;
    }

    @Override
    public String makeSnippet(@NotNull String stepKeyword, @NotNull String stepName, @Nullable MultilineArgClassStub multilineArgName) {
        if (stepKeyword == null) {
            CucumberOriginalStepDefinitionsSnippetProvider.$$$reportNull$$$0(4);
        }
        if (stepName == null) {
            CucumberOriginalStepDefinitionsSnippetProvider.$$$reportNull$$$0(5);
        }
        return CucumberOriginalStepDefinitionsSnippetProvider.snippetText(stepKeyword, stepName, multilineArgName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepKeyword";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/inspections/CucumberOriginalStepDefinitionsSnippetProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "snippetText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareBlockArgument";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareBlockArguments";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "makeSnippet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

