/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.dap.impl;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.platform.dap.DapLaunchArgumentsProvider;
import com.intellij.platform.dap.DapProcessStarter;
import com.intellij.platform.dap.impl.utils.UtilsKt;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebuggerManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\bH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/dap/impl/DapProgramRunner;", "Lcom/intellij/execution/runners/AsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "<init>", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "getRunnerId", "intellij.platform.dap"})
public final class DapProgramRunner
extends AsyncProgramRunner<RunnerSettings> {
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        if (!(profile instanceof DapLaunchArgumentsProvider)) {
            return false;
        }
        String string = executorId;
        return Intrinsics.areEqual((Object)string, (Object)"Debug") ? !(profile instanceof RunConfigurationWithSuppressedDefaultDebugAction) : (Intrinsics.areEqual((Object)string, (Object)"Run") ? !(profile instanceof RunConfigurationWithSuppressedDefaultRunAction) : false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Promise promise;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        RunProfile runProfile = environment.getRunProfile();
        Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"getRunProfile(...)");
        RunProfile runProfile2 = runProfile;
        if (!(runProfile2 instanceof DapLaunchArgumentsProvider)) {
            throw new IllegalArgumentException("Debug Adapter support requires a run profile that implements " + Reflection.getOrCreateKotlinClass(DapLaunchArgumentsProvider.class).getSimpleName());
        }
        Executor executor = environment.getExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getExecutor(...)");
        Executor executor2 = executor;
        DapProcessStarter processStarter = new DapProcessStarter(environment, executor2, state, ((DapLaunchArgumentsProvider)runProfile2).getAdapterId(), ((DapLaunchArgumentsProvider)runProfile2).getRequest(), ((DapLaunchArgumentsProvider)runProfile2).arguments());
        String string = executor2.getId();
        switch (string.hashCode()) {
            case 82539: {
                if (string.equals("Run")) break;
                throw new IllegalArgumentException("Unsupported executor id: " + executor2.getId());
            }
            case 65906227: {
                if (!string.equals("Debug")) throw new IllegalArgumentException("Unsupported executor id: " + executor2.getId());
                promise = Promises.resolvedPromise((Object)XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, (XDebugProcessStarter)processStarter).getRunContentDescriptor());
                return promise;
            }
        }
        promise = UtilsKt.toPromise(processStarter.startNoDebug());
        return promise;
        throw new IllegalArgumentException("Unsupported executor id: " + executor2.getId());
    }

    @NotNull
    public String getRunnerId() {
        return "DebugAdapterRunner";
    }
}

