/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ruby.ift;

import com.intellij.CommonBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.text.VersionComparatorUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.version.management.SdkRefresherUtilKt;
import org.jetbrains.ruby.ift.RubyLessonsBundle;
import training.FeaturesTrainerIcons;
import training.lang.AbstractLangSupport;
import training.lang.LangSupport;
import training.learn.LearnBundle;
import training.learn.exceptons.InvalidSdkException;
import training.learn.exceptons.NoSdkException;
import training.project.ReadMeCreator;
import training.util.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0013H\u0017J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00110!H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010,\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0016\u0010\n\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u0014\u0010\u001c\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007R\u0014\u0010\u001e\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0007R\u0018\u0010&\u001a\u00020'*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0007\u00a8\u0006-"}, d2={"Lorg/jetbrains/ruby/ift/RubyLangSupport;", "Ltraining/lang/AbstractLangSupport;", "<init>", "()V", "rubyProjectName", "", "getRubyProjectName", "()Ljava/lang/String;", "scratchFileName", "getScratchFileName", "langCourseFeedback", "getLangCourseFeedback", "readMeCreator", "Ltraining/project/ReadMeCreator;", "getReadMeCreator", "()Ltraining/project/ReadMeCreator;", "checkSdk", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "getSdkForProject", "selectedSdk", "showSdkNotFoundDialog", "applyProjectSdk", "contentRootDirectoryName", "getContentRootDirectoryName", "primaryLanguage", "getPrimaryLanguage", "defaultProductName", "getDefaultProductName", "applyToProjectAfterConfigure", "Lkotlin/Function1;", "blockProjectFileModification", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "getModule", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/openapi/module/Module;", "sampleFilePath", "getSampleFilePath", "isSdkConfigured", "intellij.ruby.featuresTrainer"})
public final class RubyLangSupport
extends AbstractLangSupport {
    @NotNull
    private final String scratchFileName;
    @NotNull
    private final ReadMeCreator readMeCreator = new ReadMeCreator();
    @NotNull
    private final String defaultProductName;
    @NotNull
    private final String sampleFilePath;

    public RubyLangSupport() {
        this.scratchFileName = "Learning.rb";
        this.defaultProductName = "RubyMine";
        this.sampleFilePath = "src/sandbox.rb";
    }

    private final String getRubyProjectName() {
        return "RubyMineLearningProject";
    }

    @NotNull
    public String getScratchFileName() {
        return this.scratchFileName;
    }

    @Nullable
    public String getLangCourseFeedback() {
        return UtilsKt.getFeedbackLink((LangSupport)((LangSupport)this), (boolean)false);
    }

    @NotNull
    public ReadMeCreator getReadMeCreator() {
        return this.readMeCreator;
    }

    public void checkSdk(@Nullable Sdk sdk, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!Intrinsics.areEqual((Object)project.getName(), (Object)this.getRubyProjectName())) {
            return;
        }
        if (sdk == null) {
            throw new NoSdkException();
        }
        if (!(sdk.getSdkType() instanceof RubySdkType)) {
            throw new InvalidSdkException(LearnBundle.INSTANCE.message("dialog.message.jdk.ruby.required", new Object[0]));
        }
        String string = sdk.getVersionString();
        if (string == null) {
            throw new InvalidSdkException(LearnBundle.INSTANCE.message("dialog.message.jdk.ruby.version.missed", new Object[0]));
        }
        String string2 = RubyVersionUtil.getShortVersion((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortVersion(...)");
        String rubyVersion = string2;
        if (VersionComparatorUtil.compare((String)rubyVersion, (String)"2.3.0") < 0) {
            throw new InvalidSdkException(LearnBundle.INSTANCE.message("dialog.message.jdk.ruby.version.required", new Object[0]));
        }
    }

    @RequiresEdt
    @Nullable
    public Sdk getSdkForProject(@NotNull Project project, @Nullable Sdk selectedSdk) {
        Sdk sdk;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            sdk = super.getSdkForProject(project, selectedSdk);
        }
        catch (NoSdkException e) {
            Sdk sdk2;
            SdkRefresherUtilKt.refreshAll();
            try {
                sdk2 = super.getSdkForProject(project, selectedSdk);
            }
            catch (NoSdkException e2) {
                this.showSdkNotFoundDialog(project);
                sdk2 = null;
            }
            sdk = sdk2;
        }
        return sdk;
    }

    private final void showSdkNotFoundDialog(Project project) {
        int decision = Messages.showOkCancelDialog((Project)project, (String)RubyLessonsBundle.INSTANCE.message("ruby.sdk.not.found.dialog.message", new Object[0]), (String)RubyLessonsBundle.INSTANCE.message("ruby.sdk.not.found.dialog.title", new Object[0]), (String)RubyLessonsBundle.INSTANCE.message("ruby.sdk.not.found.dialog.ok", new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)FeaturesTrainerIcons.PluginIcon);
        if (decision == 0) {
            ShowSettingsUtil.getInstance().showSettingsDialog(project, RBundle.message((String)"ruby.ide.sdk.configurable.name"));
        }
    }

    @RequiresEdt
    public void applyProjectSdk(@NotNull Sdk sdk, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super.applyProjectSdk(sdk, project);
        RModuleUtil.getInstance().changeModuleSdk(sdk, this.getModule(project));
    }

    @NotNull
    public String getContentRootDirectoryName() {
        return this.getRubyProjectName();
    }

    @NotNull
    public String getPrimaryLanguage() {
        return "ruby";
    }

    @NotNull
    public String getDefaultProductName() {
        return this.defaultProductName;
    }

    @NotNull
    public Function1<Project, Unit> applyToProjectAfterConfigure() {
        return RubyLangSupport::applyToProjectAfterConfigure$lambda$0;
    }

    public boolean blockProjectFileModification(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    private final Module getModule(Project $this$module) {
        boolean bl;
        Module[] modules = ModuleManager.Companion.getInstance($this$module).getModules();
        boolean bl2 = bl = modules.length == 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return modules[0];
    }

    @NotNull
    public String getSampleFilePath() {
        return this.sampleFilePath;
    }

    public boolean isSdkConfigured(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Sdk sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        return (sdk != null ? sdk.getSdkType() : null) instanceof RubySdkType;
    }

    private static final Unit applyToProjectAfterConfigure$lambda$0(Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }
}

