/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.terminal;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.completion.spec.ShellCommandResult;
import com.intellij.terminal.completion.spec.ShellCommandSpec;
import com.intellij.terminal.completion.spec.ShellCompletionSuggestion;
import com.intellij.terminal.completion.spec.ShellRuntimeContext;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.terminal.CompletionUtilKt;
import org.jetbrains.plugins.ruby.terminal.RubyShellCommandSpecsProvider;
import org.jetbrains.plugins.ruby.terminal.RubyTerminalBundle;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellCommandSpecApiKt;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellCommandSpecConflictStrategy;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellCommandSpecInfo;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellCommandSpecsProvider;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellDataGenerators;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellRuntimeContextExtensionsKt;
import org.jetbrains.plugins.terminal.block.completion.spec.dsl.ShellArgumentContext;
import org.jetbrains.plugins.terminal.block.completion.spec.dsl.ShellChildCommandsContext;
import org.jetbrains.plugins.terminal.block.completion.spec.dsl.ShellChildOptionsContext;
import org.jetbrains.plugins.terminal.block.completion.spec.dsl.ShellCommandContext;
import org.jetbrains.plugins.terminal.block.completion.spec.dsl.ShellOptionContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u001f\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/ruby/terminal/RubyShellCommandSpecsProvider;", "Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellCommandSpecsProvider;", "<init>", "()V", "FEATURES", "", "", "Lorg/jetbrains/annotations/Nls;", "RAKE_HELP_OPTIONS_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "IRB_HELP_OPTIONS_PATTERN", "PRY_HELP_OPTIONS_PATTERN", "RSPEC_HELP_OPTIONS_PATTERN", "getCommandSpecs", "", "Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellCommandSpecInfo;", "intellij.ruby.terminal"})
public final class RubyShellCommandSpecsProvider
implements ShellCommandSpecsProvider {
    @NotNull
    private final Map<String, String> FEATURES;
    private final Pattern RAKE_HELP_OPTIONS_PATTERN;
    private final Pattern IRB_HELP_OPTIONS_PATTERN;
    private final Pattern PRY_HELP_OPTIONS_PATTERN;
    private final Pattern RSPEC_HELP_OPTIONS_PATTERN;

    public RubyShellCommandSpecsProvider() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"gems", (Object)RubyTerminalBundle.INSTANCE.message("ruby.options.features.argument.gems.description", new Object[0])), TuplesKt.to((Object)"error_highlight", (Object)RubyTerminalBundle.INSTANCE.message("ruby.options.features.argument.error.highlight.description", new Object[0])), TuplesKt.to((Object)"did_you_mean", (Object)RubyTerminalBundle.INSTANCE.message("ruby.options.features.argument.did.you.mean.description", new Object[0])), TuplesKt.to((Object)"rubyopt", (Object)RubyTerminalBundle.INSTANCE.message("ruby.options.features.argument.rubyopt.description", new Object[0])), TuplesKt.to((Object)"frozen-string-literal", (Object)RubyTerminalBundle.INSTANCE.message("ruby.options.features.argument.frozen.string.literal.description", new Object[0]))};
        this.FEATURES = MapsKt.mapOf((Pair[])pairArray);
        this.RAKE_HELP_OPTIONS_PATTERN = Pattern.compile("((?<short>-[a-zA-Z]), )?((?<long>--[^ ]+?)[ =](\\[?(?<arg>[A-Z_]+)?]?)?)+\\s+(?<description>[^\n]+)");
        this.IRB_HELP_OPTIONS_PATTERN = Pattern.compile("((?<short>-[a-zA-Z\\-]+)|(?<long>--[^ /]+?))(\\s+(?<arg>[a-z\\-]+))?\\s+(?<description>[\\s\\S]+?(?=\n\\s+-|\\z))");
        this.PRY_HELP_OPTIONS_PATTERN = Pattern.compile("((?<short>-[a-zA-Z]), )?(?<long>--[^ ]+?)?\\s+(?<description>[A-Z`].+)");
        this.RSPEC_HELP_OPTIONS_PATTERN = Pattern.compile("((?<short>-[a-zA-Z])(, ))?(?<long>--[^ ]+?)(?: |\\[=)((?<arg>[A-Za-z_]+)]?)?[ \r\n]+(?<description>[\\s\\S]+?(?=\n\\s+-|[\\[*]|\\z))");
    }

    @NotNull
    public List<ShellCommandSpecInfo> getCommandSpecs() {
        ShellCommandSpec rubySpec2 = ShellCommandSpecApiKt.ShellCommandSpec((String)"ruby", arg_0 -> RubyShellCommandSpecsProvider.getCommandSpecs$lambda$14(this, arg_0));
        ShellCommandSpec bundlerSpec2 = ShellCommandSpecApiKt.ShellCommandSpec((String)"bundle", RubyShellCommandSpecsProvider::getCommandSpecs$lambda$15);
        ShellCommandSpec rakeSpec2 = ShellCommandSpecApiKt.ShellCommandSpec((String)"rake", arg_0 -> RubyShellCommandSpecsProvider.getCommandSpecs$lambda$16(this, arg_0));
        ShellCommandSpec rbenvSpec2 = ShellCommandSpecApiKt.ShellCommandSpec((String)"rbenv", RubyShellCommandSpecsProvider::getCommandSpecs$lambda$17);
        ShellCommandSpec rbsSpec2 = ShellCommandSpecApiKt.ShellCommandSpec((String)"rbs", RubyShellCommandSpecsProvider::getCommandSpecs$lambda$32);
        ShellCommandSpec irbSpec2 = ShellCommandSpecApiKt.ShellCommandSpec((String)"irb", arg_0 -> RubyShellCommandSpecsProvider.getCommandSpecs$lambda$45(this, arg_0));
        ShellCommandSpec prySpec2 = ShellCommandSpecApiKt.ShellCommandSpec((String)"pry", arg_0 -> RubyShellCommandSpecsProvider.getCommandSpecs$lambda$47(this, arg_0));
        ShellCommandSpec rspecSpec2 = ShellCommandSpecApiKt.ShellCommandSpec((String)"rspec", arg_0 -> RubyShellCommandSpecsProvider.getCommandSpecs$lambda$64(this, arg_0));
        Object[] objectArray = new ShellCommandSpecInfo[]{ShellCommandSpecInfo.Companion.create(rubySpec2, ShellCommandSpecConflictStrategy.OVERRIDE), ShellCommandSpecInfo.Companion.create(bundlerSpec2, ShellCommandSpecConflictStrategy.OVERRIDE), ShellCommandSpecInfo.Companion.create(rakeSpec2, ShellCommandSpecConflictStrategy.OVERRIDE), ShellCommandSpecInfo.Companion.create(rbenvSpec2, ShellCommandSpecConflictStrategy.OVERRIDE), ShellCommandSpecInfo.Companion.create(rbsSpec2, ShellCommandSpecConflictStrategy.OVERRIDE), ShellCommandSpecInfo.Companion.create(irbSpec2, ShellCommandSpecConflictStrategy.OVERRIDE), ShellCommandSpecInfo.Companion.create(prySpec2, ShellCommandSpecConflictStrategy.OVERRIDE), ShellCommandSpecInfo.Companion.create(rspecSpec2, ShellCommandSpecConflictStrategy.OVERRIDE)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final Unit getCommandSpecs$lambda$14$lambda$1$lambda$0(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName(RubyTerminalBundle.INSTANCE.message("ruby.options.encoding.argument.display.name", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$14$lambda$1(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("ruby.options.encoding.description", new Object[0]));
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$14$lambda$1$lambda$0);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$14$lambda$3$lambda$2(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName(RubyTerminalBundle.INSTANCE.message("ruby.options.external.internal.encoding.argument.display.name", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$14$lambda$3(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("ruby.options.external.internal.encoding.description", new Object[0]));
        $this$option.setSeparator("=");
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$14$lambda$3$lambda$2);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$14$lambda$5$lambda$4(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName(RubyTerminalBundle.INSTANCE.message("ruby.options.backtrace.limit.argument.display.name", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$14$lambda$5(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("ruby.options.backtrace.limit.description", new Object[0]));
        $this$option.setSeparator("=");
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$14$lambda$5$lambda$4);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$14$lambda$7$lambda$6(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName(RubyTerminalBundle.INSTANCE.message("ruby.options.verbose.level.argument.display.name", new Object[0]));
        $this$argument.suggestions((Function2)new Function2<ShellRuntimeContext, Continuation<? super List<? extends ShellCompletionSuggestion>>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object[] objectArray = new ShellCompletionSuggestion[]{ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"0", null, null, (String)RubyTerminalBundle.INSTANCE.message("ruby.options.verbose.level.argument.0.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"1", null, null, (String)RubyTerminalBundle.INSTANCE.message("ruby.options.verbose.level.argument.1.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"2", null, null, (String)RubyTerminalBundle.INSTANCE.message("ruby.options.verbose.level.argument.2.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null)};
                        return CollectionsKt.listOf((Object[])objectArray);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(ShellRuntimeContext p1, Continuation<? super List<? extends ShellCompletionSuggestion>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$14$lambda$7(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("ruby.options.verbose.level.description", new Object[0]));
        $this$option.setSeparator("");
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$14$lambda$7$lambda$6);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$14$lambda$9$lambda$8(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName(RubyTerminalBundle.INSTANCE.message("ruby.options.dump.argument.display.name", new Object[0]));
        $this$argument.suggestions((Function2)new Function2<ShellRuntimeContext, Continuation<? super List<? extends ShellCompletionSuggestion>>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                ShellRuntimeContext shellRuntimeContext = (ShellRuntimeContext)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void context;
                        ResultKt.throwOnFailure((Object)$result);
                        ShellRuntimeContextExtensionsKt.getProject((ShellRuntimeContext)context);
                        Object[] objectArray = new ShellCompletionSuggestion[]{ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"version", null, null, (String)RubyTerminalBundle.INSTANCE.message("ruby.options.dump.argument.version.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"usage", null, null, (String)RubyTerminalBundle.INSTANCE.message("ruby.options.dump.argument.usage.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"help", null, null, (String)RubyTerminalBundle.INSTANCE.message("ruby.options.dump.argument.help.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"syntax", null, null, (String)RubyTerminalBundle.INSTANCE.message("ruby.options.dump.argument.syntax.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"yydebug", null, null, (String)RubyTerminalBundle.INSTANCE.message("ruby.options.dump.argument.yydebug.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"parsetree", null, null, (String)RubyTerminalBundle.INSTANCE.message("ruby.options.dump.argument.parsetree.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"parsetree_with_comment", null, null, (String)RubyTerminalBundle.INSTANCE.message("ruby.options.dump.argument.parsetree_with_comment.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"insns", null, null, (String)RubyTerminalBundle.INSTANCE.message("ruby.options.dump.argument.insns.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"insns_without_opt", null, null, (String)RubyTerminalBundle.INSTANCE.message("ruby.options.dump.argument.insns_without_opt.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null)};
                        return CollectionsKt.listOf((Object[])objectArray);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(ShellRuntimeContext p1, Continuation<? super List<? extends ShellCompletionSuggestion>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$14$lambda$9(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("ruby.options.dump.description", new Object[0]));
        $this$option.setSeparator("=");
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$14$lambda$9$lambda$8);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$14$lambda$11$lambda$10(RubyShellCommandSpecsProvider this$0, ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName(RubyTerminalBundle.INSTANCE.message("ruby.options.features.argument.display.name", new Object[0]));
        $this$argument.suggestions((Function2)new Function2<ShellRuntimeContext, Continuation<? super List<? extends ShellCompletionSuggestion>>, Object>($this$argument, this$0, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ShellArgumentContext $this_argument;
            final /* synthetic */ RubyShellCommandSpecsProvider this$0;
            {
                this.$this_argument = $this_argument;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                ShellRuntimeContext shellRuntimeContext = (ShellRuntimeContext)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        String[] stringArray;
                        void context;
                        ResultKt.throwOnFailure((Object)$result);
                        VirtualFile directory = VfsUtil.findFile((Path)Path.of(context.getCurrentDirectory(), new String[0]), (boolean)false);
                        LanguageLevel level = RubyLanguageLevelPusher.getLanguageLevelByFile((Project)ShellRuntimeContextExtensionsKt.getProject((ShellRuntimeContext)context), (VirtualFile)directory);
                        List suggestions = new ArrayList<E>();
                        if (level != null) {
                            if (!level.isLessThan(LanguageLevel.RUBY27)) {
                                suggestions.add(ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"yjit", null, null, (String)RubyTerminalBundle.INSTANCE.message("ruby.options.features.argument.yjit.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null));
                                suggestions.add(ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"mjit", null, null, (String)RubyTerminalBundle.INSTANCE.message("ruby.options.features.argument.mjit.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null));
                            }
                            if (!level.isLessThan(LanguageLevel.RUBY26)) {
                                stringArray = new String[]{"jit"};
                                this.$this_argument.suggestions(stringArray);
                            }
                        }
                        stringArray = RubyShellCommandSpecsProvider.access$getFEATURES$p(this.this$0);
                        List list = suggestions;
                        boolean $i$f$map = false;
                        void var8_9 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                        boolean $i$f$mapTo = false;
                        Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void it;
                            Map.Entry<K, V> item$iv$iv;
                            Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)((String)it.getKey()), null, null, (String)((String)it.getValue()), null, (int)0, null, (int)0, (boolean)false, (int)502, null));
                        }
                        list.addAll((List)destination$iv$iv);
                        return suggestions;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(ShellRuntimeContext p1, Continuation<? super List<? extends ShellCompletionSuggestion>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$14$lambda$11(RubyShellCommandSpecsProvider this$0, ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("ruby.options.features.description", new Object[0]));
        $this$option.setSeparator("=");
        $this$option.argument(arg_0 -> RubyShellCommandSpecsProvider.getCommandSpecs$lambda$14$lambda$11$lambda$10(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$14$lambda$12(Map.Entry $feature, ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        Object[] objectArray = new Object[]{$feature.getValue()};
        $this$option.description(RubyTerminalBundle.INSTANCE.message("ruby.options.features.argument.description", objectArray));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$14$lambda$13(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.suggestions(ShellDataGenerators.fileSuggestionsGenerator$default((ShellDataGenerators)ShellDataGenerators.INSTANCE, (boolean)false, (int)1, null));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$14(RubyShellCommandSpecsProvider this$0, ShellCommandContext $this$ShellCommandSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$ShellCommandSpec, (String)"$this$ShellCommandSpec");
        $this$ShellCommandSpec.dynamicOptions((Function3)new Function3<ShellChildOptionsContext, ShellRuntimeContext, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                ShellChildOptionsContext shellChildOptionsContext = (ShellChildOptionsContext)this.L$0;
                ShellRuntimeContext shellRuntimeContext = (ShellRuntimeContext)this.L$1;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$dynamicOptions;
                        String[] stringArray;
                        void context;
                        ResultKt.throwOnFailure((Object)$result);
                        VirtualFile directory = VfsUtil.findFile((Path)Path.of(context.getCurrentDirectory(), new String[0]), (boolean)false);
                        LanguageLevel level = RubyLanguageLevelPusher.getLanguageLevelByFile((Project)ShellRuntimeContextExtensionsKt.getProject((ShellRuntimeContext)context), (VirtualFile)directory);
                        if (level == null) {
                            return Unit.INSTANCE;
                        }
                        if (!level.isLessThan(LanguageLevel.RUBY27)) {
                            stringArray = new String[]{"--jit", "--yjit"};
                            $this$dynamicOptions.option(stringArray, getCommandSpecs.rubySpec.1.1::invokeSuspend$lambda$0);
                            stringArray = new String[]{"--mjit"};
                            $this$dynamicOptions.option(stringArray, getCommandSpecs.rubySpec.1.1::invokeSuspend$lambda$1);
                            stringArray = new String[]{"--enable-yjit", "--disable-yjit"};
                            ShellChildOptionsContext.option$default((ShellChildOptionsContext)$this$dynamicOptions, (String[])stringArray, null, (int)2, null);
                            stringArray = new String[]{"--enable-mjit", "--disable-mjit"};
                            ShellChildOptionsContext.option$default((ShellChildOptionsContext)$this$dynamicOptions, (String[])stringArray, null, (int)2, null);
                        }
                        if (!level.isLessThan(LanguageLevel.RUBY26)) {
                            stringArray = new String[]{"--jit"};
                            $this$dynamicOptions.option(stringArray, getCommandSpecs.rubySpec.1.1::invokeSuspend$lambda$2);
                            stringArray = new String[]{"--enable-jit", "--disable-jit"};
                            ShellChildOptionsContext.option$default((ShellChildOptionsContext)$this$dynamicOptions, (String[])stringArray, null, (int)2, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(ShellChildOptionsContext p1, ShellRuntimeContext p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("ruby.options.jit.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$1(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("ruby.options.mjit.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$2(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("ruby.options.jit.description", new Object[0]));
                return Unit.INSTANCE;
            }
        });
        Object object = new String[]{"-E", "--encoding"};
        $this$ShellCommandSpec.option((String[])object, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$14$lambda$1);
        object = new String[]{"--external-encoding", "--internal-encoding"};
        $this$ShellCommandSpec.option((String[])object, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$14$lambda$3);
        object = new String[]{"--backtrace-limit"};
        $this$ShellCommandSpec.option((String[])object, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$14$lambda$5);
        object = new String[]{"-W"};
        $this$ShellCommandSpec.option((String[])object, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$14$lambda$7);
        object = new String[]{"--dump"};
        $this$ShellCommandSpec.option((String[])object, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$14$lambda$9);
        object = new String[]{"--enable", "--disable"};
        $this$ShellCommandSpec.option((String[])object, arg_0 -> RubyShellCommandSpecsProvider.getCommandSpecs$lambda$14$lambda$11(this$0, arg_0));
        for (Map.Entry entry : this$0.FEATURES.entrySet()) {
            String[] stringArray = new String[]{"--enable-" + entry.getKey(), "--disable-" + entry.getKey()};
            $this$ShellCommandSpec.option(stringArray, arg_0 -> RubyShellCommandSpecsProvider.getCommandSpecs$lambda$14$lambda$12(entry, arg_0));
        }
        $this$ShellCommandSpec.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$14$lambda$13);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$15(ShellCommandContext $this$ShellCommandSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$ShellCommandSpec, (String)"$this$ShellCommandSpec");
        $this$ShellCommandSpec.subcommands((Function3)new Function3<ShellChildCommandsContext, ShellRuntimeContext, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                ShellChildCommandsContext shellChildCommandsContext = (ShellChildCommandsContext)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$subcommands;
                        ResultKt.throwOnFailure((Object)$result);
                        String[] stringArray = new String[]{"cache", "package", "pack"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.bundlerSpec.1.1::invokeSuspend$lambda$0);
                        stringArray = new String[]{"remove"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.bundlerSpec.1.1::invokeSuspend$lambda$3);
                        stringArray = new String[]{"plugin"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.bundlerSpec.1.1::invokeSuspend$lambda$4);
                        stringArray = new String[]{"version"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.bundlerSpec.1.1::invokeSuspend$lambda$5);
                        stringArray = new String[]{"install"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.bundlerSpec.1.1::invokeSuspend$lambda$8);
                        stringArray = new String[]{"config"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.bundlerSpec.1.1::invokeSuspend$lambda$9);
                        stringArray = new String[]{"help"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.bundlerSpec.1.1::invokeSuspend$lambda$10);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(ShellChildCommandsContext p1, ShellRuntimeContext p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.cache.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$3$lambda$1(ShellArgumentContext $this$argument) {
                $this$argument.displayName(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.remove.argument.display.name", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$3$lambda$2(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.remove.options.install.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$3(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.remove.description", new Object[0]));
                $this$subcommand.argument(getCommandSpecs.bundlerSpec.1.1::invokeSuspend$lambda$3$lambda$1);
                String[] stringArray = new String[]{"--install"};
                $this$subcommand.option(stringArray, getCommandSpecs.bundlerSpec.1.1::invokeSuspend$lambda$3$lambda$2);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$4(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.plugin.description", new Object[0]));
                $this$subcommand.subcommands((Function3)new Function3<ShellChildCommandsContext, ShellRuntimeContext, Continuation<? super Unit>, Object>(null){
                    int label;
                    private /* synthetic */ Object L$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        ShellChildCommandsContext shellChildCommandsContext = (ShellChildCommandsContext)this.L$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$subcommands;
                                ResultKt.throwOnFailure((Object)$result);
                                String[] stringArray = new String[]{"install"};
                                $this$subcommands.subcommand(stringArray, getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$11);
                                stringArray = new String[]{"uninstall"};
                                $this$subcommands.subcommand(stringArray, getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$14);
                                stringArray = new String[]{"list"};
                                $this$subcommands.subcommand(stringArray, getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$15);
                                stringArray = new String[]{"help"};
                                $this$subcommands.subcommand(stringArray, getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$16);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Object invoke(ShellChildCommandsContext p1, ShellRuntimeContext p2, Continuation<? super Unit> p3) {
                        var var4_4 = new /* invalid duplicate definition of identical inner class */;
                        var4_4.L$0 = p1;
                        return var4_4.invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$11$lambda$0(ShellArgumentContext $this$argument) {
                        $this$argument.displayName("PLUGINS");
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$11$lambda$2$lambda$1(ShellArgumentContext $this$argument) {
                        $this$argument.displayName("URL");
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$11$lambda$2(ShellOptionContext $this$option) {
                        $this$option.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.plugin.subcommands.install.options.source.description", new Object[0]));
                        $this$option.argument(getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$11$lambda$2$lambda$1);
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$11$lambda$3(ShellOptionContext $this$option) {
                        $this$option.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.plugin.subcommands.install.options.version.description", new Object[0]));
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$11$lambda$5$lambda$4(ShellArgumentContext $this$argument) {
                        $this$argument.displayName("URL");
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$11$lambda$5(ShellOptionContext $this$option) {
                        $this$option.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.plugin.subcommands.install.options.git.description", new Object[0]));
                        $this$option.argument(getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$11$lambda$5$lambda$4);
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$11$lambda$6(ShellOptionContext $this$option) {
                        $this$option.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.plugin.subcommands.install.options.local.git.description", new Object[0]));
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$11$lambda$7(ShellOptionContext $this$option) {
                        $this$option.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.plugin.subcommands.install.options.branch.description", new Object[0]));
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$11$lambda$8(ShellOptionContext $this$option) {
                        $this$option.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.plugin.subcommands.install.options.ref.description", new Object[0]));
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$11$lambda$10$lambda$9(ShellArgumentContext $this$argument) {
                        $this$argument.displayName("PATH");
                        $this$argument.suggestions(ShellDataGenerators.fileSuggestionsGenerator$default((ShellDataGenerators)ShellDataGenerators.INSTANCE, (boolean)false, (int)1, null));
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$11$lambda$10(ShellOptionContext $this$option) {
                        $this$option.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.plugin.subcommands.install.options.path.description", new Object[0]));
                        $this$option.argument(getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$11$lambda$10$lambda$9);
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$11(ShellCommandContext $this$subcommand) {
                        $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.plugin.subcommands.install.description", new Object[0]));
                        $this$subcommand.argument(getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$11$lambda$0);
                        String[] stringArray = new String[]{"--source"};
                        $this$subcommand.option(stringArray, getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$11$lambda$2);
                        stringArray = new String[]{"--version"};
                        $this$subcommand.option(stringArray, getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$11$lambda$3);
                        stringArray = new String[]{"--git"};
                        $this$subcommand.option(stringArray, getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$11$lambda$5);
                        stringArray = new String[]{"--local-git"};
                        $this$subcommand.option(stringArray, getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$11$lambda$6);
                        stringArray = new String[]{"--branch"};
                        $this$subcommand.option(stringArray, getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$11$lambda$7);
                        stringArray = new String[]{"--ref"};
                        $this$subcommand.option(stringArray, getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$11$lambda$8);
                        stringArray = new String[]{"--path"};
                        $this$subcommand.option(stringArray, getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$11$lambda$10);
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$14$lambda$12(ShellArgumentContext $this$argument) {
                        $this$argument.displayName("PLUGINS");
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$14$lambda$13(ShellOptionContext $this$option) {
                        $this$option.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.plugin.subcommands.uninstall.options.all.description", new Object[0]));
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$14(ShellCommandContext $this$subcommand) {
                        $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.plugin.subcommands.uninstall.description", new Object[0]));
                        $this$subcommand.argument(getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$14$lambda$12);
                        String[] stringArray = new String[]{"-all"};
                        $this$subcommand.option(stringArray, getCommandSpecs.bundlerSpec.1.3.1::invokeSuspend$lambda$14$lambda$13);
                        stringArray = new String[]{"-no-all"};
                        ShellCommandContext.option$default((ShellCommandContext)$this$subcommand, (String[])stringArray, null, (int)2, null);
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$15(ShellCommandContext $this$subcommand) {
                        $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.plugin.subcommands.list.description", new Object[0]));
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$16(ShellCommandContext $this$subcommand) {
                        $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.plugin.subcommands.help.description", new Object[0]));
                        return Unit.INSTANCE;
                    }
                });
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$5(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.version.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$8$lambda$7$lambda$6(ShellArgumentContext $this$argument) {
                $this$argument.displayName(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.install.trust.policy.argument.display.name", new Object[0]));
                String[] stringArray = new String[]{"HighSecurity", "MediumSecurity", "LowSecurity", "AlmostNoSecurity", "NoSecurity"};
                $this$argument.suggestions(stringArray);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$8$lambda$7(ShellOptionContext $this$option) {
                Object[] objectArray = new Object[]{RubyTerminalBundle.INSTANCE.message("bundle.subcommands.install.trust.policy.argument.display.name", new Object[0])};
                $this$option.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.install.trust.policy.description", objectArray));
                $this$option.argument(getCommandSpecs.bundlerSpec.1.1::invokeSuspend$lambda$8$lambda$7$lambda$6);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$8(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.install.description", new Object[0]));
                String[] stringArray = new String[]{"-j", "--jobs"};
                ShellCommandContext.option$default((ShellCommandContext)$this$subcommand, (String[])stringArray, null, (int)2, null);
                stringArray = new String[]{"--trust-policy"};
                $this$subcommand.option(stringArray, getCommandSpecs.bundlerSpec.1.1::invokeSuspend$lambda$8$lambda$7);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$9(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.config.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$10(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("bundle.subcommands.help.description", new Object[0]));
                return Unit.INSTANCE;
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$16(RubyShellCommandSpecsProvider this$0, ShellCommandContext $this$ShellCommandSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$ShellCommandSpec, (String)"$this$ShellCommandSpec");
        $this$ShellCommandSpec.dynamicOptions((Function3)new Function3<ShellChildOptionsContext, ShellRuntimeContext, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ RubyShellCommandSpecsProvider this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (ShellChildOptionsContext)this.L$0;
                var3_3 = (ShellRuntimeContext)this.L$1;
                var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = $this$dynamicOptions;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)context);
                        this.label = 1;
                        v0 = context.runShellCommand("rake --help", (Continuation)this);
                        if (v0 == var5_4) {
                            return var5_4;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if ((rakeHelp = (ShellCommandResult)v0).getExitCode() == 0) {
                            v1 = RubyShellCommandSpecsProvider.access$getRAKE_HELP_OPTIONS_PATTERN$p(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"access$getRAKE_HELP_OPTIONS_PATTERN$p(...)");
                            CompletionUtilKt.buildOptionsFromPattern$default((ShellChildOptionsContext)$this$dynamicOptions, v1, rakeHelp.getOutput(), false, null, 12, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(ShellChildOptionsContext p1, ShellRuntimeContext p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        });
        $this$ShellCommandSpec.subcommands((Function3)new Function3<ShellChildCommandsContext, ShellRuntimeContext, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                ShellChildCommandsContext shellChildCommandsContext = (ShellChildCommandsContext)this.L$0;
                ShellRuntimeContext shellRuntimeContext = (ShellRuntimeContext)this.L$1;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void context;
                        void $this$subcommands;
                        ResultKt.throwOnFailure((Object)$result);
                        CompletionUtilKt.addRakeTasks((ShellChildCommandsContext)$this$subcommands, ShellRuntimeContextExtensionsKt.getProject((ShellRuntimeContext)context), context.getCurrentDirectory());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(ShellChildCommandsContext p1, ShellRuntimeContext p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$17(ShellCommandContext $this$ShellCommandSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$ShellCommandSpec, (String)"$this$ShellCommandSpec");
        $this$ShellCommandSpec.subcommands((Function3)new Function3<ShellChildCommandsContext, ShellRuntimeContext, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                ShellChildCommandsContext shellChildCommandsContext = (ShellChildCommandsContext)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$subcommands;
                        ResultKt.throwOnFailure((Object)$result);
                        String[] stringArray = new String[]{"install"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.rbenvSpec.1.1::invokeSuspend$lambda$7);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(ShellChildCommandsContext p1, ShellRuntimeContext p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$7$lambda$0(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbenv.subcommands.install.options.list.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$7$lambda$1(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbenv.subcommands.install.options.list.all.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$7$lambda$2(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbenv.subcommands.install.options.force.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$7$lambda$3(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbenv.subcommands.install.options.skip.existing.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$7$lambda$4(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbenv.subcommands.install.options.verbose.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$7$lambda$5(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbenv.subcommands.install.options.patch.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$7$lambda$6(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbenv.subcommands.install.options.keep.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$7(ShellCommandContext $this$subcommand) {
                String[] stringArray = new String[]{"-l", "--list"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbenvSpec.1.1::invokeSuspend$lambda$7$lambda$0);
                stringArray = new String[]{"-L", "--list-all"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbenvSpec.1.1::invokeSuspend$lambda$7$lambda$1);
                stringArray = new String[]{"-f", "--force"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbenvSpec.1.1::invokeSuspend$lambda$7$lambda$2);
                stringArray = new String[]{"-s", "--skip-existing"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbenvSpec.1.1::invokeSuspend$lambda$7$lambda$3);
                stringArray = new String[]{"-v", "--verbose"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbenvSpec.1.1::invokeSuspend$lambda$7$lambda$4);
                stringArray = new String[]{"-p", "--patch"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbenvSpec.1.1::invokeSuspend$lambda$7$lambda$5);
                stringArray = new String[]{"-k", "--keep"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbenvSpec.1.1::invokeSuspend$lambda$7$lambda$6);
                return Unit.INSTANCE;
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$32$lambda$19$lambda$18(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName("LIBRARY");
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$32$lambda$19(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.options.library.description", new Object[0]));
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$32$lambda$19$lambda$18);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$32$lambda$21$lambda$20(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName("DIR");
        $this$argument.suggestions(ShellDataGenerators.INSTANCE.fileSuggestionsGenerator(true));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$32$lambda$21(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.options.dir.description", new Object[0]));
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$32$lambda$21$lambda$20);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$32$lambda$22(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.options.no.stdlib.description", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$32$lambda$24$lambda$23(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName("PATH");
        $this$argument.suggestions(ShellDataGenerators.fileSuggestionsGenerator$default((ShellDataGenerators)ShellDataGenerators.INSTANCE, (boolean)false, (int)1, null));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$32$lambda$24(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.options.collection.description", new Object[0]));
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$32$lambda$24$lambda$23);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$32$lambda$25(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.options.no.collection.description", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$32$lambda$27$lambda$26(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName("DIR");
        $this$argument.suggestions(ShellDataGenerators.INSTANCE.fileSuggestionsGenerator(true));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$32$lambda$27(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.options.repo.description", new Object[0]));
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$32$lambda$27$lambda$26);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$32$lambda$29$lambda$28(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName("LEVEL");
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$32$lambda$29(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.options.log.level.description", new Object[0]));
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$32$lambda$29$lambda$28);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$32$lambda$31$lambda$30(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName("OUTPUT");
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$32$lambda$31(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.options.log.output.description", new Object[0]));
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$32$lambda$31$lambda$30);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$32(ShellCommandContext $this$ShellCommandSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$ShellCommandSpec, (String)"$this$ShellCommandSpec");
        $this$ShellCommandSpec.subcommands((Function3)new Function3<ShellChildCommandsContext, ShellRuntimeContext, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                ShellChildCommandsContext shellChildCommandsContext = (ShellChildCommandsContext)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$subcommands;
                        ResultKt.throwOnFailure((Object)$result);
                        String[] stringArray = new String[]{"ast"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$0);
                        stringArray = new String[]{"annotate"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$9);
                        stringArray = new String[]{"list"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$13);
                        stringArray = new String[]{"ancestors"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$17);
                        stringArray = new String[]{"methods"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$22);
                        stringArray = new String[]{"method"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$27);
                        stringArray = new String[]{"validate"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$28);
                        stringArray = new String[]{"constant"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$31);
                        stringArray = new String[]{"paths"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$32);
                        stringArray = new String[]{"prototype"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$33);
                        stringArray = new String[]{"vendor"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$37);
                        stringArray = new String[]{"parse"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$38);
                        stringArray = new String[]{"test"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$47);
                        stringArray = new String[]{"collection"};
                        $this$subcommands.subcommand(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$48);
                        stringArray = new String[]{"version"};
                        ShellChildCommandsContext.subcommand$default((ShellChildCommandsContext)$this$subcommands, (String[])stringArray, null, (int)2, null);
                        stringArray = new String[]{"help"};
                        ShellChildCommandsContext.subcommand$default((ShellChildCommandsContext)$this$subcommands, (String[])stringArray, null, (int)2, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(ShellChildCommandsContext p1, ShellRuntimeContext p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.ast.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$9$lambda$1(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.annotate.options.system.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$9$lambda$2(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.annotate.options.gems.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$9$lambda$3(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.annotate.options.site.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$9$lambda$4(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.annotate.options.home.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$9$lambda$6$lambda$5(ShellArgumentContext $this$argument) {
                $this$argument.displayName("DIRNAME");
                $this$argument.suggestions(ShellDataGenerators.INSTANCE.fileSuggestionsGenerator(true));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$9$lambda$6(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.annotate.options.dir.description", new Object[0]));
                $this$option.argument(getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$9$lambda$6$lambda$5);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$9$lambda$7(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.annotate.options.arglists.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$9$lambda$8(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.annotate.options.filename.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$9(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.annotate.description", new Object[0]));
                String[] stringArray = new String[]{"--system", "--no-system"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$9$lambda$1);
                stringArray = new String[]{"--gems", "--no-gems"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$9$lambda$2);
                stringArray = new String[]{"--site", "--no-site"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$9$lambda$3);
                stringArray = new String[]{"--home", "--no-home"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$9$lambda$4);
                stringArray = new String[]{"-d", "--dir"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$9$lambda$6);
                stringArray = new String[]{"--arglists", "--no-arglists"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$9$lambda$7);
                stringArray = new String[]{"--filename", "--no-filename"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$9$lambda$8);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$13$lambda$10(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.list.options.class.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$13$lambda$11(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.list.options.module.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$13$lambda$12(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.list.options.interface.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$13(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.list.description", new Object[0]));
                String[] stringArray = new String[]{"--class"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$13$lambda$10);
                stringArray = new String[]{"--module"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$13$lambda$11);
                stringArray = new String[]{"--interface"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$13$lambda$12);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$17$lambda$14(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.ancestors.options.instance.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$17$lambda$15(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.ancestors.options.singleton.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$17$lambda$16(ShellArgumentContext $this$argument) {
                $this$argument.displayName("TYPENAME");
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$17(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.ancestors.description", new Object[0]));
                String[] stringArray = new String[]{"--instance"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$17$lambda$14);
                stringArray = new String[]{"--singleton"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$17$lambda$15);
                $this$subcommand.argument(getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$17$lambda$16);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$22$lambda$18(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.methods.options.instance.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$22$lambda$19(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.methods.options.singleton.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$22$lambda$20(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.methods.options.inherit.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$22$lambda$21(ShellArgumentContext $this$argument) {
                $this$argument.displayName("TYPENAME");
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$22(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.methods.description", new Object[0]));
                String[] stringArray = new String[]{"--instance"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$22$lambda$18);
                stringArray = new String[]{"--singleton"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$22$lambda$19);
                stringArray = new String[]{"--inherit", "--no-inherit"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$22$lambda$20);
                $this$subcommand.argument(getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$22$lambda$21);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$27$lambda$23(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.method.options.instance.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$27$lambda$24(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.method.options.singleton.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$27$lambda$25(ShellArgumentContext $this$argument) {
                $this$argument.displayName("TYPENAME");
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$27$lambda$26(ShellArgumentContext $this$argument) {
                $this$argument.displayName("METHODNAME");
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$27(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.method.description", new Object[0]));
                String[] stringArray = new String[]{"--instance"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$27$lambda$23);
                stringArray = new String[]{"--singleton"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$27$lambda$24);
                $this$subcommand.argument(getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$27$lambda$25);
                $this$subcommand.argument(getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$27$lambda$26);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$28(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.validate.description", new Object[0]));
                String[] stringArray = new String[]{"--silent"};
                ShellCommandContext.option$default((ShellCommandContext)$this$subcommand, (String[])stringArray, null, (int)2, null);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$31$lambda$30$lambda$29(ShellArgumentContext $this$argument) {
                $this$argument.displayName("CONTEXT");
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$31$lambda$30(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.constant.options.context.description", new Object[0]));
                $this$option.argument(getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$31$lambda$30$lambda$29);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$31(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.constant.description", new Object[0]));
                String[] stringArray = new String[]{"--context"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$31$lambda$30);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$32(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.paths.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$33(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.prototype.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$37$lambda$34(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.vendor.options.clean.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$37$lambda$36$lambda$35(ShellArgumentContext $this$argument) {
                $this$argument.displayName("DIR");
                $this$argument.suggestions(ShellDataGenerators.INSTANCE.fileSuggestionsGenerator(true));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$37$lambda$36(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.vendor.options.vendor.dir.description", new Object[0]));
                $this$option.argument(getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$37$lambda$36$lambda$35);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$37(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.vendor.description", new Object[0]));
                String[] stringArray = new String[]{"--clean", "--no-clean"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$37$lambda$34);
                stringArray = new String[]{"--vendor-dir"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$37$lambda$36);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$38(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.parse.description", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$47$lambda$40$lambda$39(ShellArgumentContext $this$argument) {
                $this$argument.displayName("TARGET");
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$47$lambda$40(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.test.options.target.description", new Object[0]));
                $this$option.argument(getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$47$lambda$40$lambda$39);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$47$lambda$42$lambda$41(ShellArgumentContext $this$argument) {
                $this$argument.displayName("SAMPLESIZE");
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$47$lambda$42(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.test.options.sample.size.description", new Object[0]));
                $this$option.argument(getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$47$lambda$42$lambda$41);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$47$lambda$44$lambda$43(ShellArgumentContext $this$argument) {
                $this$argument.displayName("UNCHECKEDCLASS");
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$47$lambda$44(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.test.options.unchecked.class.description", new Object[0]));
                $this$option.argument(getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$47$lambda$44$lambda$43);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$47$lambda$46$lambda$45(ShellArgumentContext $this$argument) {
                $this$argument.displayName("DOUBLESUITE");
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$47$lambda$46(ShellOptionContext $this$option) {
                $this$option.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.test.options.double.suite.description", new Object[0]));
                $this$option.argument(getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$47$lambda$46$lambda$45);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$47(ShellCommandContext $this$subcommand) {
                String[] stringArray = new String[]{"--target"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$47$lambda$40);
                stringArray = new String[]{"--sample-size"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$47$lambda$42);
                stringArray = new String[]{"--unchecked-class"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$47$lambda$44);
                stringArray = new String[]{"--double-suite"};
                $this$subcommand.option(stringArray, getCommandSpecs.rbsSpec.1.1::invokeSuspend$lambda$47$lambda$46);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$48(ShellCommandContext $this$subcommand) {
                $this$subcommand.description(RubyTerminalBundle.INSTANCE.message("rbs.subcommands.collection.description", new Object[0]));
                return Unit.INSTANCE;
            }
        });
        String[] stringArray = new String[]{"-r"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$32$lambda$19);
        stringArray = new String[]{"-I"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$32$lambda$21);
        stringArray = new String[]{"--no-stdlib"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$32$lambda$22);
        stringArray = new String[]{"--collection"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$32$lambda$24);
        stringArray = new String[]{"--no-collection"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$32$lambda$25);
        stringArray = new String[]{"--repo"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$32$lambda$27);
        stringArray = new String[]{"--log-level"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$32$lambda$29);
        stringArray = new String[]{"--log-output"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$32$lambda$31);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$45$lambda$34$lambda$33(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName(RubyTerminalBundle.INSTANCE.message("irb.options.encoding.argument.display.name", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$45$lambda$34(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("irb.options.encoding.description", new Object[0]));
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$45$lambda$34$lambda$33);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$45$lambda$36$lambda$35(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName(RubyTerminalBundle.INSTANCE.message("irb.options.warning.level.argument.display.name", new Object[0]));
        String[] stringArray = new String[]{"0", "1", "2"};
        $this$argument.suggestions(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$45$lambda$36(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("irb.options.warning.level.description", new Object[0]));
        $this$option.setSeparator("");
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$45$lambda$36$lambda$35);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$45$lambda$38$lambda$37(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName(RubyTerminalBundle.INSTANCE.message("irb.options.prompt.argument.display.name", new Object[0]));
        String[] stringArray = new String[]{"default", "classic", "simple", "inf-ruby", "xmp", "null"};
        $this$argument.suggestions(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$45$lambda$38(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("irb.options.prompt.description", new Object[0]));
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$45$lambda$38$lambda$37);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$45$lambda$39(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("irb.options.simple.prompt.description", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$45$lambda$41$lambda$40(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName("n");
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$45$lambda$41(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("irb.options.backtrace.limit.description", new Object[0]));
        $this$option.setSeparator("=");
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$45$lambda$41$lambda$40);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$45$lambda$42(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("irb.options.version.description", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$45$lambda$43(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("irb.options.help.description", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$45$lambda$44(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.suggestions(ShellDataGenerators.fileSuggestionsGenerator$default((ShellDataGenerators)ShellDataGenerators.INSTANCE, (boolean)false, (int)1, null));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$45(RubyShellCommandSpecsProvider this$0, ShellCommandContext $this$ShellCommandSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$ShellCommandSpec, (String)"$this$ShellCommandSpec");
        String[] stringArray = new String[]{"-E"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$45$lambda$34);
        stringArray = new String[]{"-W"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$45$lambda$36);
        stringArray = new String[]{"--prompt", "--prompt-mode"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$45$lambda$38);
        stringArray = new String[]{"--sample-book-mode", "--simple-prompt"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$45$lambda$39);
        stringArray = new String[]{"--back-trace-limit"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$45$lambda$41);
        stringArray = new String[]{"-v"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$45$lambda$42);
        stringArray = new String[]{"-h"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$45$lambda$43);
        $this$ShellCommandSpec.dynamicOptions((Function3)new Function3<ShellChildOptionsContext, ShellRuntimeContext, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ RubyShellCommandSpecsProvider this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (ShellChildOptionsContext)this.L$0;
                var3_3 = (ShellRuntimeContext)this.L$1;
                var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = $this$dynamicOptions;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)context);
                        this.label = 1;
                        v0 = context.runShellCommand("irb --help", (Continuation)this);
                        if (v0 == var6_4) {
                            return var6_4;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if ((irbHelp = (ShellCommandResult)v0).getExitCode() == 0) {
                            v1 = RubyShellCommandSpecsProvider.access$getIRB_HELP_OPTIONS_PATTERN$p(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"access$getIRB_HELP_OPTIONS_PATTERN$p(...)");
                            var5_6 = new String[]{"-E", "-W", "--prompt", "--prompt-mode", "--sample-book-mode", "--simple-prompt", "--sample-book-mode, --simple-prompt", "--back-trace-limit"};
                            CompletionUtilKt.buildOptionsFromPattern$default((ShellChildOptionsContext)$this$dynamicOptions, v1, irbHelp.getOutput(), false, SetsKt.setOf((Object[])var5_6), 4, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(ShellChildOptionsContext p1, ShellRuntimeContext p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        });
        $this$ShellCommandSpec.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$45$lambda$44);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$47$lambda$46(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.suggestions(ShellDataGenerators.fileSuggestionsGenerator$default((ShellDataGenerators)ShellDataGenerators.INSTANCE, (boolean)false, (int)1, null));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$47(RubyShellCommandSpecsProvider this$0, ShellCommandContext $this$ShellCommandSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$ShellCommandSpec, (String)"$this$ShellCommandSpec");
        $this$ShellCommandSpec.dynamicOptions((Function3)new Function3<ShellChildOptionsContext, ShellRuntimeContext, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ RubyShellCommandSpecsProvider this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (ShellChildOptionsContext)this.L$0;
                var3_3 = (ShellRuntimeContext)this.L$1;
                var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = $this$dynamicOptions;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)context);
                        this.label = 1;
                        v0 = context.runShellCommand("pry --help", (Continuation)this);
                        if (v0 == var5_4) {
                            return var5_4;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if ((pryHelp = (ShellCommandResult)v0).getExitCode() == 0) {
                            v1 = RubyShellCommandSpecsProvider.access$getPRY_HELP_OPTIONS_PATTERN$p(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"access$getPRY_HELP_OPTIONS_PATTERN$p(...)");
                            CompletionUtilKt.buildOptionsFromPattern$default((ShellChildOptionsContext)$this$dynamicOptions, v1, pryHelp.getOutput(), false, null, 8, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(ShellChildOptionsContext p1, ShellRuntimeContext p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        });
        $this$ShellCommandSpec.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$47$lambda$46);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64$lambda$49$lambda$48(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName("PATH");
        $this$argument.suggestions(ShellDataGenerators.fileSuggestionsGenerator$default((ShellDataGenerators)ShellDataGenerators.INSTANCE, (boolean)false, (int)1, null));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64$lambda$49(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rspec.options.path.description", new Object[0]));
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$64$lambda$49$lambda$48);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64$lambda$51$lambda$50(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName("TYPE");
        $this$argument.suggestions((Function2)new Function2<ShellRuntimeContext, Continuation<? super List<? extends ShellCompletionSuggestion>>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object[] objectArray = new ShellCompletionSuggestion[]{ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"defined", null, null, (String)RubyTerminalBundle.INSTANCE.message("rspec.options.order.argument.defined.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"rand", null, null, (String)RubyTerminalBundle.INSTANCE.message("rspec.options.order.argument.rand.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"random", null, null, (String)RubyTerminalBundle.INSTANCE.message("rspec.options.order.argument.random.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"recently-modified", null, null, (String)RubyTerminalBundle.INSTANCE.message("rspec.options.order.argument.recently.modified.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null)};
                        return CollectionsKt.listOf((Object[])objectArray);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(ShellRuntimeContext p1, Continuation<? super List<? extends ShellCompletionSuggestion>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64$lambda$51(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rspec.options.order.description", new Object[0]));
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$64$lambda$51$lambda$50);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64$lambda$53$lambda$52(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        String[] stringArray = new String[]{"verbose"};
        $this$argument.suggestions(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64$lambda$53(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rspec.options.bisect.description", new Object[0]));
        $this$option.setSeparator("=");
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$64$lambda$53$lambda$52);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64$lambda$55$lambda$54(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName("FORMATTER");
        $this$argument.suggestions((Function2)new Function2<ShellRuntimeContext, Continuation<? super List<? extends ShellCompletionSuggestion>>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object[] objectArray = new ShellCompletionSuggestion[]{ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"progress", null, null, (String)RubyTerminalBundle.INSTANCE.message("rspec.options.format.argument.progress.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"documentation", null, null, (String)RubyTerminalBundle.INSTANCE.message("rspec.options.format.argument.documentation.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"html", null, null, null, null, (int)0, null, (int)0, (boolean)false, (int)510, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"json", null, null, null, null, (int)0, null, (int)0, (boolean)false, (int)510, null), ShellCommandSpecApiKt.ShellCompletionSuggestion$default((String)"failures", null, null, (String)RubyTerminalBundle.INSTANCE.message("rspec.options.format.argument.failures.description", new Object[0]), null, (int)0, null, (int)0, (boolean)false, (int)502, null)};
                        return CollectionsKt.listOf((Object[])objectArray);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(ShellRuntimeContext p1, Continuation<? super List<? extends ShellCompletionSuggestion>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64$lambda$55(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rspec.options.format.description", new Object[0]));
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$64$lambda$55$lambda$54);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64$lambda$56(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rspec.options.force.color.description", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64$lambda$57(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rspec.options.no.color.description", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64$lambda$59$lambda$58(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName("TAG[:VALUE]");
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64$lambda$59(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rspec.options.tag.description", new Object[0]));
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$64$lambda$59$lambda$58);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64$lambda$60(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rspec.options.help.description", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64$lambda$62$lambda$61(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName("PATTERN");
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64$lambda$62(ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        $this$option.description(RubyTerminalBundle.INSTANCE.message("rspec.options.pattern.description", new Object[0]));
        $this$option.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$64$lambda$62$lambda$61);
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64$lambda$63(ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.suggestions(ShellDataGenerators.fileSuggestionsGenerator$default((ShellDataGenerators)ShellDataGenerators.INSTANCE, (boolean)false, (int)1, null));
        return Unit.INSTANCE;
    }

    private static final Unit getCommandSpecs$lambda$64(RubyShellCommandSpecsProvider this$0, ShellCommandContext $this$ShellCommandSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$ShellCommandSpec, (String)"$this$ShellCommandSpec");
        String[] stringArray = new String[]{"-I"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$64$lambda$49);
        stringArray = new String[]{"--order"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$64$lambda$51);
        stringArray = new String[]{"--bisect"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$64$lambda$53);
        stringArray = new String[]{"-f", "--format"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$64$lambda$55);
        stringArray = new String[]{"--force-color", "--force-colour"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$64$lambda$56);
        stringArray = new String[]{"--no-color", "--no-colour"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$64$lambda$57);
        stringArray = new String[]{"-t", "--tag"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$64$lambda$59);
        stringArray = new String[]{"-h", "--help"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$64$lambda$60);
        stringArray = new String[]{"-P", "--pattern"};
        $this$ShellCommandSpec.option(stringArray, RubyShellCommandSpecsProvider::getCommandSpecs$lambda$64$lambda$62);
        $this$ShellCommandSpec.dynamicOptions((Function3)new Function3<ShellChildOptionsContext, ShellRuntimeContext, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ RubyShellCommandSpecsProvider this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (ShellChildOptionsContext)this.L$0;
                var3_3 = (ShellRuntimeContext)this.L$1;
                var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = $this$dynamicOptions;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)context);
                        this.label = 1;
                        v0 = context.runShellCommand("rspec --help", (Continuation)this);
                        if (v0 == var6_4) {
                            return var6_4;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if ((rspecHelp = (ShellCommandResult)v0).getExitCode() == 0) {
                            v1 = RubyShellCommandSpecsProvider.access$getRSPEC_HELP_OPTIONS_PATTERN$p(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"access$getRSPEC_HELP_OPTIONS_PATTERN$p(...)");
                            var5_6 = new String[]{"-I", "--order", "--bisect", "-f", "--format", "--force-color", "--force-colour", "--no-color", "--no-colour", "-t", "--tag", "-h", "--help", "-P", "--pattern"};
                            CompletionUtilKt.buildOptionsFromPattern((ShellChildOptionsContext)$this$dynamicOptions, v1, rspecHelp.getOutput(), false, SetsKt.setOf((Object[])var5_6));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(ShellChildOptionsContext p1, ShellRuntimeContext p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        });
        $this$ShellCommandSpec.argument(RubyShellCommandSpecsProvider::getCommandSpecs$lambda$64$lambda$63);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Map access$getFEATURES$p(RubyShellCommandSpecsProvider $this) {
        return $this.FEATURES;
    }

    public static final /* synthetic */ Pattern access$getRAKE_HELP_OPTIONS_PATTERN$p(RubyShellCommandSpecsProvider $this) {
        return $this.RAKE_HELP_OPTIONS_PATTERN;
    }

    public static final /* synthetic */ Pattern access$getIRB_HELP_OPTIONS_PATTERN$p(RubyShellCommandSpecsProvider $this) {
        return $this.IRB_HELP_OPTIONS_PATTERN;
    }

    public static final /* synthetic */ Pattern access$getPRY_HELP_OPTIONS_PATTERN$p(RubyShellCommandSpecsProvider $this) {
        return $this.PRY_HELP_OPTIONS_PATTERN;
    }

    public static final /* synthetic */ Pattern access$getRSPEC_HELP_OPTIONS_PATTERN$p(RubyShellCommandSpecsProvider $this) {
        return $this.RSPEC_HELP_OPTIONS_PATTERN;
    }
}

