/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.terminal;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rake.workspace.storage.ExtensionsKt;
import org.jetbrains.plugins.ruby.rake.workspace.storage.RakeTaskEntity;
import org.jetbrains.plugins.terminal.block.completion.spec.dsl.ShellArgumentContext;
import org.jetbrains.plugins.terminal.block.completion.spec.dsl.ShellChildCommandsContext;
import org.jetbrains.plugins.terminal.block.completion.spec.dsl.ShellChildOptionsContext;
import org.jetbrains.plugins.terminal.block.completion.spec.dsl.ShellCommandContext;
import org.jetbrains.plugins.terminal.block.completion.spec.dsl.ShellOptionContext;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u001a\u001a\u0010\u000b\u001a\u00020\u0001*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006\u00a8\u0006\u0010"}, d2={"buildOptionsFromPattern", "", "Lorg/jetbrains/plugins/terminal/block/completion/spec/dsl/ShellChildOptionsContext;", "pattern", "Ljava/util/regex/Pattern;", "helpOutput", "", "withArguments", "", "ignoredNames", "", "addRakeTasks", "Lorg/jetbrains/plugins/terminal/block/completion/spec/dsl/ShellChildCommandsContext;", "project", "Lcom/intellij/openapi/project/Project;", "currentDirectory", "intellij.ruby.terminal"})
@SourceDebugExtension(value={"SMAP\ncompletionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 completionUtil.kt\norg/jetbrains/plugins/ruby/terminal/CompletionUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,62:1\n1#2:63\n37#3:64\n36#3,3:65\n*S KotlinDebug\n*F\n+ 1 completionUtil.kt\norg/jetbrains/plugins/ruby/terminal/CompletionUtilKt\n*L\n33#1:64\n33#1:65,3\n*E\n"})
public final class CompletionUtilKt {
    public static final void buildOptionsFromPattern(@NotNull ShellChildOptionsContext $this$buildOptionsFromPattern, @NotNull Pattern pattern, @NotNull String helpOutput, boolean withArguments, @NotNull Set<String> ignoredNames) {
        Intrinsics.checkNotNullParameter((Object)$this$buildOptionsFromPattern, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)helpOutput, (String)"helpOutput");
        Intrinsics.checkNotNullParameter(ignoredNames, (String)"ignoredNames");
        Matcher matcher = pattern.matcher(helpOutput);
        while (matcher.find()) {
            String string;
            String argName;
            String shortName = matcher.group("short");
            String longName = matcher.group("long");
            if (ignoredNames.contains(shortName) || ignoredNames.contains(longName)) continue;
            String string2 = argName = withArguments ? matcher.group("arg") : null;
            if (matcher.group("description") != null) {
                String it;
                boolean bl = false;
                string = StringUtil.collapseWhiteSpace((CharSequence)it);
            } else {
                string = null;
            }
            String description = string;
            Object[] objectArray = new String[3];
            objectArray[0] = shortName;
            String string3 = longName;
            objectArray[1] = string3 != null ? StringsKt.replace$default((String)string3, (String)"[no-]", (String)"", (boolean)false, (int)4, null) : null;
            String string4 = longName;
            objectArray[2] = string4 != null ? StringsKt.replace$default((String)string4, (String)"[no-]", (String)"no-", (boolean)false, (int)4, null) : null;
            Collection $this$toTypedArray$iv = CollectionsKt.distinct((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] name = thisCollection$iv.toArray(new String[0]);
            if (!(!(name.length == 0))) continue;
            $this$buildOptionsFromPattern.option(Arrays.copyOf(name, name.length), arg_0 -> CompletionUtilKt.buildOptionsFromPattern$lambda$2(description, argName, arg_0));
        }
    }

    public static /* synthetic */ void buildOptionsFromPattern$default(ShellChildOptionsContext shellChildOptionsContext, Pattern pattern, String string, boolean bl, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        CompletionUtilKt.buildOptionsFromPattern(shellChildOptionsContext, pattern, string, bl, set);
    }

    public static final void addRakeTasks(@NotNull ShellChildCommandsContext $this$addRakeTasks, @NotNull Project project, @NotNull String currentDirectory) {
        Module module;
        Module module2;
        Module module3;
        VirtualFile vFile;
        Intrinsics.checkNotNullParameter((Object)$this$addRakeTasks, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)currentDirectory, (String)"currentDirectory");
        VirtualFile virtualFile = vFile = VfsUtil.findFile((Path)Path.of(currentDirectory, new String[0]), (boolean)false);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            module3 = ModuleUtilCore.findModuleForFile((VirtualFile)it, (Project)project);
        } else {
            module3 = null;
        }
        if ((module2 = (module = module3)) == null || (module2 = ExtensionsKt.getRakeTasks((Module)module2)) == null) {
            module2 = SequencesKt.emptySequence();
        }
        Module tasks = module2;
        for (RakeTaskEntity task : tasks) {
            String[] stringArray = new String[]{task.getName()};
            $this$addRakeTasks.subcommand(stringArray, arg_0 -> CompletionUtilKt.addRakeTasks$lambda$4(task, arg_0));
        }
    }

    private static final Unit buildOptionsFromPattern$lambda$2$lambda$1(String $argName, ShellArgumentContext $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        $this$argument.displayName($argName);
        return Unit.INSTANCE;
    }

    private static final Unit buildOptionsFromPattern$lambda$2(String $description, String $argName, ShellOptionContext $this$option) {
        Intrinsics.checkNotNullParameter((Object)$this$option, (String)"$this$option");
        CharSequence charSequence = $description;
        if (!(charSequence == null || charSequence.length() == 0)) {
            $this$option.description($description);
        }
        if (!((charSequence = (CharSequence)$argName) == null || charSequence.length() == 0)) {
            $this$option.argument(arg_0 -> CompletionUtilKt.buildOptionsFromPattern$lambda$2$lambda$1($argName, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit addRakeTasks$lambda$4(RakeTaskEntity $task, ShellCommandContext $this$subcommand) {
        Intrinsics.checkNotNullParameter((Object)$this$subcommand, (String)"$this$subcommand");
        String description = $task.getDescription();
        CharSequence charSequence = description;
        if (!(charSequence == null || charSequence.length() == 0)) {
            $this$subcommand.description(description);
        }
        return Unit.INSTANCE;
    }
}

