/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.diagram.AbstractUmlVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.openapi.components.Service;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.uml.java.JavaProperty;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ArrayUtil;
import java.util.Comparator;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
@Service(value={Service.Level.APP})
public final class JavaUmlVisibilityManager
extends AbstractUmlVisibilityManager {
    private static final VisibilityLevel @NotNull [] OUR_LEVELS = new VisibilityLevel[]{new VisibilityLevel("public", DiagramBundle.messagePointer((String)"visibility.level.public", (Object[])new Object[0])), new VisibilityLevel("packageLocal", DiagramBundle.messagePointer((String)"visibility.level.package", (Object[])new Object[0])), new VisibilityLevel("protected", DiagramBundle.messagePointer((String)"visibility.level.protected", (Object[])new Object[0])), new VisibilityLevel("private", DiagramBundle.messagePointer((String)"visibility.level.all", (Object[])new Object[0]))};
    @NotNull
    static final Comparator<VisibilityLevel> COMPARATOR = (o1, o2) -> {
        int ind2;
        int ind1 = ArrayUtil.indexOf((Object[])OUR_LEVELS, (Object)o1);
        return ind1 == (ind2 = ArrayUtil.indexOf((Object[])OUR_LEVELS, (Object)o2)) ? 0 : (ind1 < 0 ? 1 : ind1 - ind2);
    };

    public VisibilityLevel @NotNull [] getVisibilityLevels() {
        if (OUR_LEVELS == null) {
            JavaUmlVisibilityManager.$$$reportNull$$$0(0);
        }
        return OUR_LEVELS;
    }

    public VisibilityLevel getVisibilityLevel(@Nullable Object element) {
        return JavaUmlVisibilityManager.doGetVisibilityLevel(element);
    }

    @Nullable
    static VisibilityLevel doGetVisibilityLevel(@Nullable Object element) {
        if (element instanceof JavaProperty) {
            element = ((JavaProperty)((Object)element)).getNotNullComponent();
        }
        if (element instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierList = (PsiModifierListOwner)element;
            if (modifierList.hasModifierProperty("public")) {
                return OUR_LEVELS[0];
            }
            if (modifierList.hasModifierProperty("packageLocal")) {
                return OUR_LEVELS[1];
            }
            if (modifierList.hasModifierProperty("protected")) {
                return OUR_LEVELS[2];
            }
            if (modifierList.hasModifierProperty("private")) {
                return OUR_LEVELS[3];
            }
        }
        return null;
    }

    @NotNull
    public Comparator<VisibilityLevel> getComparator() {
        Comparator<VisibilityLevel> comparator = COMPARATOR;
        if (comparator == null) {
            JavaUmlVisibilityManager.$$$reportNull$$$0(1);
        }
        return comparator;
    }

    public boolean isRelayoutNeeded() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/uml/java/JavaUmlVisibilityManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibilityLevels";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparator";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

