/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.reader;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.reader.ReaderUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class XmlStreamReader {
    private static final Logger LOG = Logger.getInstance(XmlStreamReader.class);
    protected final XmlPullParser xpp;

    public XmlStreamReader(XmlPullParser xpp) {
        this.xpp = xpp;
    }

    protected void ensureEndTag(String name) throws XmlPullParserException, IOException {
        XmlStreamReader.ensureEndTag(this.xpp, name);
    }

    public static void ensureEndTag(@NotNull XmlPullParser xpp, String name) throws XmlPullParserException, IOException {
        if (xpp == null) {
            XmlStreamReader.$$$reportNull$$$0(0);
        }
        xpp.next();
        XmlStreamReader.ensureAtEndTag(xpp, name);
    }

    protected static void ensureAtEndTag(@NotNull XmlPullParser xpp, String name) throws XmlPullParserException, IOException {
        if (xpp == null) {
            XmlStreamReader.$$$reportNull$$$0(1);
        }
        if (xpp.getEventType() != 3 && !name.equals(xpp.getName())) {
            throw new IllegalStateException("Unexpected event. Expecting " + name + " end tag." + xpp.getName());
        }
    }

    protected int nextEvent() throws XmlPullParserException, IOException {
        int eventType;
        while ((eventType = this.xpp.next()) == 4) {
            Util.logEvent(this.xpp);
        }
        Util.logEvent(this.xpp);
        return eventType;
    }

    protected String getAttributeValue(String attrName) {
        return this.xpp.getAttributeValue("", attrName);
    }

    protected int getAttributeIntValue(String attrName) {
        String value = this.getAttributeValue(attrName);
        return ReaderUtils.getAttributeIntValue(value);
    }

    protected long getAttributeLongValue(String attrName) {
        String value = this.getAttributeValue(attrName);
        return ReaderUtils.getAttributeLongValue(value);
    }

    protected boolean getAttributeBoolValue(String attrName) {
        return "true".equals(this.getAttributeValue(attrName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "xpp";
        objectArray2[1] = "org/rubyforge/debugcommons/reader/XmlStreamReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureEndTag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureAtEndTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

