/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.reader;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.RubyHashItemInfo;
import org.rubyforge.debugcommons.model.RubyVariableInfo;
import org.rubyforge.debugcommons.reader.ErrorReader;
import org.rubyforge.debugcommons.reader.XmlStreamReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class VariablesReader
extends XmlStreamReader {
    private static final Logger LOG = Logger.getInstance(VariablesReader.class);
    @NotNull
    private static final String VARIABLES_TAG = "variables";
    protected RubyVariableInfo[] variables;
    @NotNull
    private final String myTag;

    public VariablesReader(XmlPullParser xpp, @NotNull String tag) {
        if (tag == null) {
            VariablesReader.$$$reportNull$$$0(0);
        }
        super(xpp);
        this.myTag = tag;
    }

    protected void parse() throws XmlPullParserException, IOException {
        String element = this.xpp.getName();
        assert (element.equals(this.myTag) || element.equals("processingException"));
        if (element.equals(this.myTag)) {
            this.parseVariables();
        } else {
            this.parseProcessingException();
        }
    }

    private void parseVariables() throws XmlPullParserException, IOException {
        String variablesType = this.xpp.getAttributeValue("", "type");
        ArrayList<RubyVariableInfo> _variables = new ArrayList<RubyVariableInfo>();
        while (this.nextEvent() != 3 || !this.myTag.equals(this.xpp.getName())) {
            if (this.xpp.getName() == null) {
                throw new XmlPullParserException("xpp.getName() returned 'null'. Segmentation fault. Bug in the Ruby interpreter/VM. Please provide possibly exact steps to reproduce and file a bug against Ruby or debug-commons tracker.");
            }
            ErrorReader.flushPossibleMessage(this.xpp);
            if (Util.isEndTag(this.xpp, this.myTag)) break;
            _variables.add(this.parseVariable());
        }
        if ("hashItem".equals(variablesType)) {
            if (_variables.size() % 2 != 0) {
                LOG.error("Odd number of hashItems, maybe lost some key/value");
            }
            ArrayList<RubyHashItemInfo> hashItems = new ArrayList<RubyHashItemInfo>();
            for (int i = 0; i < _variables.size(); i += 2) {
                if (i + 1 >= _variables.size()) continue;
                hashItems.add(new RubyHashItemInfo((RubyVariableInfo)_variables.get(i), (RubyVariableInfo)_variables.get(i + 1)));
            }
            _variables = hashItems;
        }
        this.variables = _variables.toArray(new RubyVariableInfo[0]);
    }

    @NotNull
    protected RubyVariableInfo parseVariable() throws XmlPullParserException, IOException {
        assert (this.xpp.getName().equals("variable")) : this.xpp.getName() + "(type: " + Util.getType(this.xpp) + ") encountered";
        String name = this.getAttributeValue("name");
        String compactValue = this.getAttributeValue("compactValue");
        if (compactValue != null) {
            compactValue = StringUtil.unescapeXmlEntities((String)compactValue);
        }
        String value = this.getAttributeValue("value");
        String kind = this.getAttributeValue("kind");
        String type = this.getAttributeValue("type");
        boolean hasChildren = this.getAttributeBoolValue("hasChildren");
        String objectId = this.getAttributeValue("objectId");
        long valueStringSize = this.getAttributeLongValue("valueStrSize");
        HashMap<String, String> additionalTags = null;
        for (String tag : RubyVariableInfo.ADDITIONAL_TAGS) {
            String attribute = this.getAttributeValue(tag);
            if (attribute == null) continue;
            if (additionalTags == null) {
                additionalTags = new HashMap<String, String>();
            }
            additionalTags.put(tag, attribute);
        }
        value = this.readValueFromElement(value);
        VariablesReader.ensureAtEndTag(this.xpp, "variable");
        return new RubyVariableInfo(name, compactValue, kind, value, valueStringSize, type, hasChildren, objectId, additionalTags);
    }

    @Nullable
    private String readValueFromElement(@Nullable String defaultValue) throws IOException, XmlPullParserException {
        String value = defaultValue;
        int nextTag = this.xpp.next();
        if (nextTag == 2 && "value".equals(this.xpp.getName())) {
            this.xpp.next();
            if (this.xpp.getEventType() == 4) {
                value = this.xpp.getText();
                this.xpp.next();
            }
            VariablesReader.ensureAtEndTag(this.xpp, "value");
            this.xpp.next();
        }
        return value == null ? null : StringUtil.unescapeXmlEntities((String)value);
    }

    private void parseProcessingException() throws XmlPullParserException, IOException {
        LOG.error("Processing exception occured. exceptionMessage: " + this.getAttributeValue("message") + ", exceptionType: " + this.getAttributeValue("type"));
        this.ensureEndTag("processingException");
    }

    public static RubyVariableInfo[] readVariables(XmlPullParser xpp) throws IOException, XmlPullParserException {
        VariablesReader reader = new VariablesReader(xpp, VARIABLES_TAG);
        reader.parse();
        return reader.variables;
    }

    public static void logProcessingException(XmlPullParser xpp) throws IOException, XmlPullParserException {
        VariablesReader reader = new VariablesReader(xpp, VARIABLES_TAG);
        reader.parse();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/rubyforge/debugcommons/reader/VariablesReader", "<init>"));
    }
}

