/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.reader;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import org.rubyforge.debugcommons.model.RubyFullValueInfo;
import org.rubyforge.debugcommons.reader.XmlStreamReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FullValueReader
extends XmlStreamReader {
    private static final Logger LOG = Logger.getInstance(FullValueReader.class);
    private RubyFullValueInfo myRubyFullValueInfo;

    public FullValueReader(XmlPullParser xpp) {
        super(xpp);
    }

    private void parse() throws XmlPullParserException, IOException {
        String name = this.xpp.getName();
        LOG.assertTrue(name.equals("fullValue"), (Object)("Current name is '" + name + ". Expected name is 'fullValue'."));
        String value = StringUtil.unescapeXmlEntities((String)StringUtil.notNullize((String)this.getAttributeValue("value")));
        long size = this.getAttributeLongValue("size");
        long fullSize = this.getAttributeLongValue("fullSize");
        this.myRubyFullValueInfo = new RubyFullValueInfo(value, size, fullSize);
        this.ensureEndTag(name);
    }

    public static RubyFullValueInfo readFullValueInfo(XmlPullParser xpp) throws IOException, XmlPullParserException {
        FullValueReader reader = new FullValueReader(xpp);
        reader.parse();
        return reader.myRubyFullValueInfo;
    }
}

