/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.reader;

import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import org.rubyforge.debugcommons.model.ExpressionInfo;
import org.rubyforge.debugcommons.reader.XmlStreamReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ExpressionInfoReader
extends XmlStreamReader {
    private ExpressionInfo expressionInfo;

    public ExpressionInfoReader(XmlPullParser xpp) {
        super(xpp);
    }

    private void parse() throws XmlPullParserException, IOException {
        assert (this.xpp.getName().equals("expressionInfo"));
        boolean incomplete = this.getAttributeBoolValue("incomplete");
        String promptType = this.getAttributeValue("prompt");
        int indent = this.getAttributeIntValue("indent");
        String errorMessage = StringUtil.unescapeXmlEntities((String)StringUtil.notNullize((String)this.getAttributeValue("error_message")));
        this.expressionInfo = new ExpressionInfo(incomplete, StringUtil.nullize((String)promptType), indent, errorMessage);
        this.ensureEndTag("expressionInfo");
    }

    public static ExpressionInfo readExpressionInfo(XmlPullParser xpp) throws IOException, XmlPullParserException {
        ExpressionInfoReader reader = new ExpressionInfoReader(xpp);
        reader.parse();
        return reader.expressionInfo;
    }
}

