/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.rubyforge.debugcommons.model.RubySuspensionLocation;

public abstract class SuspensionPoint {
    public static final SuspensionPoint END = new EndSuspensionPoint();
    private String myFile;
    private int myLine;
    private int myThreadId = -1;
    @NonNls
    @Nullable
    private String myConditionException;

    public SuspensionPoint() {
    }

    public SuspensionPoint(String file, int line, int threadId, @NonNls @Nullable String conditionException) {
        this.myFile = file;
        this.myLine = line;
        this.myThreadId = threadId;
        this.myConditionException = conditionException;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getPosition() + ", threadId: " + this.getThreadId();
    }

    public abstract boolean isException();

    public abstract boolean isStep();

    public abstract boolean isBreakpoint();

    public String getFile() {
        return this.myFile;
    }

    public int getLine() {
        return this.myLine;
    }

    @NonNls
    @Nullable
    public String getConditionException() {
        return this.myConditionException;
    }

    public String getPosition() {
        return this.getFile() + ":" + this.getLine();
    }

    public int getThreadId() {
        return this.myThreadId;
    }

    @Nullable
    public RubySuspensionLocation getLocation() {
        return null;
    }

    private static final class EndSuspensionPoint
    extends SuspensionPoint {
        private EndSuspensionPoint() {
        }

        @Override
        @Nullable
        @NonNls
        public String getConditionException() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName();
        }

        @Override
        public boolean isException() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isStep() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isBreakpoint() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public RubySuspensionLocation getLocation() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

