/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class RubyFrameInfo {
    @Nullable
    private final String myFile;
    @Nullable
    private final String myLabel;
    private final int myLine;
    private final int myIndex;
    private final boolean myHasAdditionalLocation;

    public RubyFrameInfo(@Nullable String file, int line, int index) {
        this(file, null, line, index, false);
    }

    public RubyFrameInfo(@Nullable String file, @Nullable String label, int line, int index, boolean hasAdditionalLocation) {
        this.myFile = file;
        this.myLabel = label;
        this.myLine = line;
        this.myIndex = index;
        this.myHasAdditionalLocation = hasAdditionalLocation;
    }

    @Nullable
    public String getLabel() {
        return this.myLabel;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public int getLine() {
        return this.myLine;
    }

    @Nullable
    public String getFile() {
        return this.myFile;
    }

    public boolean isHasAdditionalLocation() {
        return this.myHasAdditionalLocation;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RubyFrameInfo)) {
            return false;
        }
        RubyFrameInfo other = (RubyFrameInfo)obj;
        return Objects.equals(this.myFile, other.myFile) && this.myLine == other.myLine && this.myIndex == other.myIndex;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.myFile != null ? this.myFile.hashCode() : 0);
        hash = 59 * hash + this.myLine;
        hash = 59 * hash + this.myIndex;
        return hash;
    }

    public String toString() {
        return "RubyFrameInfo{myFile='" + this.myFile + "', myLabel='" + this.myLabel + "', myLine=" + this.myLine + ", myIndex=" + this.myIndex + ", myHasAdditionalLocation=" + this.myHasAdditionalLocation + "}";
    }
}

