/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.model.ExpressionInfo;
import org.rubyforge.debugcommons.model.RubyEntity;
import org.rubyforge.debugcommons.model.RubyFrameInfo;
import org.rubyforge.debugcommons.model.RubyFullValue;
import org.rubyforge.debugcommons.model.RubySuspensionLocation;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyVariable;

public final class RubyFrame
extends RubyEntity {
    private static final Logger LOG = Logger.getInstance(RubyFrame.class);
    public static final RubyFrame[] EMPTY_ARRAY = new RubyFrame[0];
    private final RubyFrameInfo myFrameInfo;
    private final RubyThread myRubyThread;
    @Nullable
    private RubySuspensionLocation myLocation = null;
    @Nullable
    private RubyVariable myReceiver;
    @Nullable
    private RubyVariable myReturnValue;
    private final SynchronizedClearableLazy<RubyVariable @Nullable []> myVrariablesProvider = new SynchronizedClearableLazy(this::computeVariables);

    public RubyFrame(RubyThread rubyThread, RubyFrameInfo frameInfo) {
        super(rubyThread.getProxy());
        this.myFrameInfo = frameInfo;
        this.myRubyThread = rubyThread;
    }

    @NlsSafe
    public String getFile() {
        return this.myFrameInfo.getFile();
    }

    public int getLine() {
        return this.myFrameInfo.getLine();
    }

    @Nullable
    @NlsSafe
    public String getLabel() {
        return this.myFrameInfo.getLabel();
    }

    public int getIndex() {
        return this.myFrameInfo.getIndex();
    }

    public RubyThread getThread() {
        return this.myRubyThread;
    }

    @NotNull
    public RubyVariable getReceiver() throws RubyDebuggerException {
        if (this.myReceiver == null) {
            this.myReceiver = this.getProxy().readReceiver(this);
        }
        RubyVariable rubyVariable = this.myReceiver;
        if (rubyVariable == null) {
            RubyFrame.$$$reportNull$$$0(0);
        }
        return rubyVariable;
    }

    @NotNull
    public RubyVariable getReturnValue() throws RubyDebuggerException {
        if (this.myReturnValue == null) {
            this.myReturnValue = this.getProxy().readReturnValue(this);
        }
        RubyVariable rubyVariable = this.myReturnValue;
        if (rubyVariable == null) {
            RubyFrame.$$$reportNull$$$0(1);
        }
        return rubyVariable;
    }

    public RubyVariable @NotNull [] getVariables() {
        RubyVariable[] rubyVariableArray = Objects.requireNonNull((RubyVariable[])this.myVrariablesProvider.getValue());
        if (rubyVariableArray == null) {
            RubyFrame.$$$reportNull$$$0(2);
        }
        return rubyVariableArray;
    }

    private RubyVariable @NotNull [] computeVariables() {
        RubyVariable[] rubyVariableArray;
        try {
            rubyVariableArray = this.getProxy().readVariables(this);
        }
        catch (RubyDebuggerException e) {
            LOG.warn("Unable to read variables for " + String.valueOf(this), (Throwable)e);
            if (RubyVariable.EMPTY_ARRAY == null) {
                RubyFrame.$$$reportNull$$$0(4);
            }
            return RubyVariable.EMPTY_ARRAY;
        }
        if (rubyVariableArray == null) {
            RubyFrame.$$$reportNull$$$0(3);
        }
        return rubyVariableArray;
    }

    public void clearCachedVariables() {
        this.myVrariablesProvider.drop();
        this.myReceiver = null;
        this.myReturnValue = null;
    }

    public ExpressionInfo expressionInfo(String expression) throws RubyDebuggerException {
        return this.getProxy().getExpressionInfo(this, expression);
    }

    public RubyVariable inspectExpression(String expression) throws RubyDebuggerException {
        return this.getProxy().inspectExpression(this, expression);
    }

    @NotNull
    public RubyFullValue loadFullValue(@NotNull String expression, boolean unlimited) throws RubyDebuggerException {
        if (expression == null) {
            RubyFrame.$$$reportNull$$$0(5);
        }
        RubyFullValue rubyFullValue = this.getProxy().readFullValue(this, unlimited, expression);
        if (rubyFullValue == null) {
            RubyFrame.$$$reportNull$$$0(6);
        }
        return rubyFullValue;
    }

    public String getName() {
        return this.getFile() + ":" + this.getLine();
    }

    @Nullable
    public RubySuspensionLocation getLocation() {
        return this.myLocation;
    }

    public void setLocation(@Nullable RubySuspensionLocation location) {
        this.myLocation = location;
    }

    public String toString() {
        return "RubyFrame{info=" + String.valueOf(this.myFrameInfo) + ", myRubyThread=" + String.valueOf(this.myRubyThread) + ", myLocation=" + String.valueOf(this.myLocation) + ", myReceiver=" + String.valueOf(this.myReceiver) + ", myReturnValue=" + String.valueOf(this.myReturnValue) + ", variables.cached=" + this.myVrariablesProvider.isInitialized() + "}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RubyFrame)) {
            return false;
        }
        RubyFrame other = (RubyFrame)obj;
        return this.myFrameInfo == null ? other.myFrameInfo == null : this.myFrameInfo.equals(other.myFrameInfo);
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + (this.myFrameInfo != null ? this.myFrameInfo.hashCode() : 0);
        return hash;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/rubyforge/debugcommons/model/RubyFrame";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceiver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVariables";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/rubyforge/debugcommons/model/RubyFrame";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFullValue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadFullValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5 -> new IllegalArgumentException(string);
        };
    }
}

