/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.IRubyLineBreakpoint;
import org.rubyforge.debugcommons.model.RubySuspensionLocation;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.SuspensionPoint;

public final class RubyDebugEvent {
    @Nullable
    private final RubyThread rubyThread;
    private final SuspensionPoint sp;
    private boolean isTerminate;
    @NotNull
    private ThreeState myIsBreakpointValid;
    @Nullable
    private IRubyLineBreakpoint myBreakpoint;
    @NotNull
    private final RubyDebuggerProxy origin;

    @NotNull
    static RubyDebugEvent createTerminateEvent(@NotNull RubyDebuggerProxy origin) {
        if (origin == null) {
            RubyDebugEvent.$$$reportNull$$$0(0);
        }
        RubyDebugEvent e = new RubyDebugEvent(origin, null, null);
        e.isTerminate = true;
        RubyDebugEvent rubyDebugEvent = e;
        if (rubyDebugEvent == null) {
            RubyDebugEvent.$$$reportNull$$$0(1);
        }
        return rubyDebugEvent;
    }

    @NotNull
    static RubyDebugEvent createBreakpointSetEvent(@NotNull RubyDebuggerProxy origin, @NotNull IRubyLineBreakpoint breakpoint, @NotNull ThreeState isBreakpointValid) {
        if (origin == null) {
            RubyDebugEvent.$$$reportNull$$$0(2);
        }
        if (breakpoint == null) {
            RubyDebugEvent.$$$reportNull$$$0(3);
        }
        if (isBreakpointValid == null) {
            RubyDebugEvent.$$$reportNull$$$0(4);
        }
        RubyDebugEvent event = new RubyDebugEvent(origin, null, null);
        event.myBreakpoint = breakpoint;
        event.myIsBreakpointValid = isBreakpointValid;
        RubyDebugEvent rubyDebugEvent = event;
        if (rubyDebugEvent == null) {
            RubyDebugEvent.$$$reportNull$$$0(5);
        }
        return rubyDebugEvent;
    }

    public RubyDebugEvent(@NotNull RubyDebuggerProxy origin, @Nullable RubyThread rubyThread, SuspensionPoint sp) {
        if (origin == null) {
            RubyDebugEvent.$$$reportNull$$$0(6);
        }
        this.myIsBreakpointValid = ThreeState.UNSURE;
        this.origin = origin;
        if (sp != null) assert (rubyThread != null);
        this.sp = sp;
        this.rubyThread = rubyThread;
    }

    public boolean isSuspensionType() {
        return !this.isTerminate && (this.sp.isBreakpoint() || this.sp.isStep());
    }

    public boolean isTerminateType() {
        return this.isTerminate;
    }

    public boolean isExceptionType() {
        return !this.isTerminate && this.sp.isException();
    }

    @Nullable
    public RubyThread getRubyThread() {
        return this.rubyThread;
    }

    public SuspensionPoint getSuspensionPoint() {
        return this.sp;
    }

    public String getFilePath() {
        return this.sp.getFile();
    }

    @Nullable
    public RubySuspensionLocation getLocation() {
        return this.sp.getLocation();
    }

    public int getLine() {
        return this.sp.getLine();
    }

    @Nullable
    public IRubyLineBreakpoint getBreakpoint() {
        return this.myBreakpoint;
    }

    @NotNull
    public ThreeState isBreakpointValid() {
        ThreeState threeState = this.myIsBreakpointValid;
        if (threeState == null) {
            RubyDebugEvent.$$$reportNull$$$0(7);
        }
        return threeState;
    }

    @NotNull
    public RubyDebuggerProxy getOrigin() {
        RubyDebuggerProxy rubyDebuggerProxy = this.origin;
        if (rubyDebuggerProxy == null) {
            RubyDebugEvent.$$$reportNull$$$0(8);
        }
        return rubyDebuggerProxy;
    }

    public String toString() {
        if (this.isTerminate) {
            return "[RubyDebugEvent@" + System.identityHashCode(this) + "> Terminate Event on " + String.valueOf(this.origin);
        }
        if (this.myBreakpoint != null) {
            return "[RubyDebugEvent@" + System.identityHashCode(this) + "> Breakpoint set: " + String.valueOf(this.myBreakpoint) + "(valid: " + String.valueOf(this.myIsBreakpointValid) + ")";
        }
        return "[RubyDebugEvent@" + System.identityHashCode(this) + "> type: " + String.valueOf(this.sp) + ", rubyThread: " + String.valueOf(this.rubyThread) + ", line: " + this.sp.getLine() + ", filePath: " + this.sp.getFile() + ", proxy: " + String.valueOf(this.origin) + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/rubyforge/debugcommons/RubyDebugEvent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isBreakpointValid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/rubyforge/debugcommons/RubyDebugEvent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTerminateEvent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createBreakpointSetEvent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "isBreakpointValid";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrigin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTerminateEvent";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointSetEvent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

