/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.fixtures.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.Language;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import icons.RubyIcons;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.fixtures.RailsFixturesUtils;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.psi.RailsTestFileFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyTrackedCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.yaml.psi.YAMLFile;

final class RailsFixturesRecordCompletionProvider
extends RubyTrackedCompletionProvider {
    private static final RailsFixturesRecordCompletionProvider INSTANCE = new RailsFixturesRecordCompletionProvider();
    static final PsiElementPattern.Capture<PsiElement> FIXTURE_METHOD_PATTERN = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).inside(RCall.class)).inFile((ElementPattern)PlatformPatterns.psiFile(RFile.class).and((ElementPattern)new FilterPattern((ElementFilter)new RailsTestFileFilter())))).afterLeaf(new String[]{":"});

    private RailsFixturesRecordCompletionProvider() {
        super((Language)RubyLanguage.INSTANCE);
    }

    protected void addCompletionsTracked(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement element;
        RExpression expression;
        if (parameters == null) {
            RailsFixturesRecordCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RailsFixturesRecordCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            RailsFixturesRecordCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((expression = (RExpression)PsiTreeUtil.getParentOfType((PsiElement)(element = parameters.getPosition()), RExpression.class)) == null) {
            return;
        }
        RCall call = RCallNavigator.getByRArgument((PsiElement)expression);
        if (call == null) {
            return;
        }
        String callName = call.getName();
        if (StringUtil.isEmpty((String)callName)) {
            return;
        }
        RailsApp railsApp = RailsApp.fromPsiElement((PsiElement)call);
        if (railsApp == null) {
            return;
        }
        YAMLFile fixtureFile = RailsFixturesUtils.findFixtureFile(railsApp, callName);
        if (fixtureFile == null) {
            return;
        }
        Set existingArguments = call.getArguments().stream().filter(arg -> arg instanceof RSymbol).map(NavigationItem::getName).filter(StringUtil::isNotEmpty).collect(Collectors.toSet());
        RailsFixturesUtils.getRecordLabels(fixtureFile).stream().filter(recordName -> !existingArguments.contains(recordName)).forEach(recordName -> RailsFixturesRecordCompletionProvider.addLookupElement(result, recordName, fixtureFile));
    }

    private static void addLookupElement(@NotNull CompletionResultSet result, @NotNull String recordName, @NotNull YAMLFile fixtureFile) {
        if (result == null) {
            RailsFixturesRecordCompletionProvider.$$$reportNull$$$0(3);
        }
        if (recordName == null) {
            RailsFixturesRecordCompletionProvider.$$$reportNull$$$0(4);
        }
        if (fixtureFile == null) {
            RailsFixturesRecordCompletionProvider.$$$reportNull$$$0(5);
        }
        RubyLookupElement lookupElement = new RubyLookupElement(recordName, null, fixtureFile.getVirtualFile().getPresentableName(), true, RubyIcons.Ruby.Nodes.Symbol, null);
        result.consume(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)RubyCompletionGrouping.LOCAL_OR_PARAMETER.getValue()));
    }

    @NotNull
    public static RailsFixturesRecordCompletionProvider getInstance() {
        RailsFixturesRecordCompletionProvider railsFixturesRecordCompletionProvider = INSTANCE;
        if (railsFixturesRecordCompletionProvider == null) {
            RailsFixturesRecordCompletionProvider.$$$reportNull$$$0(6);
        }
        return railsFixturesRecordCompletionProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixtureFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/fixtures/codeInsight/completion/RailsFixturesRecordCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/fixtures/codeInsight/completion/RailsFixturesRecordCompletionProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionsTracked";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addLookupElement";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

