/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.fixtures.codeInsight.callTypes;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.fixtures.RailsFixturesUtils;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ArgumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RTypedSyntheticSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubySymbolDefiningCallType;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtilCore;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class RailsFixturesCallType
extends RubySymbolDefiningCallType {
    static final RailsFixturesCallType INSTANCE = new RailsFixturesCallType();

    private RailsFixturesCallType() {
        super("fixtures");
        this.withSkipHashArguments();
    }

    protected boolean processArgument(@NotNull Symbol parent, @NotNull RCall call, @NotNull Processor<? super Symbol> processor, @NotNull String argument, @Nullable PsiElement invocationPoint) {
        if (parent == null) {
            RailsFixturesCallType.$$$reportNull$$$0(0);
        }
        if (call == null) {
            RailsFixturesCallType.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            RailsFixturesCallType.$$$reportNull$$$0(2);
        }
        if (argument == null) {
            RailsFixturesCallType.$$$reportNull$$$0(3);
        }
        if (!argument.equals("all")) {
            return processor.process((Object)RailsFixturesCallType.createSymbol(new MyPsiElement(call, argument, argument), parent, invocationPoint));
        }
        RailsApp railsApp = RailsApp.fromPsiElement((PsiElement)call);
        if (railsApp == null) {
            return true;
        }
        return RailsFixturesUtils.walkFixtureFileRoots(railsApp, (root, fileOrDir) -> {
            ProgressManager.checkCanceled();
            if (fileOrDir.isDirectory()) {
                return true;
            }
            String name = Optional.ofNullable(VfsUtilCore.getRelativePath((VirtualFile)fileOrDir, (VirtualFile)root)).map(StringUtil::trimExtensions).map(path -> path.replaceAll("/", "_")).orElse(null);
            if (StringUtil.isEmpty((String)name)) {
                return true;
            }
            return processor.process((Object)RailsFixturesCallType.createSymbol(new MyPsiElement(call, name, argument), parent, invocationPoint));
        });
    }

    @NotNull
    private static RTypedSyntheticSymbol createSymbol(@NotNull MyPsiElement declaration, @NotNull Symbol parent, @Nullable PsiElement invocationPoint) {
        if (declaration == null) {
            RailsFixturesCallType.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            RailsFixturesCallType.$$$reportNull$$$0(5);
        }
        Project project = declaration.getProject();
        Module module = parent.getModule();
        String fqn = NamingConventions.toCamelCase((String)StringUtil.unpluralize((String)declaration.getName()), (Module)module);
        RType instanceType = RTypeFactory.createTypeByFQN((Project)project, (String)fqn);
        RType arrayType = RTypeFactory.createArrayType((Project)project, (RType)instanceType);
        RType returnType = invocationPoint instanceof RCall ? (((RCall)invocationPoint).getArguments().size() == 1 ? instanceType : arrayType) : RTypeUtil.union((RType)instanceType, (RType)RTypeFactory.createArrayType((Project)project, (RType)instanceType));
        List<ArgumentInfo> argumentInfos = Collections.singletonList(new ArgumentInfo("fixture_names", ArgumentInfo.Type.ARRAY));
        return new RTypedSyntheticSymbol(project, declaration.getName(), Type.INSTANCE_METHOD, parent, returnType, argumentInfos, (PsiElement)declaration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/fixtures/codeInsight/callTypes/RailsFixturesCallType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processArgument";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createSymbol";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyPsiElement
    extends ArgumentFakePsiElement {
        private static final Icon ICON = RContainerPresentationUtilCore.createIconWithAccessSign((Icon)AllIcons.Nodes.Method, (Visibility)Visibility.PUBLIC);
        private final String myNavigationElementName;

        private MyPsiElement(@NotNull RCall call, @NotNull String name, @NotNull String navigationElementName) {
            if (call == null) {
                MyPsiElement.$$$reportNull$$$0(0);
            }
            if (name == null) {
                MyPsiElement.$$$reportNull$$$0(1);
            }
            if (navigationElementName == null) {
                MyPsiElement.$$$reportNull$$$0(2);
            }
            super(call, name);
            this.myNavigationElementName = navigationElementName;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = ICON;
            if (icon == null) {
                MyPsiElement.$$$reportNull$$$0(3);
            }
            return icon;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return this.getArgumentByName(this.myNavigationElementName);
        }

        @NotNull
        public String getTypeName() {
            String string = RBundle.message((String)"method");
            if (string == null) {
                MyPsiElement.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigationElementName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/fixtures/codeInsight/callTypes/RailsFixturesCallType$MyPsiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/fixtures/codeInsight/callTypes/RailsFixturesCallType$MyPsiElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

