/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.fixtures;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbFileType;
import org.jetbrains.plugins.ruby.rails.associations.AssociationType;
import org.jetbrains.plugins.ruby.rails.associations.AssociationsUtil;
import org.jetbrains.plugins.ruby.rails.fixtures.indexes.YamlTopLevelKeysIndex;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.psi.RailsFixtureFileFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;

public final class RailsFixturesUtils {
    private static final EnumSet<AssociationType> FIXTURE_SUPPORTED_ASSOCIATIONS = EnumSet.of(AssociationType.BELONGS_TO, AssociationType.HAS_AND_BELONGS_TO_MANY);
    private static final Set<FileType> FIXTURE_FILE_TYPES = Set.of(ErbFileType.ERB, YAMLFileType.YML);
    public static final String FIXTURES_NAME = "fixtures";
    public static final String ALL_FIXTURES = "all";
    public static final PsiElementPattern.Capture<YAMLKeyValue> RAILS_FIXTURE_YAML_RECORD_PATTERN = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(YAMLKeyValue.class).withParents(new Class[]{YAMLMapping.class, YAMLDocument.class, YAMLFile.class})).inFile((ElementPattern)PlatformPatterns.psiFile(YAMLFile.class).and((ElementPattern)new FilterPattern((ElementFilter)new RailsFixtureFileFilter())));

    private RailsFixturesUtils() {
    }

    public static boolean walkFixtureFileRoots(@NotNull RailsApp railsApp, @NotNull BiFunction<? super VirtualFile, ? super VirtualFile, Boolean> consumer) {
        if (railsApp == null) {
            RailsFixturesUtils.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            RailsFixturesUtils.$$$reportNull$$$0(1);
        }
        Project project = railsApp.getProject();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFileFilter filter = GlobalSearchScopesCore.projectTestScope((Project)project).and(file -> FIXTURE_FILE_TYPES.contains(file.getFileType()));
        for (VirtualFile root : railsApp.getFixtureFileRoots()) {
            boolean result;
            ProgressIndicatorProvider.checkCanceled();
            if (!index.isInTestSourceContent(root) || (result = index.iterateContentUnderDirectory(root, fileOrDir -> (Boolean)consumer.apply(root, fileOrDir), filter))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static YAMLFile findFixtureFile(@NotNull RailsApp railsApp, @NotNull String baseName) {
        FileViewProvider viewProvider;
        if (railsApp == null) {
            RailsFixturesUtils.$$$reportNull$$$0(2);
        }
        if (baseName == null) {
            RailsFixturesUtils.$$$reportNull$$$0(3);
        }
        Project project = railsApp.getProject();
        GlobalSearchScope fixtureRootsScope = GlobalSearchScopes.directoriesScope((Project)project, (boolean)true, (VirtualFile[])railsApp.getFixtureFileRoots().toArray(VirtualFile.EMPTY_ARRAY));
        HashSet fixtureFiles = new HashSet(FilenameIndex.getVirtualFilesByName((String)(baseName + ".yml"), (GlobalSearchScope)fixtureRootsScope));
        if (fixtureFiles.isEmpty()) {
            fixtureFiles.addAll(FilenameIndex.getVirtualFilesByName((String)(baseName + ".yaml"), (GlobalSearchScope)fixtureRootsScope));
        }
        if ((viewProvider = (FileViewProvider)ObjectUtils.doIfNotNull((Object)((VirtualFile)ContainerUtil.getFirstItem(fixtureFiles)), file -> PsiManager.getInstance((Project)project).findViewProvider(file))) == null) {
            return null;
        }
        return (YAMLFile)viewProvider.getPsi((Language)YAMLLanguage.INSTANCE);
    }

    @NotNull
    public static Set<String> getRecordLabels(@NotNull YAMLFile fixtureFile) {
        if (fixtureFile == null) {
            RailsFixturesUtils.$$$reportNull$$$0(4);
        }
        VirtualFile vFixtureFile = fixtureFile.getVirtualFile();
        Project project = fixtureFile.getProject();
        Set<String> labels = (Set<String>)FileBasedIndex.getInstance().getSingleEntryIndexData(YamlTopLevelKeysIndex.KEY, vFixtureFile, project);
        Set<String> set = labels != null ? labels : Collections.emptySet();
        if (set == null) {
            RailsFixturesUtils.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Nullable
    public static RCall findAssociationByFixtureMapping(@NotNull RClass modelClass, @NotNull YAMLKeyValue keyValue) {
        Symbol modelSymbol;
        if (modelClass == null) {
            RailsFixturesUtils.$$$reportNull$$$0(6);
        }
        if (keyValue == null) {
            RailsFixturesUtils.$$$reportNull$$$0(7);
        }
        if ((modelSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)modelClass)) == null) {
            return null;
        }
        String keyName = keyValue.getKeyText();
        if (StringUtil.isEmpty((String)keyName)) {
            return null;
        }
        RCall association = AssociationsUtil.findAssociation((Symbol)modelSymbol, (String)keyName, null);
        return RailsFixturesUtils.isFixtureSupportedAssociation(association) ? association : null;
    }

    @Nullable
    public static RClass findModelByFixtureFile(@NotNull Module module, @NotNull YAMLFile fixtureFile) {
        VirtualFile vFixtureFile;
        if (module == null) {
            RailsFixturesUtils.$$$reportNull$$$0(8);
        }
        if (fixtureFile == null) {
            RailsFixturesUtils.$$$reportNull$$$0(9);
        }
        if ((vFixtureFile = fixtureFile.getOriginalFile().getVirtualFile()) == null) {
            return null;
        }
        FQN modelFqn = AssociationsUtil.classify((Module)module, (String)vFixtureFile.getNameWithoutExtension());
        RContainer modelClass = RubyFQNUtil.findContainerByFQN((Project)module.getProject(), (TypeSet)Types.MODULE_OR_CLASS, (FQN)modelFqn, null);
        return (RClass)ObjectUtils.tryCast((Object)modelClass, RClass.class);
    }

    @Contract(value="null -> false")
    public static boolean isFixtureSupportedAssociation(@Nullable RCall associationCall) {
        return associationCall != null && FIXTURE_SUPPORTED_ASSOCIATIONS.contains(AssociationsUtil.getAssociationType((RCall)associationCall));
    }

    @NotNull
    public static String singularize(@NotNull Module module, @NotNull String plural) {
        String singular;
        if (module == null) {
            RailsFixturesUtils.$$$reportNull$$$0(10);
        }
        if (plural == null) {
            RailsFixturesUtils.$$$reportNull$$$0(11);
        }
        String string = (singular = AssociationsUtil.singularize((Module)module, (String)plural)) != null ? singular : Objects.requireNonNullElse(StringUtil.unpluralize((String)plural), plural);
        if (string == null) {
            RailsFixturesUtils.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String pluralize(@NotNull Module module, @NotNull String singular) {
        String plural;
        if (module == null) {
            RailsFixturesUtils.$$$reportNull$$$0(13);
        }
        if (singular == null) {
            RailsFixturesUtils.$$$reportNull$$$0(14);
        }
        String string = (plural = AssociationsUtil.pluralize((Module)module, (String)singular)) != null ? plural : StringUtil.pluralize((String)singular);
        if (string == null) {
            RailsFixturesUtils.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsApp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixtureFile";
                break;
            }
            case 5: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/fixtures/RailsFixturesUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plural";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singular";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/fixtures/RailsFixturesUtils";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordLabels";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "singularize";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "walkFixtureFileRoots";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFixtureFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRecordLabels";
                break;
            }
            case 5: 
            case 12: 
            case 15: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findAssociationByFixtureMapping";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findModelByFixtureFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "singularize";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 12, 15 -> new IllegalStateException(string);
        };
    }
}

