/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.indexes;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.FileContent;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlRecursivePsiElementVisitor;

final class I18nYamlIndexUtil {
    private I18nYamlIndexUtil() {
    }

    static void visitYamlI18nLikeKeys(@NotNull FileContent inputData, final @NotNull BiConsumer<String, String> consumer) {
        if (inputData == null) {
            I18nYamlIndexUtil.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            I18nYamlIndexUtil.$$$reportNull$$$0(1);
        }
        PsiFile file = inputData.getPsiFile();
        PsiFile originalFile = (PsiFile)ObjectUtils.coalesce((Object)TemplateLanguageUtil.getTemplateFile((PsiFile)file), (Object)file);
        originalFile.accept((PsiElementVisitor)new YamlRecursivePsiElementVisitor(){

            public void visitKeyValue(@NotNull YAMLKeyValue keyValue) {
                if (keyValue == null) {
                    1.$$$reportNull$$$0(0);
                }
                I18nYamlIndexUtil.processKeyValue(keyValue, consumer);
                super.visitKeyValue(keyValue);
            }

            public void visitSequence(@NotNull YAMLSequence sequence) {
                if (sequence == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "keyValue";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sequence";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/indexes/I18nYamlIndexUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitKeyValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSequence";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void processKeyValue(@NotNull YAMLKeyValue keyValue, @NotNull BiConsumer<String, String> consumer) {
        PsiElement key;
        if (keyValue == null) {
            I18nYamlIndexUtil.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            I18nYamlIndexUtil.$$$reportNull$$$0(3);
        }
        if ((key = keyValue.getKey()) == null) {
            return;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)keyValue, YAMLSequence.class) != null) {
            return;
        }
        String fullPath = YAMLUtil.getConfigFullName((YAMLPsiElement)keyValue);
        int idx = fullPath.indexOf(".");
        if (idx == -1) {
            return;
        }
        if (keyValue.getValue() instanceof YAMLScalar || keyValue.getValue() instanceof YAMLSequence) {
            consumer.accept(fullPath, keyValue.getValueText());
            return;
        }
        String otherTranslation = I18nYamlIndexUtil.getPluralizedKeyTranslation(keyValue);
        if (otherTranslation != null) {
            consumer.accept(fullPath, otherTranslation);
        }
    }

    @Nullable
    private static String getPluralizedKeyTranslation(@NotNull YAMLKeyValue element) {
        if (element == null) {
            I18nYamlIndexUtil.$$$reportNull$$$0(4);
        }
        boolean hasOne = false;
        String other = null;
        YAMLValue value = element.getValue();
        if (value instanceof YAMLMapping) {
            for (YAMLKeyValue child : ((YAMLMapping)value).getKeyValues()) {
                String text = child.getKeyText();
                hasOne |= "one".equals(text);
                if (!"other".equals(text)) continue;
                other = child.getValueText();
            }
        }
        return hasOne && other != null ? other : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/indexes/I18nYamlIndexUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitYamlI18nLikeKeys";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processKeyValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPluralizedKeyTranslation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

