/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.indexes;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.i18n.indexes.I18nYamlIndexUtil;
import org.jetbrains.plugins.ruby.util.YamlIndexUtil;

public final class I18nYAMLTranslationIndex
extends FileBasedIndexExtension<String, String> {
    @NonNls
    public static final ID<String, String> KEY = ID.create((String)"i18n.yaml.translation");

    public int getVersion() {
        return 4;
    }

    @NotNull
    public DataIndexer<String, String, FileContent> getIndexer() {
        return new DataIndexer<String, String, FileContent>(){

            @NotNull
            public Map<String, String> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                int truncatedThreshold = Registry.intValue((String)"ruby.index.string.limit", (int)2000);
                HashMap<String, String> map = new HashMap<String, String>();
                I18nYamlIndexUtil.visitYamlI18nLikeKeys(inputData, (key, value) -> {
                    String translation = truncatedThreshold < value.length() ? value : StringUtil.shortenTextWithEllipsis((String)value, (int)truncatedThreshold, (int)20, (String)RBundle.message((String)"i18n.index.truncated.suffix"));
                    map.putIfAbsent((String)key, translation);
                });
                HashMap<String, String> hashMap = map;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/indexes/I18nYAMLTranslationIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/indexes/I18nYAMLTranslationIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            I18nYAMLTranslationIndex.$$$reportNull$$$0(0);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<String> getValueExternalizer() {
        return new DataExternalizer<String>(){

            public void save(@NotNull DataOutput out, String value) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                IOUtil.writeUTF((DataOutput)out, (String)value);
            }

            public String read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    2.$$$reportNull$$$0(1);
                }
                return IOUtil.readUTF((DataInput)in);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/indexes/I18nYAMLTranslationIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public ID<String, String> getName() {
        ID<String, String> iD = KEY;
        if (iD == null) {
            I18nYAMLTranslationIndex.$$$reportNull$$$0(1);
        }
        return iD;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = YamlIndexUtil.EXPLICIT_YAML_FILTER;
        if (inputFilter == null) {
            I18nYAMLTranslationIndex.$$$reportNull$$$0(2);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/i18n/indexes/I18nYAMLTranslationIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

