/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.detector;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.detector.GemDetector;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.yaml.YAMLFileType;

public final class DatabaseGemDetector
implements GemDetector {
    @NonNls
    private static final Pattern ADAPTER_PATTERN;
    @NonNls
    private static final MultiMap<String, String> RUBY_ADAPTER_TO_GEM;
    @NonNls
    private static final MultiMap<String, String> JRUBY_ADAPTER_TO_GEM;

    @NotNull
    public Set<GemDependency> detect(@NotNull Project project, @Nullable Sdk sdk, @Nullable VirtualFile provider) {
        if (project == null) {
            DatabaseGemDetector.$$$reportNull$$$0(0);
        }
        if (sdk == null || provider == null) {
            Set<GemDependency> set = Collections.emptySet();
            if (set == null) {
                DatabaseGemDetector.$$$reportNull$$$0(1);
            }
            return set;
        }
        if (!ContainerUtil.exists((Iterable)((Iterable)RailsPaths.getDefaultPaths().get("config/database")), it -> it.endsWith(provider.getName()))) {
            Set<GemDependency> set = Collections.emptySet();
            if (set == null) {
                DatabaseGemDetector.$$$reportNull$$$0(2);
            }
            return set;
        }
        String contents = (String)ReadAction.compute(() -> {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(provider);
            if (psiFile == null) {
                return null;
            }
            RailsApp app = RailsApp.fromPsiElement((PsiElement)psiFile);
            VirtualFile parent = provider.getParent();
            if (app == null || parent == null || !app.getPaths().findFiles("config").contains(parent)) {
                return null;
            }
            return psiFile.getText();
        });
        if (StringUtil.isEmptyOrSpaces((String)contents)) {
            Set<GemDependency> set = Collections.emptySet();
            if (set == null) {
                DatabaseGemDetector.$$$reportNull$$$0(3);
            }
            return set;
        }
        Matcher matcher = ADAPTER_PATTERN.matcher(contents);
        HashSet<GemDependency> result = new HashSet<GemDependency>();
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)provider, (Project)project);
        while (matcher.find()) {
            String adapterName = matcher.group(1);
            Collection alternatives = JRubySdkUtil.isJRubySDK((Sdk)sdk) ? JRUBY_ADAPTER_TO_GEM.get((Object)adapterName) : RUBY_ADAPTER_TO_GEM.get((Object)adapterName);
            if (alternatives.isEmpty()) continue;
            String dependency = (String)alternatives.iterator().next();
            if (alternatives.size() > 1) {
                for (String dep : alternatives) {
                    if (RubyGemSearchUtil.findGem((Module)module, (Sdk)sdk, (String)dep) == null) continue;
                    dependency = dep;
                    break;
                }
            }
            result.add(GemDependency.any((String)dependency));
        }
        HashSet<GemDependency> hashSet = result;
        if (hashSet == null) {
            DatabaseGemDetector.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    public boolean accepts(@NotNull VirtualFile providerCandidate) {
        if (providerCandidate == null) {
            DatabaseGemDetector.$$$reportNull$$$0(5);
        }
        return FileTypeRegistry.getInstance().isFileOfType(providerCandidate, (FileType)YAMLFileType.YML);
    }

    static {
        String[] keyArray;
        ADAPTER_PATTERN = Pattern.compile("^\\s*adapter:\\s*(\\S*)\\s*$", 8);
        RUBY_ADAPTER_TO_GEM = MultiMap.createSet();
        RUBY_ADAPTER_TO_GEM.putValue((Object)"sqlite", (Object)"sqlite-ruby");
        RUBY_ADAPTER_TO_GEM.putValue((Object)"sqlite3", (Object)"sqlite3-ruby");
        RUBY_ADAPTER_TO_GEM.putValues((Object)"postgresql", Arrays.asList("pg", "postgres", "postgres-pr"));
        RUBY_ADAPTER_TO_GEM.putValue((Object)"mysql", (Object)"mysql");
        RUBY_ADAPTER_TO_GEM.putValue((Object)"amalgalite", (Object)"activerecord-amalgalite-adapter");
        RUBY_ADAPTER_TO_GEM.putValue((Object)"dbslayer", (Object)"activerecord-dbslayer-adapter");
        RUBY_ADAPTER_TO_GEM.putValue((Object)"interbase", (Object)"activerecord-interbase-adapter");
        RUBY_ADAPTER_TO_GEM.putValue((Object)"odbc", (Object)"activerecord-odbc-adapter");
        RUBY_ADAPTER_TO_GEM.putValue((Object)"sqlanywhere", (Object)"activerecord-sqlanywhere-adapter");
        RUBY_ADAPTER_TO_GEM.putValue((Object)"firebird", (Object)"activerecord-firebird-adapter");
        RUBY_ADAPTER_TO_GEM.putValue((Object)"frontbase", (Object)"activerecord-frontbase-adapter");
        RUBY_ADAPTER_TO_GEM.putValue((Object)"informix", (Object)"activerecord-informix-adapter");
        RUBY_ADAPTER_TO_GEM.putValue((Object)"openbase", (Object)"activerecord-openbase-adapter");
        RUBY_ADAPTER_TO_GEM.putValue((Object)"oracle", (Object)"activerecord-oracle-adapter");
        RUBY_ADAPTER_TO_GEM.putValue((Object)"sqlserver", (Object)"activerecord-sqlserver-adapter");
        RUBY_ADAPTER_TO_GEM.putValue((Object)"sybase", (Object)"activerecord-sybase-adapter");
        JRUBY_ADAPTER_TO_GEM = MultiMap.createSet();
        JRUBY_ADAPTER_TO_GEM.putValue((Object)"sqlite", (Object)"activerecord-jdbcsqlite3-adapter");
        JRUBY_ADAPTER_TO_GEM.putValue((Object)"sqlite3", (Object)"activerecord-jdbcsqlite3-adapter");
        JRUBY_ADAPTER_TO_GEM.putValue((Object)"postgresql", (Object)"activerecord-jdbcpostresql-adapter");
        JRUBY_ADAPTER_TO_GEM.putValue((Object)"mysql", (Object)"activerecord-jdbcmysql-adapter");
        JRUBY_ADAPTER_TO_GEM.putValue((Object)"oracle", (Object)"activerecord-jdbcoracle-adapter");
        JRUBY_ADAPTER_TO_GEM.putValue((Object)"derby", (Object)"activerecord-jdbcderby-adapter");
        JRUBY_ADAPTER_TO_GEM.putValue((Object)"h2", (Object)"activerecord-jdbch2-adapter");
        JRUBY_ADAPTER_TO_GEM.putValue((Object)"hsqldb", (Object)"activerecord-jdbchsqldb-adapter");
        Set keys = JRUBY_ADAPTER_TO_GEM.keySet();
        for (String key : keyArray = ArrayUtilRt.toStringArray((Collection)keys)) {
            JRUBY_ADAPTER_TO_GEM.putValues((Object)("jdbc" + key), JRUBY_ADAPTER_TO_GEM.get((Object)key));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/detector/DatabaseGemDetector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerCandidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/detector/DatabaseGemDetector";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

