/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinExamplesBlock;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCell;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinStepsHolderBase;

public class GherkinScenarioOutlineImpl
extends GherkinStepsHolderBase
implements GherkinScenarioOutline {
    private static final TokenSet EXAMPLES_BLOCK_FILTER = TokenSet.create((IElementType[])new IElementType[]{GherkinElementTypes.EXAMPLES_BLOCK});

    public GherkinScenarioOutlineImpl(@NotNull ASTNode node) {
        if (node == null) {
            GherkinScenarioOutlineImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public String toString() {
        return "GherkinScenarioOutline:" + this.getElementText();
    }

    @Override
    protected String getPresentableText() {
        return this.buildPresentableText("Scenario Outline");
    }

    @Override
    protected void acceptGherkin(GherkinElementVisitor gherkinElementVisitor) {
        gherkinElementVisitor.visitScenarioOutline(this);
    }

    @Override
    @NotNull
    public List<GherkinExamplesBlock> getExamplesBlocks() {
        ASTNode[] nodes;
        ArrayList<GherkinExamplesBlock> result = new ArrayList<GherkinExamplesBlock>();
        for (ASTNode node : nodes = this.getNode().getChildren(EXAMPLES_BLOCK_FILTER)) {
            result.add((GherkinExamplesBlock)node.getPsi());
        }
        ArrayList<GherkinExamplesBlock> arrayList = result;
        if (arrayList == null) {
            GherkinScenarioOutlineImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public Map<String, String> getOutlineTableMap() {
        return (Map)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(GherkinScenarioOutlineImpl.buildOutlineTableMap(this), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Override
    public List<String> getParamsSubstitutions() {
        String text = this.getScenarioName();
        if (StringUtil.isEmpty((String)text)) {
            return Collections.emptyList();
        }
        ArrayList<String> substitutions = new ArrayList<String>();
        CucumberUtil.addSubstitutionFromText(text, substitutions);
        return substitutions;
    }

    @Nullable
    private static Map<String, String> buildOutlineTableMap(@Nullable GherkinScenarioOutline scenarioOutline) {
        if (scenarioOutline == null) {
            return null;
        }
        List<GherkinExamplesBlock> examplesBlocks = scenarioOutline.getExamplesBlocks();
        for (GherkinExamplesBlock examplesBlock : examplesBlocks) {
            GherkinTable table = examplesBlock.getTable();
            if (table == null || table.getHeaderRow() == null || table.getDataRows().isEmpty()) continue;
            List<GherkinTableCell> headerCells = table.getHeaderRow().getPsiCells();
            List<GherkinTableCell> dataCells = table.getDataRows().get(0).getPsiCells();
            HashMap<String, String> result = new HashMap<String, String>();
            for (int i = 0; i < headerCells.size() && i < dataCells.size(); ++i) {
                result.put(headerCells.get(i).getText().trim(), dataCells.get(i).getText().trim());
            }
            return result;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/psi/impl/GherkinScenarioOutlineImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/psi/impl/GherkinScenarioOutlineImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExamplesBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

