/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.javascript.rails.stimulus;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.ruby.javascript.rails.stimulus.StimulusControllerUtil;
import com.intellij.ruby.javascript.rails.stimulus.StimulusReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.PsiReferenceWithCompletion;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.baseString.RDStringLiteralImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.baseString.RStringLiteralImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.util.StreamUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class StimulusReferenceProvider
extends PsiReferenceProvider {
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        RStringLiteral stringLiteral;
        if (element == null) {
            StimulusReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            StimulusReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((stringLiteral = (RStringLiteral)element).hasExpressionSubstitutions() || !(stringLiteral instanceof RStringLiteralImpl) && !(stringLiteral instanceof RDStringLiteralImpl)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                StimulusReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        return element.getParent() instanceof RAssocKey || element.getParent() instanceof RAssocList ? StimulusReferenceProvider.getValueReferences(stringLiteral) : StimulusReferenceProvider.getActionOrTargetReferences(stringLiteral);
    }

    private static PsiReference @NotNull [] getActionOrTargetReferences(@NotNull RStringLiteral stringLiteral) {
        RAssoc assoc;
        PsiElement psiElement;
        boolean hasTarget;
        RAssoc assoc2;
        PsiElement psiElement2;
        Module module;
        if (stringLiteral == null) {
            StimulusReferenceProvider.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)stringLiteral)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                StimulusReferenceProvider.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String elementText = stringLiteral.getText();
        boolean hasAction = elementText.contains("#") && (psiElement2 = stringLiteral.getParent()) instanceof RAssoc && (assoc2 = (RAssoc)psiElement2).getKeyText().equals("action");
        boolean bl = hasTarget = elementText.contains(".") && (psiElement = stringLiteral.getParent()) instanceof RAssoc && (assoc = (RAssoc)psiElement).getKeyText().equals("target");
        int controllerNameRangeEnd = hasAction ? elementText.indexOf("#") : (hasTarget ? elementText.indexOf(".") : elementText.length() - 1);
        TextRange controllerNameRange = TextRange.create((int)1, (int)controllerNameRangeEnd);
        String controllerName = NamingConventions.toUnderscoreCase((String)controllerNameRange.substring(elementText));
        MyControllerReference controllerReference = new MyControllerReference((PsiElement)stringLiteral, (PsiElement)stringLiteral, controllerNameRange, controllerName);
        if (!hasAction && !hasTarget) {
            PsiReference[] psiReferenceArray = new PsiReference[]{controllerReference};
            if (psiReferenceArray == null) {
                StimulusReferenceProvider.$$$reportNull$$$0(5);
            }
            return psiReferenceArray;
        }
        TextRange actionOrTargetRange = TextRange.create((int)(controllerNameRangeEnd + 1), (int)(elementText.length() - 1));
        StimulusReference actionOrTargetReference = hasAction ? new MyControllerActionReference((PsiElement)stringLiteral, (PsiElement)stringLiteral, Objects.requireNonNull(actionOrTargetRange), controllerName) : new MyControllerTargetReference((PsiElement)stringLiteral, (PsiElement)stringLiteral, Objects.requireNonNull(actionOrTargetRange), controllerName);
        PsiReference[] psiReferenceArray = new PsiReference[]{controllerReference, actionOrTargetReference};
        if (psiReferenceArray == null) {
            StimulusReferenceProvider.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    private static PsiReference @NotNull [] getValueReferences(@NotNull RStringLiteral stringLiteral) {
        TextRange valueNameRange;
        Module module;
        if (stringLiteral == null) {
            StimulusReferenceProvider.$$$reportNull$$$0(7);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)stringLiteral)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                StimulusReferenceProvider.$$$reportNull$$$0(8);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String elementText = stringLiteral.getText();
        int controllerNameRangeEnd = -1;
        int i = elementText.indexOf(45);
        while (i > 0) {
            String current = NamingConventions.toUnderscoreCase((String)elementText.substring(1, i));
            if (!ContainerUtil.filter(StimulusControllerUtil.getControllerNames(module, stringLiteral.getResolveScope()), it -> it.equals(current)).isEmpty()) {
                controllerNameRangeEnd = i;
                break;
            }
            i = elementText.indexOf(45, i + 1);
        }
        if (controllerNameRangeEnd == -1) {
            controllerNameRangeEnd = elementText.length() - 1;
        }
        TextRange controllerNameRange = TextRange.create((int)1, (int)controllerNameRangeEnd);
        String controllerName = NamingConventions.toUnderscoreCase((String)controllerNameRange.substring(elementText));
        MyControllerReference controllerReference = new MyControllerReference((PsiElement)stringLiteral, (PsiElement)stringLiteral, controllerNameRange, controllerName);
        int valueNameRangeEnd = elementText.lastIndexOf("-value");
        if (valueNameRangeEnd > 0 && valueNameRangeEnd < controllerNameRangeEnd) {
            if (PsiReference.EMPTY_ARRAY == null) {
                StimulusReferenceProvider.$$$reportNull$$$0(9);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (controllerNameRangeEnd == elementText.length() - 1 && valueNameRangeEnd == -1 || controllerNameRangeEnd == valueNameRangeEnd || valueNameRangeEnd != -1 && valueNameRangeEnd + 6 != elementText.length() - 1) {
            PsiReference[] psiReferenceArray = new PsiReference[]{controllerReference};
            if (psiReferenceArray == null) {
                StimulusReferenceProvider.$$$reportNull$$$0(10);
            }
            return psiReferenceArray;
        }
        if (valueNameRangeEnd < 0) {
            valueNameRangeEnd = elementText.length() - 1;
        }
        if ((valueNameRange = TextRange.create((int)(controllerNameRangeEnd + 1), (int)valueNameRangeEnd)).isEmpty()) {
            PsiReference[] psiReferenceArray = new PsiReference[]{controllerReference};
            if (psiReferenceArray == null) {
                StimulusReferenceProvider.$$$reportNull$$$0(11);
            }
            return psiReferenceArray;
        }
        MyControllerValueReference controllerValueReference = new MyControllerValueReference((PsiElement)stringLiteral, (PsiElement)stringLiteral, valueNameRange, controllerName);
        PsiReference[] psiReferenceArray = new PsiReference[]{controllerReference, controllerValueReference};
        if (psiReferenceArray == null) {
            StimulusReferenceProvider.$$$reportNull$$$0(12);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ruby/javascript/rails/stimulus/StimulusReferenceProvider";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ruby/javascript/rails/stimulus/StimulusReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionOrTargetReferences";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActionOrTargetReferences";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getValueReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    private static class MyControllerReference
    extends StimulusReference
    implements PsiReferenceWithCompletion {
        private final TextRange myRange;
        private final String myController;

        MyControllerReference(@NotNull PsiElement referenceElement, @NotNull PsiElement stringOrSymbol, @NotNull TextRange range, @NotNull String controller) {
            if (referenceElement == null) {
                MyControllerReference.$$$reportNull$$$0(0);
            }
            if (stringOrSymbol == null) {
                MyControllerReference.$$$reportNull$$$0(1);
            }
            if (range == null) {
                MyControllerReference.$$$reportNull$$$0(2);
            }
            if (controller == null) {
                MyControllerReference.$$$reportNull$$$0(3);
            }
            super(referenceElement, stringOrSymbol);
            this.myRange = range;
            this.myController = controller;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                MyControllerReference.$$$reportNull$$$0(4);
            }
            return textRange;
        }

        protected ResolveResult @NotNull [] multiResolveInner(boolean incompleteCode) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
            if (module == null) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    MyControllerReference.$$$reportNull$$$0(5);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            ResolveResult[] resolveResultArray = StimulusControllerUtil.getControllerClassByName(this.myController, module, this.myElement.getResolveScope()).stream().map(PsiElement::getContainingFile).map(PsiElementResolveResult::new).toList().toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                MyControllerReference.$$$reportNull$$$0(6);
            }
            return resolveResultArray;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myRange.substring(this.myElement.getText());
            if (string == null) {
                MyControllerReference.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Nullable
        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            String controllerName;
            if (newElementName == null) {
                MyControllerReference.$$$reportNull$$$0(8);
            }
            if ((controllerName = StimulusControllerUtil.getControllerNameFromFile(newElementName)) == null) {
                return null;
            }
            String newElementText = "\"" + controllerName + this.myElement.getText().substring(this.getRangeInElement().getEndOffset());
            RPsiElement newElement = RubyElementFactoryCore.createElementFromText((PsiElement)this.myElement, (String)newElementText);
            this.myElement.replace((PsiElement)newElement);
            return newElement;
        }

        public void addCompletions(@NotNull CompletionParameters parameters, @Nullable ProcessingContext context, @NotNull CompletionResultSet result) {
            Module module;
            if (parameters == null) {
                MyControllerReference.$$$reportNull$$$0(9);
            }
            if (result == null) {
                MyControllerReference.$$$reportNull$$$0(10);
            }
            if ((module = ModuleUtilCore.findModuleForFile((PsiFile)parameters.getOriginalFile())) == null) {
                return;
            }
            StimulusControllerUtil.getControllerNames(module, this.myElement.getResolveScope()).stream().map(NamingConventions::toUnderscoreCase).map(name -> LookupElementBuilder.create((String)name).withIcon(AllIcons.Nodes.Class)).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringOrSymbol";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controller";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ruby/javascript/rails/stimulus/StimulusReferenceProvider$MyControllerReference";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ruby/javascript/rails/stimulus/StimulusReferenceProvider$MyControllerReference";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolveInner";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyControllerActionReference
    extends StimulusReference
    implements PsiReferenceWithCompletion {
        private final TextRange myRange;
        private final String myController;

        MyControllerActionReference(@NotNull PsiElement referenceElement, @NotNull PsiElement stringOrSymbol, @NotNull TextRange range, @NotNull String controller) {
            if (referenceElement == null) {
                MyControllerActionReference.$$$reportNull$$$0(0);
            }
            if (stringOrSymbol == null) {
                MyControllerActionReference.$$$reportNull$$$0(1);
            }
            if (range == null) {
                MyControllerActionReference.$$$reportNull$$$0(2);
            }
            if (controller == null) {
                MyControllerActionReference.$$$reportNull$$$0(3);
            }
            super(referenceElement, stringOrSymbol);
            this.myRange = range;
            this.myController = controller;
        }

        protected ResolveResult @NotNull [] multiResolveInner(boolean incompleteCode) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
            if (module == null) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    MyControllerActionReference.$$$reportNull$$$0(4);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            ResolveResult[] resolveResultArray = StimulusControllerUtil.getControllerClassByName(this.myController, module, this.myElement.getResolveScope()).stream().map(controller -> controller.findFunctionByName(this.getCanonicalText())).filter(Objects::nonNull).map(PsiElementResolveResult::new).toList().toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                MyControllerActionReference.$$$reportNull$$$0(5);
            }
            return resolveResultArray;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myRange.substring(this.myElement.getText());
            if (string == null) {
                MyControllerActionReference.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                MyControllerActionReference.$$$reportNull$$$0(7);
            }
            return textRange;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                MyControllerActionReference.$$$reportNull$$$0(8);
            }
            String newElementNext = StringUtil.wrapWithDoubleQuote((String)(this.myController + "#" + newElementName));
            RPsiElement newElement = RubyElementFactoryCore.createElementFromText((PsiElement)this.myElement, (String)newElementNext);
            this.myElement.replace((PsiElement)newElement);
            return newElement;
        }

        public void addCompletions(@NotNull CompletionParameters parameters, @Nullable ProcessingContext context, @NotNull CompletionResultSet result) {
            Module module;
            if (parameters == null) {
                MyControllerActionReference.$$$reportNull$$$0(9);
            }
            if (result == null) {
                MyControllerActionReference.$$$reportNull$$$0(10);
            }
            if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement)) == null) {
                return;
            }
            StimulusControllerUtil.getControllerClassByName(this.myController, module, this.myElement.getResolveScope()).stream().flatMap(controller -> Arrays.stream(controller.getFunctions())).map(NavigationItem::getName).filter(Objects::nonNull).map(func -> LookupElementBuilder.create((String)func).withTypeText(this.myController).withIcon(RubyIcons.Rails.ActionMethod)).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringOrSymbol";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controller";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ruby/javascript/rails/stimulus/StimulusReferenceProvider$MyControllerActionReference";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ruby/javascript/rails/stimulus/StimulusReferenceProvider$MyControllerActionReference";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolveInner";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyControllerTargetReference
    extends StimulusReference
    implements PsiReferenceWithCompletion {
        private final TextRange myRange;
        private final String myController;

        MyControllerTargetReference(@NotNull PsiElement referenceElement, @NotNull PsiElement stringOrSymbol, @NotNull TextRange range, @NotNull String controller) {
            if (referenceElement == null) {
                MyControllerTargetReference.$$$reportNull$$$0(0);
            }
            if (stringOrSymbol == null) {
                MyControllerTargetReference.$$$reportNull$$$0(1);
            }
            if (range == null) {
                MyControllerTargetReference.$$$reportNull$$$0(2);
            }
            if (controller == null) {
                MyControllerTargetReference.$$$reportNull$$$0(3);
            }
            super(referenceElement, stringOrSymbol);
            this.myRange = range;
            this.myController = controller;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                MyControllerTargetReference.$$$reportNull$$$0(4);
            }
            return textRange;
        }

        protected ResolveResult @NotNull [] multiResolveInner(boolean incompleteCode) {
            ResolveResult[] resolveResultArray = this.getTargetsArrays().stream().flatMap(JSArrayLiteralExpression::getExpressionStream).mapMulti(StreamUtil.select(JSLiteralExpression.class, (Class[])new Class[0])).filter(expr -> this.getCanonicalText().equals(expr.getStringValue())).map(PsiElementResolveResult::new).toList().toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                MyControllerTargetReference.$$$reportNull$$$0(5);
            }
            return resolveResultArray;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myRange.substring(this.myElement.getText());
            if (string == null) {
                MyControllerTargetReference.$$$reportNull$$$0(6);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                MyControllerTargetReference.$$$reportNull$$$0(7);
            }
            String newElementNext = StringUtil.wrapWithDoubleQuote((String)(this.myController + "." + StimulusControllerUtil.dasherize(newElementName)));
            RPsiElement newElement = RubyElementFactoryCore.createElementFromText((PsiElement)this.myElement, (String)newElementNext);
            this.myElement.replace((PsiElement)newElement);
            return newElement;
        }

        public void addCompletions(@NotNull CompletionParameters parameters, @Nullable ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                MyControllerTargetReference.$$$reportNull$$$0(8);
            }
            if (result == null) {
                MyControllerTargetReference.$$$reportNull$$$0(9);
            }
            this.getTargetsArrays().stream().flatMap(JSArrayLiteralExpression::getExpressionStream).mapMulti(StreamUtil.select(JSLiteralExpression.class, (Class[])new Class[0])).map(JSLiteralExpression::getStringValue).filter(Objects::nonNull).map(target -> LookupElementBuilder.create((String)target).withTypeText(this.myController).withIcon(AllIcons.Nodes.Field)).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
        }

        @NotNull
        private List<JSArrayLiteralExpression> getTargetsArrays() {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
            if (module == null) {
                List<JSArrayLiteralExpression> list = Collections.emptyList();
                if (list == null) {
                    MyControllerTargetReference.$$$reportNull$$$0(10);
                }
                return list;
            }
            List<JSArrayLiteralExpression> list = StimulusControllerUtil.getControllerClassByName(this.myController, module, this.myElement.getResolveScope()).stream().map(controller -> controller.findFieldByName("targets")).filter(Objects::nonNull).filter(it -> it.hasModifier(JSAttributeList.ModifierType.STATIC)).map(JSField::getInitializer).mapMulti(StreamUtil.select(JSArrayLiteralExpression.class, (Class[])new Class[0])).toList();
            if (list == null) {
                MyControllerTargetReference.$$$reportNull$$$0(11);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringOrSymbol";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controller";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ruby/javascript/rails/stimulus/StimulusReferenceProvider$MyControllerTargetReference";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ruby/javascript/rails/stimulus/StimulusReferenceProvider$MyControllerTargetReference";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolveInner";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetsArrays";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 11: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 10, 11 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyControllerValueReference
    extends StimulusReference
    implements PsiReferenceWithCompletion {
        private final TextRange myRange;
        private final String myController;

        private MyControllerValueReference(@NotNull PsiElement referenceElement, @NotNull PsiElement stringOrSymbol, @NotNull TextRange range, @NotNull String controller) {
            if (referenceElement == null) {
                MyControllerValueReference.$$$reportNull$$$0(0);
            }
            if (stringOrSymbol == null) {
                MyControllerValueReference.$$$reportNull$$$0(1);
            }
            if (range == null) {
                MyControllerValueReference.$$$reportNull$$$0(2);
            }
            if (controller == null) {
                MyControllerValueReference.$$$reportNull$$$0(3);
            }
            super(referenceElement, stringOrSymbol);
            this.myRange = range;
            this.myController = controller;
        }

        protected ResolveResult @NotNull [] multiResolveInner(boolean incompleteCode) {
            String valueName = StimulusControllerUtil.camelizeValueName(this.getCanonicalText());
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
            if (module == null) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    MyControllerValueReference.$$$reportNull$$$0(4);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            ResolveResult[] resolveResultArray = StimulusControllerUtil.getControllerValuesObjects(this.myController, module, this.myElement.getResolveScope()).stream().flatMap(it -> Arrays.stream(it.getProperties())).filter(it -> valueName.equals(it.getName())).map(PsiElementResolveResult::new).toList().toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                MyControllerValueReference.$$$reportNull$$$0(5);
            }
            return resolveResultArray;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                MyControllerValueReference.$$$reportNull$$$0(6);
            }
            return textRange;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myRange.substring(this.myElement.getText());
            if (string == null) {
                MyControllerValueReference.$$$reportNull$$$0(7);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                MyControllerValueReference.$$$reportNull$$$0(8);
            }
            String newValueName = StimulusControllerUtil.dasherize(newElementName);
            String newElementText = this.myElement.getText().substring(0, this.getRangeInElement().getStartOffset()) + newValueName + this.myElement.getText().substring(this.getRangeInElement().getEndOffset());
            RPsiElement newElement = RubyElementFactoryCore.createElementFromText((PsiElement)this.myElement, (String)newElementText);
            this.myElement.replace((PsiElement)newElement);
            return newElement;
        }

        public void addCompletions(@NotNull CompletionParameters parameters, @Nullable ProcessingContext context, @NotNull CompletionResultSet result) {
            Module module;
            if (parameters == null) {
                MyControllerValueReference.$$$reportNull$$$0(9);
            }
            if (result == null) {
                MyControllerValueReference.$$$reportNull$$$0(10);
            }
            if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement)) == null) {
                return;
            }
            StimulusControllerUtil.getControllerValuesObjects(this.myController, module, this.myElement.getResolveScope()).stream().flatMap(it -> Arrays.stream(it.getProperties())).map(NavigationItem::getName).filter(Objects::nonNull).map(StimulusControllerUtil::dasherize).map(name -> LookupElementBuilder.create((String)name).withTypeText(this.myController).withIcon(AllIcons.Nodes.Property).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                    if (context == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (item == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    TextRange suffixRange = TextRange.create((int)context.getTailOffset(), (int)(context.getTailOffset() + 6));
                    Document document = context.getDocument();
                    if (suffixRange.getEndOffset() >= document.getTextLength() || !document.getText(suffixRange).equals("-value")) {
                        context.getDocument().insertString(context.getTailOffset(), (CharSequence)"-value");
                        context.getEditor().getCaretModel().moveToOffset(context.getTailOffset());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "item";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/ruby/javascript/rails/stimulus/StimulusReferenceProvider$MyControllerValueReference$1";
                    objectArray[2] = "handleInsert";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            })).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringOrSymbol";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controller";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ruby/javascript/rails/stimulus/StimulusReferenceProvider$MyControllerValueReference";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ruby/javascript/rails/stimulus/StimulusReferenceProvider$MyControllerValueReference";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolveInner";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

