/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.javascript.rails.importmap.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.ruby.run.ConsoleRunner;
import org.jetbrains.plugins.ruby.ruby.run.ConsoleRunnerOptions;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public final class RailsImportMapAction
extends AnAction {
    private final String myCommand;
    private final Supplier<@NlsActions.ActionDescription String> myDescriptionSupplier;
    private final String myArguments;

    public RailsImportMapAction(@NotNull @NlsSafe String command, @NotNull Supplier<@NlsActions.ActionDescription String> descriptionSupplier) {
        if (command == null) {
            RailsImportMapAction.$$$reportNull$$$0(0);
        }
        if (descriptionSupplier == null) {
            RailsImportMapAction.$$$reportNull$$$0(1);
        }
        this(command, descriptionSupplier, "");
    }

    private RailsImportMapAction(@NotNull @NlsSafe String command, @NotNull Supplier<@NlsActions.ActionDescription String> descriptionSupplier, @NotNull String arguments) {
        if (command == null) {
            RailsImportMapAction.$$$reportNull$$$0(2);
        }
        if (descriptionSupplier == null) {
            RailsImportMapAction.$$$reportNull$$$0(3);
        }
        if (arguments == null) {
            RailsImportMapAction.$$$reportNull$$$0(4);
        }
        super(() -> command, descriptionSupplier, RubyIcons.Ruby.Ruby);
        this.myCommand = command;
        this.myDescriptionSupplier = descriptionSupplier;
        this.myArguments = arguments;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            RailsImportMapAction.$$$reportNull$$$0(5);
        }
        if ((project = event.getProject()) == null) {
            return;
        }
        Module module = (Module)event.getData(PlatformCoreDataKeys.MODULE);
        if (module == null) {
            return;
        }
        Sdk sdk = Objects.requireNonNull(RubySdkUtil.findRubySdk((Project)project));
        String interpreter = RubySdkAdditionalData.getInterpreterPathFor((Sdk)sdk);
        String[] commands = "%s ./bin/%s %s".formatted(interpreter, this.myCommand, this.myArguments).split(" +");
        MergingCommandLineArgumentsProvider provider = new MergingCommandLineArgumentsProvider(commands, null, null, null);
        @NlsSafe String title = "%s %s".formatted(this.myCommand, this.myArguments).trim();
        VirtualFile workingDir = (VirtualFile)ObjectUtils.doIfNotNull((Object)BundlerUtil.getGemfile((Module)module), VirtualFile::getParent);
        if (workingDir == null) {
            workingDir = (VirtualFile)ContainerUtil.getFirstItem(List.of(ModuleRootManager.getInstance((Module)module).getContentRoots()));
        }
        ConsoleRunnerOptions options = new ConsoleRunnerOptions.ConsoleRunnerOptionsBuilder().withProject(project).withTitle(title).withWorkingDirectory(workingDir != null ? VfsUtilCore.urlToPath((String)workingDir.getUrl()) : null).build();
        ConsoleRunner.run((ConsoleRunnerOptions)options, (RubyCommandLineArgumentsProvider)provider, (Sdk)sdk);
    }

    @NotNull
    public String getCommand() {
        String string = this.myCommand;
        if (string == null) {
            RailsImportMapAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public RailsImportMapAction withArguments(@NotNull String arguments) {
        if (arguments == null) {
            RailsImportMapAction.$$$reportNull$$$0(7);
        }
        if (arguments.isBlank()) {
            RailsImportMapAction railsImportMapAction = this;
            if (railsImportMapAction == null) {
                RailsImportMapAction.$$$reportNull$$$0(8);
            }
            return railsImportMapAction;
        }
        return new RailsImportMapAction(this.myCommand, this.myDescriptionSupplier, arguments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionSupplier";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ruby/javascript/rails/importmap/actions/RailsImportMapAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ruby/javascript/rails/importmap/actions/RailsImportMapAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8 -> new IllegalStateException(string);
        };
    }
}

