/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSingle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0006J\u0006\u0010\u0019\u001a\u00020\u0006J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0016J\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u0006J\u001e\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkSBIT;", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkSingle;", "info", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "alphasb", "", "bluesb", "cLen", "getCLen", "()I", "graysb", "greensb", "orderingConstraint", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "getOrderingConstraint", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "rGB", "", "getRGB", "()[I", "redsb", "createRawChunk", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "getAlphasb", "getGraysb", "parseFromRaw", "", "chunk", "setAlphasb", "a", "setGraysb", "gray", "setRGB", "r", "g", "b", "Companion", "plot-api"})
public final class PngChunkSBIT
extends PngChunkSingle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int graysb;
    private int alphasb;
    private int redsb;
    private int greensb;
    private int bluesb;
    @NotNull
    public static final String ID = "sBIT";

    public PngChunkSBIT(@Nullable ImageInfo info) {
        super(ID, info);
    }

    @Override
    @NotNull
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_PLTE_AND_IDAT;
    }

    private final int getCLen() {
        int len;
        int n = len = this.getImgInfo().getGreyscale() ? 1 : 3;
        if (this.getImgInfo().getAlpha()) {
            ++len;
        }
        return len;
    }

    @Override
    public void parseFromRaw(@NotNull ChunkRaw chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        if (chunk.getLen() != this.getCLen()) {
            throw new PngjException("bad chunk length " + chunk);
        }
        if (this.getImgInfo().getGreyscale()) {
            this.graysb = PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), 0);
            if (this.getImgInfo().getAlpha()) {
                this.alphasb = PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), 1);
            }
        } else {
            this.redsb = PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), 0);
            this.greensb = PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), 1);
            this.bluesb = PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), 2);
            if (this.getImgInfo().getAlpha()) {
                this.alphasb = PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), 3);
            }
        }
    }

    @Override
    @NotNull
    public ChunkRaw createRawChunk() {
        ChunkRaw c = this.createEmptyChunk(this.getCLen(), true);
        if (this.getImgInfo().getGreyscale()) {
            byte[] byArray = c.getData();
            Intrinsics.checkNotNull((Object)byArray);
            byArray[0] = (byte)this.graysb;
            if (this.getImgInfo().getAlpha()) {
                byte[] byArray2 = c.getData();
                Intrinsics.checkNotNull((Object)byArray2);
                byArray2[1] = (byte)this.alphasb;
            }
        } else {
            byte[] byArray = c.getData();
            Intrinsics.checkNotNull((Object)byArray);
            byArray[0] = (byte)this.redsb;
            byte[] byArray3 = c.getData();
            Intrinsics.checkNotNull((Object)byArray3);
            byArray3[1] = (byte)this.greensb;
            byte[] byArray4 = c.getData();
            Intrinsics.checkNotNull((Object)byArray4);
            byArray4[2] = (byte)this.bluesb;
            if (this.getImgInfo().getAlpha()) {
                byte[] byArray5 = c.getData();
                Intrinsics.checkNotNull((Object)byArray5);
                byArray5[3] = (byte)this.alphasb;
            }
        }
        return c;
    }

    public final void setGraysb(int gray) {
        if (!this.getImgInfo().getGreyscale()) {
            throw new PngjException("only greyscale images support this");
        }
        this.graysb = gray;
    }

    public final int getGraysb() {
        if (!this.getImgInfo().getGreyscale()) {
            throw new PngjException("only greyscale images support this");
        }
        return this.graysb;
    }

    public final void setAlphasb(int a2) {
        if (!this.getImgInfo().getAlpha()) {
            throw new PngjException("only images with alpha support this");
        }
        this.alphasb = a2;
    }

    public final int getAlphasb() {
        if (!this.getImgInfo().getAlpha()) {
            throw new PngjException("only images with alpha support this");
        }
        return this.alphasb;
    }

    public final void setRGB(int r, int g, int b2) {
        if (this.getImgInfo().getGreyscale() || this.getImgInfo().getIndexed()) {
            throw new PngjException("only rgb or rgba images support this");
        }
        this.redsb = r;
        this.greensb = g;
        this.bluesb = b2;
    }

    @NotNull
    public final int[] getRGB() {
        if (this.getImgInfo().getGreyscale() || this.getImgInfo().getIndexed()) {
            throw new PngjException("only rgb or rgba images support this");
        }
        int[] nArray = new int[]{this.redsb, this.greensb, this.bluesb};
        return nArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkSBIT$Companion;", "", "()V", "ID", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

