/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.copyright;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.options.LanguageOptions;
import com.maddyhome.idea.copyright.psi.UpdateCopyright;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightsProvider;
import com.maddyhome.idea.copyright.psi.UpdatePsiFileCopyright;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;

final class RubyUpdateCopyrightsProvider
extends UpdateCopyrightsProvider {
    RubyUpdateCopyrightsProvider() {
    }

    public UpdateCopyright createInstance(Project project, Module module, VirtualFile file, FileType base, CopyrightProfile options) {
        return new UpdatePsiFileCopyright(project, module, file, options){

            protected boolean accept() {
                return this.getFile() instanceof RFile;
            }

            @Nullable
            protected PsiElement getPreviousSibling(@Nullable PsiElement element) {
                return element != null ? PsiTreeUtil.prevLeaf((PsiElement)element) : null;
            }

            protected void scanFile() {
                List comments = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)this.getFile()).withTraversal(TreeTraversal.LEAVES_DFS)).traverse().takeWhile(Conditions.instanceOf((Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class})).filter(PsiComment.class).toList();
                PsiElement anchor = comments.isEmpty() ? PsiTreeUtil.getDeepestFirst((PsiElement)this.getFile()) : Optional.ofNullable((PsiComment)ContainerUtil.getLastItem((List)comments)).map(PsiTreeUtil::nextVisibleLeaf).orElseGet(() -> PsiTreeUtil.getDeepestLast((PsiElement)this.getFile()));
                int index = ContainerUtil.lastIndexOf((List)comments, RubyPsiUtilCore::isPragmaComment);
                this.checkComments(anchor, true, comments.subList(index + 1, comments.size()));
            }
        };
    }

    @NotNull
    public LanguageOptions getDefaultOptions() {
        LanguageOptions options = new LanguageOptions();
        options.setBlock(false);
        options.setFileTypeOverride(3);
        options.setPrefixLines(false);
        LanguageOptions languageOptions = options;
        if (languageOptions == null) {
            RubyUpdateCopyrightsProvider.$$$reportNull$$$0(0);
        }
        return languageOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/copyright/RubyUpdateCopyrightsProvider", "getDefaultOptions"));
    }
}

