/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.wsl.remote.ruby;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.wsl.remote.ruby.RubyWslProgressUtilKt;
import com.intellij.wsl.remote.ruby.RubyWslSocketProxyManager;
import com.intellij.wsl.remoteSdk.WSLCredentialsHolder;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.remote.impl.RubyRemoteRunner;
import org.jetbrains.plugins.ruby.remote.impl.RubySshRemoteTransfer;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.ProjectAwareRubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;

public final class RubyWSLRunner
extends RubyLocalRunner
implements ProjectAwareRubyRunner {
    private static final Logger LOG = Logger.getInstance(RubyWSLRunner.class);
    @Nullable
    private Project myProject;
    @NotNull
    private final WSLDistribution myDistribution;
    @NotNull
    private final Supplier<Map<String, String>> myParentEnvProvider;
    @NotNull
    private final RubyRemoteSdkAdditionalData myData;

    @NotNull
    public static RubyWSLRunner getRunner(@NotNull RubyRemoteSdkAdditionalData data, @Nullable Module module) {
        if (data == null) {
            RubyWSLRunner.$$$reportNull$$$0(0);
        }
        try {
            WSLCredentialsHolder credentialsHolder = WSLCredentialsHolder.get((RemoteSdkAdditionalData)data);
            WSLDistribution wslDistribution = credentialsHolder.getDistribution();
            return new RubyWSLRunner(data, module, wslDistribution);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    RubyWSLRunner(@NotNull RubyRemoteSdkAdditionalData data, @Nullable Module module, @NotNull WSLDistribution distribution) {
        if (data == null) {
            RubyWSLRunner.$$$reportNull$$$0(1);
        }
        if (distribution == null) {
            RubyWSLRunner.$$$reportNull$$$0(2);
        }
        super(module, data.getSdkSystemAccessor());
        this.myData = data;
        this.myProject = RModuleUtil.getInstance().getProject(module);
        this.myDistribution = distribution;
        this.myParentEnvProvider = new SynchronizedClearableLazy(() -> {
            Map env = this.myDistribution.getEnvironment();
            return env == null ? Collections.emptyMap() : env;
        });
    }

    @NotNull
    protected ProcessHandler createConsoleProcessHandlerInner(@NotNull RubyCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            RubyWSLRunner.$$$reportNull$$$0(3);
        }
        commandLine = this.patchCommandLine(commandLine);
        return this.patchProcessHandler(commandLine, super.createConsoleProcessHandlerInner(commandLine.withBlockingRead(true)));
    }

    @NotNull
    protected ProcessHandler createProcessHandlerInner(@NotNull RubyCommandLine commandLine, @Nullable String runnerId) throws ExecutionException {
        if (commandLine == null) {
            RubyWSLRunner.$$$reportNull$$$0(4);
        }
        RubyCommandLine patchedCommandLine = this.patchCommandLine(commandLine);
        ProcessHandler processHandler = (ProcessHandler)RubyWslProgressUtilKt.computeWithIoJob(() -> super.createProcessHandlerInner(patchedCommandLine.withBlockingRead(true), runnerId));
        return this.patchProcessHandler(patchedCommandLine, processHandler);
    }

    @NotNull
    private ProcessHandler patchProcessHandler(@NotNull RubyCommandLine commandLine, @NotNull ProcessHandler processHandler) {
        RubyCommandLineData commandLineData;
        Integer localPort;
        if (commandLine == null) {
            RubyWSLRunner.$$$reportNull$$$0(5);
        }
        if (processHandler == null) {
            RubyWSLRunner.$$$reportNull$$$0(6);
        }
        Integer n = localPort = (commandLineData = commandLine.getCommandLineData()) == null ? null : (Integer)commandLineData.getCopyableUserData(RubyCommandLineData.DISPATCHER_KEY);
        if (localPort != null) {
            processHandler.addProcessListener(new ProcessListener(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> RubyWslSocketProxyManager.getInstance().killProxy(localPort));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/wsl/remote/ruby/RubyWSLRunner$1", "processTerminated"));
                }
            });
        }
        ProcessHandler processHandler2 = this.myDistribution.patchProcessHandler((GeneralCommandLine)commandLine, processHandler);
        if (processHandler2 == null) {
            RubyWSLRunner.$$$reportNull$$$0(7);
        }
        return processHandler2;
    }

    @NotNull
    private RubyCommandLine patchCommandLine(@NotNull RubyCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            RubyWSLRunner.$$$reportNull$$$0(8);
        }
        File workDirectory = commandLine.getWorkDirectory();
        String remoteWorkingDir = null;
        if (workDirectory != null) {
            String workDirectoryPath = workDirectory.getPath();
            remoteWorkingDir = OSAgnosticPathUtil.isAbsoluteDosPath((String)workDirectoryPath) || WslPath.isWslUncPath((String)workDirectoryPath) ? this.myDistribution.getWslPath(workDirectory.toPath().toAbsolutePath()) : FileUtil.toSystemIndependentName((String)workDirectoryPath);
            commandLine.setWorkDirectory((File)null);
        }
        Map additionalEnvs = commandLine.getEnvironment();
        additionalEnvs.remove("SPRING_TMP_PATH");
        PathMappingSettings mappingSettings = this.addDefaultMappings(null);
        for (Map.Entry entry : additionalEnvs.entrySet()) {
            String currentValue = (String)entry.getValue();
            Object newValue = "PATH".equals(entry.getKey()) ? "$PATH:" + (String)entry.getValue() : this.mapEnvValue(mappingSettings, currentValue);
            entry.setValue(newValue);
        }
        boolean askForSudo = commandLine.isAskForSudo();
        commandLine.setAskForSudo(false);
        if (commandLine.isAllocatePty() && commandLine.getParentEnvironmentType() == GeneralCommandLine.ParentEnvironmentType.NONE) {
            commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        }
        WSLCommandLineOptions wSLCommandLineOptions = new WSLCommandLineOptions().setRemoteWorkingDirectory(remoteWorkingDir).setSudo(askForSudo);
        RubyCommandLine rubyCommandLine = (RubyCommandLine)this.myDistribution.patchCommandLine((GeneralCommandLine)commandLine, this.myProject, wSLCommandLineOptions);
        if (rubyCommandLine == null) {
            RubyWSLRunner.$$$reportNull$$$0(9);
        }
        return rubyCommandLine;
    }

    @NotNull
    private String mapEnvValue(@NotNull PathMappingSettings mappingSettings, @NotNull String currentValue) {
        String wslPath;
        Path path;
        String newValue;
        if (mappingSettings == null) {
            RubyWSLRunner.$$$reportNull$$$0(10);
        }
        if (currentValue == null) {
            RubyWSLRunner.$$$reportNull$$$0(11);
        }
        if (StringUtil.equals((CharSequence)currentValue, (CharSequence)(newValue = mappingSettings.convertToRemote(currentValue))) && (path = NioFiles.toPath((String)currentValue)) != null && (wslPath = this.myDistribution.getWslPath(path)) != null) {
            String string = wslPath;
            if (string == null) {
                RubyWSLRunner.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = newValue;
        if (string == null) {
            RubyWSLRunner.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public void setProject(@Nullable Project project) {
        this.myProject = project;
    }

    @NotNull
    public PathMappingSettings addDefaultMappings(@Nullable PathMappingSettings pathMappings) {
        PathMappingSettings newMappingSettings = RubyRemoteRunner.addDefaultRemoteMappings((PathMappingSettings)pathMappings, (Project)this.myProject, (RubyRemoteSdkAdditionalData)this.myData);
        for (String helperPath : RubySshRemoteTransfer.getHelpersPaths()) {
            String wslPath = this.myDistribution.getWslPath(Path.of(helperPath, new String[0]));
            if (wslPath != null) {
                newMappingSettings.addMapping(helperPath, wslPath);
                continue;
            }
            LOG.warn("Unable to map path: " + helperPath);
        }
        newMappingSettings.addAll(this.myData.getPathMappings());
        PathMappingSettings pathMappingSettings = newMappingSettings;
        if (pathMappingSettings == null) {
            RubyWSLRunner.$$$reportNull$$$0(14);
        }
        return pathMappingSettings;
    }

    protected int @NotNull [] findAvailableRemotePorts(int @NotNull [] localPorts) {
        if (localPorts == null) {
            RubyWSLRunner.$$$reportNull$$$0(15);
        }
        int[] remotePorts = (int[])localPorts.clone();
        remotePorts[1] = RubyWslSocketProxyManager.getInstance().getProxy(this.myDistribution, localPorts[1]).getWslIngressPort();
        if (remotePorts == null) {
            RubyWSLRunner.$$$reportNull$$$0(16);
        }
        return remotePorts;
    }

    @NotNull
    public String toSystemDependentName(@NotNull String path, @NotNull PathMappingSettings pathMappings) {
        if (path == null) {
            RubyWSLRunner.$$$reportNull$$$0(17);
        }
        if (pathMappings == null) {
            RubyWSLRunner.$$$reportNull$$$0(18);
        }
        String string = pathMappings.convertToRemote(path);
        if (string == null) {
            RubyWSLRunner.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public Map<String, String> getParentEnv() {
        Map map = (Map)RubyWslProgressUtilKt.computeWithIoJob(this.myParentEnvProvider::get);
        if (map == null) {
            RubyWSLRunner.$$$reportNull$$$0(20);
        }
        return map;
    }

    @NotNull
    protected String getLinuxShellCommand() {
        return "bash";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 12, 13, 14, 16, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/wsl/remote/ruby/RubyWSLRunner";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingSettings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPorts";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/wsl/remote/ruby/RubyWSLRunner";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "patchProcessHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommandLine";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "mapEnvValue";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addDefaultMappings";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findAvailableRemotePorts";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemDependentName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRunner";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleProcessHandlerInner";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandlerInner";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "patchProcessHandler";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mapEnvValue";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findAvailableRemotePorts";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependentName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 12, 13, 14, 16, 19, 20 -> new IllegalStateException(string);
        };
    }
}

