/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rails.json.kamal;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0002\t\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ruby/rails/json/kamal/KamalJsonSchemaProviderFactory;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaProviderFactory;", "<init>", "()V", "getProviders", "", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "KamalJsonSchemaProvider", "Companion", "intellij.ruby.rails.json"})
public final class KamalJsonSchemaProviderFactory
implements JsonSchemaProviderFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String KAMAL_1 = "1.7.2";
    @NotNull
    private static final String KAMAL_2 = "2.7.0";

    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new JsonSchemaFileProvider[]{new KamalJsonSchemaProvider(project)};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ruby/rails/json/kamal/KamalJsonSchemaProviderFactory$Companion;", "", "<init>", "()V", "KAMAL_1", "", "KAMAL_2", "intellij.ruby.rails.json"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ruby/rails/json/kamal/KamalJsonSchemaProviderFactory$KamalJsonSchemaProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "kamalGemInfo", "Lorg/jetbrains/plugins/ruby/gem/GemInfo;", "getName", "", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "isAvailable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSchemaFile", "intellij.ruby.rails.json"})
    @SourceDebugExtension(value={"SMAP\nKamalJsonSchemaProviderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KamalJsonSchemaProviderFactory.kt\ncom/intellij/ruby/rails/json/kamal/KamalJsonSchemaProviderFactory$KamalJsonSchemaProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
    public static final class KamalJsonSchemaProvider
    implements JsonSchemaFileProvider {
        @NotNull
        private final Project project;
        @Nullable
        private GemInfo kamalGemInfo;

        public KamalJsonSchemaProvider(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public String getName() {
            String string = RBundle.message((String)"kamal.json.schema.provider");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public SchemaType getSchemaType() {
            return SchemaType.embeddedSchema;
        }

        public boolean isAvailable(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            RailsApp railsApp = RailsApp.fromFile((Project)this.project, (VirtualFile)file);
            if (railsApp == null) {
                return false;
            }
            RailsApp app = railsApp;
            List list = app.getPaths().findFiles("config");
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findFiles(...)");
            List configPaths = list;
            boolean isKamalDeployFile = (Intrinsics.areEqual((Object)file.getName(), (Object)"deploy.yml") || Intrinsics.areEqual((Object)file.getName(), (Object)"deploy.yaml")) && configPaths.contains(file.getParent());
            return isKamalDeployFile && (Boolean)ReadAction.compute(() -> KamalJsonSchemaProvider.isAvailable$lambda$0(file, this)) != false;
        }

        @Nullable
        public VirtualFile getSchemaFile() {
            VirtualFile virtualFile;
            Object currentVersion;
            Object object = this.kamalGemInfo;
            if (object == null || (object = object.getVersion()) == null) {
                object = KamalJsonSchemaProviderFactory.KAMAL_2;
            }
            String schemaVersion = VersionComparatorUtil.compare((String)(currentVersion = object), (String)KamalJsonSchemaProviderFactory.KAMAL_2) < 0 ? KamalJsonSchemaProviderFactory.KAMAL_1 : KamalJsonSchemaProviderFactory.KAMAL_2;
            URL uRL = this.getClass().getResource("/schemas/kamal-" + schemaVersion + ".json");
            if (uRL != null) {
                URL it = uRL;
                boolean bl = false;
                virtualFile = VfsUtil.findFileByURL((URL)it);
            } else {
                virtualFile = null;
            }
            return virtualFile;
        }

        private static final Boolean isAvailable$lambda$0(VirtualFile $file, KamalJsonSchemaProvider this$0) {
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)$file, (Project)this$0.project);
            if (module == null) {
                return false;
            }
            GemInfo gemInfo = RubyProjectGemSearchService.Companion.findGem(module, "kamal");
            if (gemInfo != null) {
                this$0.kamalGemInfo = gemInfo;
            }
            return gemInfo != null;
        }
    }
}

