#pragma once


static const float2 xyPrimaryBt709Red   = float2(0.64f, 0.33f);
static const float2 xyPrimaryBt709Green = float2(0.30f, 0.60f);
static const float2 xyPrimaryBt709Blue  = float2(0.15f, 0.06f);

static const float2 xyPrimaryDciP3Red   = float2(0.680f, 0.320f);
static const float2 xyPrimaryDciP3Green = float2(0.265f, 0.690f);
static const float2 xyPrimaryDciP3Blue  = float2(0.150f, 0.060f);

static const float2 xyPrimaryBt2020Red   = float2(0.708f, 0.292f);
static const float2 xyPrimaryBt2020Green = float2(0.170f, 0.797f);
static const float2 xyPrimaryBt2020Blue  = float2(0.131f, 0.046f);


static const float2 uvPrimaryBt709Red   = float2(0.450704216f,  0.522887349f);
static const float2 uvPrimaryBt709Green = float2(0.125f,        0.5625f);
static const float2 uvPrimaryBt709Blue  = float2(0.175438597f,  0.157894730f);

static const float2 uvPrimaryDciP3Red   = float2(0.496350377f,  0.525547444f);
static const float2 uvPrimaryDciP3Green = float2(0.0986046493f, 0.577674388f);
static const float2 uvPrimaryDciP3Blue  = float2(0.175438597f,  0.157894730f);

static const float2 uvPrimaryBt2020Red   = float2(0.556603789f,  0.516509413f);
static const float2 uvPrimaryBt2020Green = float2(0.0556282736f, 0.586796462f);
static const float2 uvPrimaryBt2020Blue  = float2(0.159270510f,  0.125835865f);


static const float2 CIE_1931_2_Degree_Standard_Observer_xy[] =
{
  float2(0.175560235f,   0.00529383681f),
  float2(0.175482526f,   0.00528633920f),
  float2(0.175400018f,   0.00527864182f),
  float2(0.175317049f,   0.00527096865f),
  float2(0.175236746f,   0.00526349386f),
  float2(0.175161212f,   0.00525634596f),
  float2(0.175087794f,   0.00524684460f),
  float2(0.175014942f,   0.00523557048f),
  float2(0.174945190f,   0.00522615713f),
  float2(0.174880132f,   0.00522078480f),
  float2(0.174820601f,   0.00522060086f),
  float2(0.174770250f,   0.00522866705f),
  float2(0.174722030f,   0.00523752020f),
  float2(0.174665361f,   0.00523616047f),
  float2(0.174595043f,   0.00521832238f),
  float2(0.174509719f,   0.00518163992f),
  float2(0.174409255f,   0.00512676080f),
  float2(0.174308463f,   0.00506759248f),
  float2(0.174221768f,   0.00501703144f),
  float2(0.174155592f,   0.00498144468f),
  float2(0.174112230f,   0.00496372580f),
  float2(0.174088314f,   0.00496360007f),
  float2(0.174072593f,   0.00497254263f),
  float2(0.174057021f,   0.00498203607f),
  float2(0.174036264f,   0.00498596159f),
  float2(0.174007922f,   0.00498054875f),
  float2(0.173971936f,   0.00496408296f),
  float2(0.173931673f,   0.00494340667f),
  float2(0.173889040f,   0.00492604868f),
  float2(0.173845261f,   0.00491609284f),
  float2(0.173800766f,   0.00491541204f),
  float2(0.173754438f,   0.00492485379f),
  float2(0.173705354f,   0.00493709836f),
  float2(0.173655182f,   0.00494379084f),
  float2(0.173606023f,   0.00493989512f),
  float2(0.173559904f,   0.00492320256f),
  float2(0.173514455f,   0.00489544682f),
  float2(0.173468500f,   0.00486457906f),
  float2(0.173423662f,   0.00483631202f),
  float2(0.173380002f,   0.00481333816f),
  float2(0.173336863f,   0.00479674339f),
  float2(0.173291280f,   0.00478584552f),
  float2(0.173237919f,   0.00477888807f),
  float2(0.173174232f,   0.00477513065f),
  float2(0.173101007f,   0.00477403076f),
  float2(0.173020958f,   0.00477505056f),
  float2(0.172934263f,   0.00478114699f),
  float2(0.172842755f,   0.00479079317f),
  float2(0.172751158f,   0.00479876203f),
  float2(0.172662109f,   0.00480208452f),
  float2(0.172576546f,   0.00479930173f),
  float2(0.172489479f,   0.00479525420f),
  float2(0.172395601f,   0.00479611847f),
  float2(0.172296002f,   0.00480262935f),
  float2(0.172192364f,   0.00481488509f),
  float2(0.172086626f,   0.00483252434f),
  float2(0.171982452f,   0.00485501019f),
  float2(0.171871021f,   0.00488853175f),
  float2(0.171741217f,   0.00493933260f),
  float2(0.171587243f,   0.00501034408f),
  float2(0.171407431f,   0.00510217109f),
  float2(0.171206116f,   0.00521125784f),
  float2(0.170992568f,   0.00533390790f),
  float2(0.170770600f,   0.00547012127f),
  float2(0.170540660f,   0.00562096992f),
  float2(0.170300990f,   0.00578850507f),
  float2(0.170050159f,   0.00597389508f),
  float2(0.169785872f,   0.00617680745f),
  float2(0.169504597f,   0.00639803707f),
  float2(0.169202923f,   0.00663870573f),
  float2(0.168877527f,   0.00690024392f),
  float2(0.168524667f,   0.00718404399f),
  float2(0.168146148f,   0.00749067962f),
  float2(0.167746216f,   0.00782081857f),
  float2(0.167328327f,   0.00817540008f),
  float2(0.166895285f,   0.00855560600f),
  float2(0.166446328f,   0.00896440073f),
  float2(0.165976762f,   0.00940171629f),
  float2(0.165483295f,   0.00986468140f),
  float2(0.164962664f,   0.0103507433f),
  float2(0.164411753f,   0.0108575578f),
  float2(0.163828432f,   0.0113848652f),
  float2(0.163209900f,   0.0119373854f),
  float2(0.162552133f,   0.0125200301f),
  float2(0.161851435f,   0.0131373070f),
  float2(0.161104574f,   0.0137933585f),
  float2(0.160309597f,   0.0144913783f),
  float2(0.159465938f,   0.0152320647f),
  float2(0.158573105f,   0.0160151571f),
  float2(0.157631158f,   0.0168398711f),
  float2(0.156640931f,   0.0177048053f),
  float2(0.155605092f,   0.0186086073f),
  float2(0.154524609f,   0.0195556972f),
  float2(0.153397232f,   0.0205537341f),
  float2(0.152219235f,   0.0216117110f),
  float2(0.150985404f,   0.0227401927f),
  float2(0.149690568f,   0.0239503309f),
  float2(0.148336812f,   0.0252473987f),
  float2(0.146928220f,   0.0266351867f),
  float2(0.145468369f,   0.0281184334f),
  float2(0.143960401f,   0.0297029707f),
  float2(0.142405092f,   0.0313935838f),
  float2(0.140795648f,   0.0332131534f),
  float2(0.139120683f,   0.0352005735f),
  float2(0.137363761f,   0.0374030917f),
  float2(0.135502666f,   0.0398791208f),
  float2(0.133509337f,   0.0426923893f),
  float2(0.131370633f,   0.0458759739f),
  float2(0.129085779f,   0.0494498088f),
  float2(0.126662150f,   0.0534259192f),
  float2(0.124118477f,   0.0578025132f),
  float2(0.121468581f,   0.0625876709f),
  float2(0.118701279f,   0.0678304433f),
  float2(0.115807361f,   0.0735807046f),
  float2(0.112776055f,   0.0798958241f),
  float2(0.109594322f,   0.0868425145f),
  float2(0.106260731f,   0.0944860726f),
  float2(0.102775864f,   0.102863736f),
  float2(0.0991275981f,  0.112007029f),
  float2(0.0953040570f,  0.121944859f),
  float2(0.0912935063f,  0.132702037f),
  float2(0.0870824307f,  0.144316583f),
  float2(0.0826795324f,  0.156865954f),
  float2(0.0781159847f,  0.170420482f),
  float2(0.0734372586f,  0.185031875f),
  float2(0.0687059238f,  0.200723215f),
  float2(0.0639930218f,  0.217467606f),
  float2(0.0593158267f,  0.235253736f),
  float2(0.0546665228f,  0.254095584f),
  float2(0.0500314980f,  0.274001806f),
  float2(0.0453907363f,  0.294975966f),
  float2(0.0407573170f,  0.316981077f),
  float2(0.0361951105f,  0.339899927f),
  float2(0.0317564718f,  0.363597691f),
  float2(0.0274941902f,  0.387921333f),
  float2(0.0234599430f,  0.412703484f),
  float2(0.0197046361f,  0.437755882f),
  float2(0.0162684712f,  0.462954521f),
  float2(0.0131830414f,  0.488207072f),
  float2(0.0104757007f,  0.513404250f),
  float2(0.00816802773f, 0.538423061f),
  float2(0.00628485158f, 0.563068449f),
  float2(0.00487542990f, 0.587116420f),
  float2(0.00398242520f, 0.610447525f),
  float2(0.00363638415f, 0.633011400f),
  float2(0.00385852088f, 0.654823124f),
  float2(0.00464571313f, 0.675898432f),
  float2(0.00601091329f, 0.696120083f),
  float2(0.00798839610f, 0.715341508f),
  float2(0.0106032909f,  0.733412921f),
  float2(0.0138702457f,  0.750186443f),
  float2(0.0177661236f,  0.765612125f),
  float2(0.0222442056f,  0.779629945f),
  float2(0.0272732619f,  0.792103528f),
  float2(0.0328203588f,  0.802925646f),
  float2(0.0388518013f,  0.812016010f),
  float2(0.0453279837f,  0.819390773f),
  float2(0.0521766915f,  0.825163543f),
  float2(0.0593255348f,  0.829425752f),
  float2(0.0667158886f,  0.832273721f),
  float2(0.0743024274f,  0.833803117f),
  float2(0.0820533931f,  0.834090292f),
  float2(0.0899417400f,  0.833288908f),
  float2(0.0979397520f,  0.831592679f),
  float2(0.106021106f,   0.829178214f),
  float2(0.114160716f,   0.826206982f),
  float2(0.122347369f,   0.822770416f),
  float2(0.130545660f,   0.818927824f),
  float2(0.138702347f,   0.814774394f),
  float2(0.146773219f,   0.810394585f),
  float2(0.154722064f,   0.805863559f),
  float2(0.162535429f,   0.801238477f),
  float2(0.170237198f,   0.796518564f),
  float2(0.177849531f,   0.791686594f),
  float2(0.185390755f,   0.786727786f),
  float2(0.192876100f,   0.781629204f),
  float2(0.200308799f,   0.776399433f),
  float2(0.207689985f,   0.771054804f),
  float2(0.215029552f,   0.765595078f),
  float2(0.222336605f,   0.760020017f),
  float2(0.229619666f,   0.754329085f),
  float2(0.236884713f,   0.748524487f),
  float2(0.244132563f,   0.742613971f),
  float2(0.251363396f,   0.736605584f),
  float2(0.258577495f,   0.730506598f),
  float2(0.265775084f,   0.724323928f),
  float2(0.272957593f,   0.718062162f),
  float2(0.280128955f,   0.711724758f),
  float2(0.287292420f,   0.705316245f),
  float2(0.294450283f,   0.698842048f),
  float2(0.301603794f,   0.692307770f),
  float2(0.308759927f,   0.685712039f),
  float2(0.315914392f,   0.679063498f),
  float2(0.323066264f,   0.672367393f),
  float2(0.330215543f,   0.665628015f),
  float2(0.337363332f,   0.658848285f),
  float2(0.344513207f,   0.652028203f),
  float2(0.351664423f,   0.645172178f),
  float2(0.358813673f,   0.638287365f),
  float2(0.365959346f,   0.631379067f),
  float2(0.373101532f,   0.624450862f),
  float2(0.380243837f,   0.617502152f),
  float2(0.387378990f,   0.610541820f),
  float2(0.394506543f,   0.603571355f),
  float2(0.401625931f,   0.596592426f),
  float2(0.408736258f,   0.589606881f),
  float2(0.415835767f,   0.582617938f),
  float2(0.422920912f,   0.575630664f),
  float2(0.429988622f,   0.568648874f),
  float2(0.437036424f,   0.561675786f),
  float2(0.444062471f,   0.554713904f),
  float2(0.451064944f,   0.547766029f),
  float2(0.458040654f,   0.540836632f),
  float2(0.464986324f,   0.533930063f),
  float2(0.471898734f,   0.527050554f),
  float2(0.478774785f,   0.520202279f),
  float2(0.485611587f,   0.513388633f),
  float2(0.492404967f,   0.506614923f),
  float2(0.499150663f,   0.499887347f),
  float2(0.505845308f,   0.493211179f),
  float2(0.512486338f,   0.486590802f),
  float2(0.519072532f,   0.480028599f),
  float2(0.525600492f,   0.473527371f),
  float2(0.532065570f,   0.467091351f),
  float2(0.538462758f,   0.460725247f),
  float2(0.544786512f,   0.454434126f),
  float2(0.551031053f,   0.448224514f),
  float2(0.557192921f,   0.442099153f),
  float2(0.563269317f,   0.436058074f),
  float2(0.569256842f,   0.430101960f),
  float2(0.575151324f,   0.424232244f),
  float2(0.580952584f,   0.418446868f),
  float2(0.586650192f,   0.412758409f),
  float2(0.592224776f,   0.407189518f),
  float2(0.597658157f,   0.401761949f),
  float2(0.602932810f,   0.396496623f),
  float2(0.608035087f,   0.391409158f),
  float2(0.612977027f,   0.386486142f),
  float2(0.617778718f,   0.381705760f),
  float2(0.622459292f,   0.377047300f),
  float2(0.627036571f,   0.372491151f),
  float2(0.631520926f,   0.368026018f),
  float2(0.635899841f,   0.363665401f),
  float2(0.640156149f,   0.359427720f),
  float2(0.644272983f,   0.355331361f),
  float2(0.648233115f,   0.351394921f),
  float2(0.652028262f,   0.347627967f),
  float2(0.655669152f,   0.344018280f),
  float2(0.659166157f,   0.340553224f),
  float2(0.662528216f,   0.337220996f),
  float2(0.665763556f,   0.334010660f),
  float2(0.668874144f,   0.330918550f),
  float2(0.671858668f,   0.327947080f),
  float2(0.674719512f,   0.325095176f),
  float2(0.677458882f,   0.322362065f),
  float2(0.680078864f,   0.319747209f),
  float2(0.682581603f,   0.317248702f),
  float2(0.684970617f,   0.314862817f),
  float2(0.687250435f,   0.312585949f),
  float2(0.689426302f,   0.310414016f),
  float2(0.691504001f,   0.308342248f),
  float2(0.693489611f,   0.306365698f),
  float2(0.695388615f,   0.304478555f),
  float2(0.697205543f,   0.302675068f),
  float2(0.698943912f,   0.300950437f),
  float2(0.700606048f,   0.299300700f),
  float2(0.702192604f,   0.297724515f),
  float2(0.703708708f,   0.296217113f),
  float2(0.705162882f,   0.294770300f),
  float2(0.706563234f,   0.293376147f),
  float2(0.707917809f,   0.292027115f),
  float2(0.709230959f,   0.290718615f),
  float2(0.710500419f,   0.289452940f),
  float2(0.711724162f,   0.288232117f),
  float2(0.712901234f,   0.287057310f),
  float2(0.714031577f,   0.285928875f),
  float2(0.715117037f,   0.284845113f),
  float2(0.716159224f,   0.283804446f),
  float2(0.717158615f,   0.282806426f),
  float2(0.718116164f,   0.281850248f),
  float2(0.719032943f,   0.280934959f),
  float2(0.719911575f,   0.280058085f),
  float2(0.720752716f,   0.279218971f),
  float2(0.721554517f,   0.278419524f),
  float2(0.722314894f,   0.277661859f),
  float2(0.723031580f,   0.276948362f),
  float2(0.723701894f,   0.276281833f),
  float2(0.724328041f,   0.275660067f),
  float2(0.724914431f,   0.275078177f),
  float2(0.725466787f,   0.274529963f),
  float2(0.725992321f,   0.274007678f),
  float2(0.726494729f,   0.273505270f),
  float2(0.726974964f,   0.273025035f),
  float2(0.727431833f,   0.272568166f),
  float2(0.727864325f,   0.272135674f),
  float2(0.728271722f,   0.271728277f),
  float2(0.728656470f,   0.271343499f),
  float2(0.729020059f,   0.270979970f),
  float2(0.729360938f,   0.270639061f),
  float2(0.729677796f,   0.270322203f),
  float2(0.729969024f,   0.270030975f),
  float2(0.730233967f,   0.269766062f),
  float2(0.730474174f,   0.269525825f),
  float2(0.730693280f,   0.269306689f),
  float2(0.730896234f,   0.269103735f),
  float2(0.731089413f,   0.268910616f),
  float2(0.731279611f,   0.268720358f),
  float2(0.731467068f,   0.268532961f),
  float2(0.731649994f,   0.268350034f),
  float2(0.731826305f,   0.268173664f),
  float2(0.731993317f,   0.268006712f),
  float2(0.732150435f,   0.267849564f),
  float2(0.732299804f,   0.267700165f),
  float2(0.732442796f,   0.267557173f),
  float2(0.732581496f,   0.267418503f),
  float2(0.732718884f,   0.267281115f),
  float2(0.732858657f,   0.267141342f),
  float2(0.733000218f,   0.266999781f),
  float2(0.733141660f,   0.266858339f),
  float2(0.733281195f,   0.266718834f),
  float2(0.733416974f,   0.266583025f),
  float2(0.733550608f,   0.266449421f),
  float2(0.733683288f,   0.266316711f),
  float2(0.733812689f,   0.266187280f),
  float2(0.733935713f,   0.266064316f),
  float2(0.734047293f,   0.265952706f),
  float2(0.734142541f,   0.265857428f),
  float2(0.734221458f,   0.265778541f),
  float2(0.734286427f,   0.265713542f),
  float2(0.734340906f,   0.265659093f),
  float2(0.734390139f,   0.265609830f),
  float2(0.734437704f,   0.265562295f),
  float2(0.734482169f,   0.265517830f),
  float2(0.734522938f,   0.265477061f),
  float2(0.734559535f,   0.265440493f),
  float2(0.734591662f,   0.265408337f),
  float2(0.734621107f,   0.265378892f),
  float2(0.734648883f,   0.265351116f),
  float2(0.734673380f,   0.265326619f),
  float2(0.734690070f,   0.265309959f)
};


static const float2 CIE_1931_2_Degree_Standard_Observer_uv[] =
{
  float2(0.258899688f,   0.0175654161f),
  float2(0.258778840f,   0.0175401140f),
  float2(0.258650243f,   0.0175141058f),
  float2(0.258520841f,   0.0174881704f),
  float2(0.258395671f,   0.0174629148f),
  float2(0.258278101f,   0.0174387786f),
  float2(0.258166700f,   0.0174070466f),
  float2(0.258058279f,   0.0173695757f),
  float2(0.257952928f,   0.0173381771f),
  float2(0.257850736f,   0.0173199344f),
  float2(0.257751882f,   0.0173185784f),
  float2(0.257658898f,   0.0173440743f),
  float2(0.257568567f,   0.0173721443f),
  float2(0.257475823f,   0.0173670127f),
  float2(0.257379144f,   0.0173083152f),
  float2(0.257278889f,   0.0171883534f),
  float2(0.257174164f,   0.0170091800f),
  float2(0.257073700f,   0.0168160274f),
  float2(0.256986916f,   0.0166509095f),
  float2(0.256917238f,   0.0165345985f),
  float2(0.256865203f,   0.0164765510f),
  float2(0.256825506f,   0.0164758507f),
  float2(0.256789177f,   0.0165046900f),
  float2(0.256752490f,   0.0165353156f),
  float2(0.256713479f,   0.0165478028f),
  float2(0.256672441f,   0.0165298879f),
  float2(0.256631225f,   0.0164760053f),
  float2(0.256587713f,   0.0164083931f),
  float2(0.256536453f,   0.0163515191f),
  float2(0.256474882f,   0.0163186639f),
  float2(0.256401628f,   0.0163159165f),
  float2(0.256313800f,   0.0163460168f),
  float2(0.256218224f,   0.0163851752f),
  float2(0.256127178f,   0.0164062939f),
  float2(0.256049782f,   0.0163930542f),
  float2(0.255991965f,   0.0163383111f),
  float2(0.255947768f,   0.0162476506f),
  float2(0.255906283f,   0.0161468610f),
  float2(0.255863696f,   0.0160545129f),
  float2(0.255817025f,   0.0159793589f),
  float2(0.255764037f,   0.0159249305f),
  float2(0.255700528f,   0.0158889833f),
  float2(0.255619585f,   0.0158657468f),
  float2(0.255517870f,   0.0158527921f),
  float2(0.255397260f,   0.0158483609f),
  float2(0.255262941f,   0.0158507395f),
  float2(0.255111813f,   0.0158695336f),
  float2(0.254948735f,   0.0158997979f),
  float2(0.254787415f,   0.0159246083f),
  float2(0.254635632f,   0.0159343536f),
  float2(0.254496544f,   0.0159243121f),
  float2(0.254356354f,   0.0159101448f),
  float2(0.254199355f,   0.0159118510f),
  float2(0.254026532f,   0.0159318223f),
  float2(0.253840565f,   0.0159703921f),
  float2(0.253645151f,   0.0160264000f),
  float2(0.253446936f,   0.0160981360f),
  float2(0.253224402f,   0.0162055529f),
  float2(0.252952158f,   0.0163687169f),
  float2(0.252617478f,   0.0165969580f),
  float2(0.252217084f,   0.0168920513f),
  float2(0.251762330f,   0.0172423534f),
  float2(0.251272886f,   0.0176358502f),
  float2(0.250755220f,   0.0180724225f),
  float2(0.250209093f,   0.0185553412f),
  float2(0.249629497f,   0.0190909542f),
  float2(0.249013036f,   0.0196827221f),
  float2(0.248356580f,   0.0203292202f),
  float2(0.247653782f,   0.0210325885f),
  float2(0.246898144f,   0.0217959564f),
  float2(0.246083170f,   0.0226233564f),
  float2(0.245201751f,   0.0235186070f),
  float2(0.244256824f,   0.0244829375f),
  float2(0.243255242f,   0.0255178567f),
  float2(0.242202237f,   0.0266256481f),
  float2(0.241101801f,   0.0278092771f),
  float2(0.239950284f,   0.0290770828f),
  float2(0.238741010f,   0.0304277203f),
  float2(0.237472534f,   0.0318511240f),
  float2(0.236143052f,   0.0333383083f),
  float2(0.234750926f,   0.0348810181f),
  float2(0.233293950f,   0.0364774614f),
  float2(0.231764018f,   0.0381409302f),
  float2(0.230151236f,   0.0398848988f),
  float2(0.228446841f,   0.0417212657f),
  float2(0.226643621f,   0.0436604432f),
  float2(0.224737480f,   0.0457096844f),
  float2(0.222729235f,   0.0478685833f),
  float2(0.220620721f,   0.0501337796f),
  float2(0.218415245f,   0.0525003448f),
  float2(0.216117888f,   0.0549615658f),
  float2(0.213736429f,   0.0575110241f),
  float2(0.211270987f,   0.0601586438f),
  float2(0.208714336f,   0.0629227980f),
  float2(0.206056550f,   0.0658246502f),
  float2(0.203284963f,   0.0688885375f),
  float2(0.200387448f,   0.0721389949f),
  float2(0.197368264f,   0.0755835920f),
  float2(0.194236084f,   0.0792251229f),
  float2(0.190998345f,   0.0830681771f),
  float2(0.187661334f,   0.0871192589f),
  float2(0.184229120f,   0.0913810580f),
  float2(0.180682912f,   0.0959004163f),
  float2(0.176989004f,   0.100759692f),
  float2(0.173105254f,   0.106054253f),
  float2(0.168979957f,   0.111896231f),
  float2(0.164557665f,   0.118396662f),
  float2(0.159829452f,   0.125581696f),
  float2(0.154815033f,   0.133438721f),
  float2(0.149551510f,   0.141931384f),
  float2(0.144097894f,   0.150990784f),
  float2(0.138500124f,   0.160567447f),
  float2(0.132754579f,   0.170687347f),
  float2(0.126865118f,   0.181364610f),
  float2(0.120835877f,   0.192612990f),
  float2(0.114670753f,   0.204446420f),
  float2(0.108393058f,   0.216859757f),
  float2(0.102040834f,   0.229788184f),
  float2(0.0956407934f,  0.243151187f),
  float2(0.0892207548f,  0.256862401f),
  float2(0.0828089565f,  0.270830482f),
  float2(0.0764277502f,  0.284983217f),
  float2(0.0701114833f,  0.299297004f),
  float2(0.0639140605f,  0.313733428f),
  float2(0.0578986071f,  0.328231841f),
  float2(0.0521361753f,  0.342708706f),
  float2(0.0466963872f,  0.357048928f),
  float2(0.0415929406f,  0.371165901f),
  float2(0.0368136242f,  0.385005384f),
  float2(0.0323411971f,  0.398518532f),
  float2(0.0281539633f,  0.411662667f),
  float2(0.0242521557f,  0.424385607f),
  float2(0.0206640008f,  0.436614453f),
  float2(0.0174016170f,  0.448292046f),
  float2(0.0144704980f,  0.459376424f),
  float2(0.0118701551f,  0.469840109f),
  float2(0.00959603022f, 0.479664653f),
  float2(0.00763516593f, 0.488869071f),
  float2(0.00597049994f, 0.497486919f),
  float2(0.00458460208f, 0.505545854f),
  float2(0.00345929153f, 0.513069391f),
  float2(0.00257992162f, 0.520062088f),
  float2(0.00194324506f, 0.526527941f),
  float2(0.00154396391f, 0.532500922f),
  float2(0.00137366366f, 0.538027763f),
  float2(0.00142247509f, 0.543163239f),
  float2(0.00167390622f, 0.547952234f),
  float2(0.00211998634f, 0.552407145f),
  float2(0.00276221032f, 0.556535780f),
  float2(0.00360051495f, 0.560344398f),
  float2(0.00463326228f, 0.563838124f),
  float2(0.00584805663f, 0.567035496f),
  float2(0.00722738308f, 0.569947957f),
  float2(0.00876200478f, 0.572572946f),
  float2(0.0104444706f,  0.574911475f),
  float2(0.0122691625f,  0.576966881f),
  float2(0.0142294345f,  0.578755140f),
  float2(0.0163082629f,  0.580301523f),
  float2(0.0184894539f,  0.581624209f),
  float2(0.0207613650f,  0.582740724f),
  float2(0.0231165084f,  0.583667159f),
  float2(0.0255519002f,  0.584416210f),
  float2(0.0280638560f,  0.585011243f),
  float2(0.0306463167f,  0.585480570f),
  float2(0.0332926064f,  0.585849225f),
  float2(0.0359953530f,  0.586139678f),
  float2(0.0387526266f,  0.586364507f),
  float2(0.0415550619f,  0.586529195f),
  float2(0.0443851500f,  0.586642801f),
  float2(0.0472274124f,  0.586713910f),
  float2(0.0500681437f,  0.586750268f),
  float2(0.0529009550f,  0.586759090f),
  float2(0.0557343922f,  0.586742103f),
  float2(0.0585776083f,  0.586698174f),
  float2(0.0614387728f,  0.586626172f),
  float2(0.0643252730f,  0.586525022f),
  float2(0.0672392919f,  0.586395740f),
  float2(0.0701816752f,  0.586240649f),
  float2(0.0731574520f,  0.586060047f),
  float2(0.0761715844f,  0.585854232f),
  float2(0.0792289897f,  0.585623383f),
  float2(0.0823336541f,  0.585367858f),
  float2(0.0854872986f,  0.585088491f),
  float2(0.0886913985f,  0.584785997f),
  float2(0.0919474586f,  0.584461152f),
  float2(0.0952570140f,  0.584114551f),
  float2(0.0986222624f,  0.583746552f),
  float2(0.102046534f,   0.583357632f),
  float2(0.105532869f,   0.582948267f),
  float2(0.109083905f,   0.582519173f),
  float2(0.112701840f,   0.582070946f),
  float2(0.116392120f,   0.581603407f),
  float2(0.120154574f,   0.581117272f),
  float2(0.123990677f,   0.580612778f),
  float2(0.127902463f,   0.580090165f),
  float2(0.131892636f,   0.579549610f),
  float2(0.135965496f,   0.578990936f),
  float2(0.140122964f,   0.578414320f),
  float2(0.144365385f,   0.577820301f),
  float2(0.148693993f,   0.577209234f),
  float2(0.153111159f,   0.576581358f),
  float2(0.157621562f,   0.575936317f),
  float2(0.162223353f,   0.575274646f),
  float2(0.166919022f,   0.574596166f),
  float2(0.171711012f,   0.573900580f),
  float2(0.176601707f,   0.573187589f),
  float2(0.181592747f,   0.572457253f),
  float2(0.186684489f,   0.571709632f),
  float2(0.191877633f,   0.570944786f),
  float2(0.197173297f,   0.570162534f),
  float2(0.202573031f,   0.569362878f),
  float2(0.208078280f,   0.568545579f),
  float2(0.213689252f,   0.567710936f),
  float2(0.219405934f,   0.566859006f),
  float2(0.225228250f,   0.565990090f),
  float2(0.231155991f,   0.565104365f),
  float2(0.237189128f,   0.564201891f),
  float2(0.243326097f,   0.563283145f),
  float2(0.249564513f,   0.562348902f),
  float2(0.255902498f,   0.561399817f),
  float2(0.262338727f,   0.560436606f),
  float2(0.268872916f,   0.559459567f),
  float2(0.275503456f,   0.558468759f),
  float2(0.282226800f,   0.557464778f),
  float2(0.289038568f,   0.556448101f),
  float2(0.295933395f,   0.555419445f),
  float2(0.302904456f,   0.554380178f),
  float2(0.309947490f,   0.553330659f),
  float2(0.317059814f,   0.552270650f),
  float2(0.324237704f,   0.551199972f),
  float2(0.331476181f,   0.550118684f),
  float2(0.338774681f,   0.549026191f),
  float2(0.346116483f,   0.547925531f),
  float2(0.353470772f,   0.546822071f),
  float2(0.360805183f,   0.545721709f),
  float2(0.368085563f,   0.544630408f),
  float2(0.375281691f,   0.543553411f),
  float2(0.382400810f,   0.542489171f),
  float2(0.389464050f,   0.541434168f),
  float2(0.396493047f,   0.540384590f),
  float2(0.403510093f,   0.539336740f),
  float2(0.410527020f,   0.538288414f),
  float2(0.417518377f,   0.537243783f),
  float2(0.424448996f,   0.536208510f),
  float2(0.431281358f,   0.535188615f),
  float2(0.437975168f,   0.534190654f),
  float2(0.444503158f,   0.533219039f),
  float2(0.450873345f,   0.532272279f),
  float2(0.457095086f,   0.531348168f),
  float2(0.463177263f,   0.530444502f),
  float2(0.469128340f,   0.529559135f),
  float2(0.474945187f,   0.528692007f),
  float2(0.480615884f,   0.527845084f),
  float2(0.486135154f,   0.527019619f),
  float2(0.491497486f,   0.526216924f),
  float2(0.496697157f,   0.525438249f),
  float2(0.501730263f,   0.524684309f),
  float2(0.506596386f,   0.523955106f),
  float2(0.511296570f,   0.523250758f),
  float2(0.515833437f,   0.522571206f),
  float2(0.520211458f,   0.521916210f),
  float2(0.524436354f,   0.521285295f),
  float2(0.528514683f,   0.520677387f),
  float2(0.532452762f,   0.520091056f),
  float2(0.536255180f,   0.519525229f),
  float2(0.539924919f,   0.518978953f),
  float2(0.543460249f,   0.518452107f),
  float2(0.546868443f,   0.517943799f),
  float2(0.550165116f,   0.517451763f),
  float2(0.553365707f,   0.516973793f),
  float2(0.556485593f,   0.516507685f),
  float2(0.559533238f,   0.516052126f),
  float2(0.562501430f,   0.515608191f),
  float2(0.565383553f,   0.515176832f),
  float2(0.568174958f,   0.514758884f),
  float2(0.570873260f,   0.514354765f),
  float2(0.573480665f,   0.513964235f),
  float2(0.575999140f,   0.513586997f),
  float2(0.578428387f,   0.513223052f),
  float2(0.580768585f,   0.512872457f),
  float2(0.583020925f,   0.512535154f),
  float2(0.585189998f,   0.512210369f),
  float2(0.587276279f,   0.511898159f),
  float2(0.589273631f,   0.511599421f),
  float2(0.591175556f,   0.511315107f),
  float2(0.592974841f,   0.511046350f),
  float2(0.594663262f,   0.510794520f),
  float2(0.596244931f,   0.510558843f),
  float2(0.597730815f,   0.510337650f),
  float2(0.599135220f,   0.510128498f),
  float2(0.600476562f,   0.509928524f),
  float2(0.601767361f,   0.509734928f),
  float2(0.603004693f,   0.509549319f),
  float2(0.604184985f,   0.509372234f),
  float2(0.605305194f,   0.509204208f),
  float2(0.606363058f,   0.509045541f),
  float2(0.607364416f,   0.508895337f),
  float2(0.608312606f,   0.508753120f),
  float2(0.609203636f,   0.508619427f),
  float2(0.610033333f,   0.508494973f),
  float2(0.610797286f,   0.508380413f),
  float2(0.611493408f,   0.508275985f),
  float2(0.612125575f,   0.508181154f),
  float2(0.612702965f,   0.508094549f),
  float2(0.613238394f,   0.508014261f),
  float2(0.613748550f,   0.507937729f),
  float2(0.614251613f,   0.507862269f),
  float2(0.614747762f,   0.507787823f),
  float2(0.615232527f,   0.507715106f),
  float2(0.615700423f,   0.507644951f),
  float2(0.616143822f,   0.507578432f),
  float2(0.616561472f,   0.507515788f),
  float2(0.616958975f,   0.507456123f),
  float2(0.617339730f,   0.507399022f),
  float2(0.617709338f,   0.507343590f),
  float2(0.618075788f,   0.507288634f),
  float2(0.618448853f,   0.507232666f),
  float2(0.618827044f,   0.507175922f),
  float2(0.619205296f,   0.507119178f),
  float2(0.619578659f,   0.507063210f),
  float2(0.619942367f,   0.507008671f),
  float2(0.620300471f,   0.506954908f),
  float2(0.620656490f,   0.506901502f),
  float2(0.621003925f,   0.506849408f),
  float2(0.621334314f,   0.506799876f),
  float2(0.621634364f,   0.506754815f),
  float2(0.621890664f,   0.506716430f),
  float2(0.622103035f,   0.506684541f),
  float2(0.622277975f,   0.506658315f),
  float2(0.622424721f,   0.506636261f),
  float2(0.622557401f,   0.506616413f),
  float2(0.622685551f,   0.506597161f),
  float2(0.622805416f,   0.506579160f),
  float2(0.622915327f,   0.506562709f),
  float2(0.623014032f,   0.506547868f),
  float2(0.623100757f,   0.506534874f),
  float2(0.623180150f,   0.506522953f),
  float2(0.623255193f,   0.506511747f),
  float2(0.623321294f,   0.506501793f),
  float2(0.623366296f,   0.506495058f)
};

static const float2 PointersGamutxy[] =
{
  float2(0.659f, 0.316f),
  float2(0.634f, 0.351f),
  float2(0.594f, 0.391f),
  float2(0.557f, 0.427f),
  float2(0.523f, 0.462f),
  float2(0.482f, 0.491f),
  float2(0.444f, 0.515f),
  float2(0.409f, 0.546f),
  float2(0.371f, 0.558f),
  float2(0.332f, 0.573f),
  float2(0.288f, 0.584f),
  float2(0.242f, 0.576f),
  float2(0.202f, 0.530f),
  float2(0.177f, 0.454f),
  float2(0.151f, 0.389f),
  float2(0.151f, 0.330f),
  float2(0.162f, 0.295f),
  float2(0.157f, 0.266f),
  float2(0.159f, 0.245f),
  float2(0.142f, 0.214f),
  float2(0.141f, 0.195f),
  float2(0.129f, 0.168f),
  float2(0.138f, 0.141f),
  float2(0.145f, 0.129f),
  float2(0.145f, 0.106f),
  float2(0.161f, 0.094f),
  float2(0.188f, 0.084f),
  float2(0.252f, 0.104f),
  float2(0.324f, 0.127f),
  float2(0.393f, 0.165f),
  float2(0.451f, 0.199f),
  float2(0.508f, 0.226f)
};

static const float2 PointersGamutuv[] =
{
  float2(0.481549143f,  0.519546926f),
  float2(0.426648736f,  0.531460285f),
  float2(0.365313649f,  0.541051685f),
  float2(0.317831665f,  0.548216819f),
  float2(0.279007732f,  0.554547905f),
  float2(0.243188694f,  0.557391524f),
  float2(0.214182347f,  0.558972477f),
  float2(0.187313944f,  0.562628805f),
  float2(0.165735989f,  0.560866653f),
  float2(0.144159793f,  0.559813261f),
  float2(0.122137404f,  0.557251930f),
  float2(0.122137404f,  0.557251930f),
  float2(0.102672889f,  0.549851477f),
  float2(0.0902188494f, 0.532603859f),
  float2(0.0874722003f, 0.504818379f),
  float2(0.0819983705f, 0.475291877f),
  float2(0.0907179340f, 0.446079909f),
  float2(0.104247100f,  0.427123546f),
  float2(0.106839060f,  0.407281398f),
  float2(0.113127000f,  0.392209172f),
  float2(0.107494324f,  0.364496588f),
  float2(0.111506521f,  0.346975088f),
  float2(0.108448930f,  0.317780584f),
  float2(0.125f,        0.287364125f),
  float2(0.136214181f,  0.272663235f),
  float2(0.145655453f,  0.239578098f),
  float2(0.169206514f,  0.222280606f),
  float2(0.207048460f,  0.208149775f),
  float2(0.269230782f,  0.25f),
  float2(0.334365338f,  0.294891655f),
  float2(0.374821186f,  0.354077249f),
  float2(0.402139991f,  0.399242073f)
};
