# type: ignore
from __future__ import annotations
import openvino._pyopenvino
import typing
"""
openvino.properties.device submodule that simulates ov::device
"""
__all__ = ['Capability', 'PCIInfo', 'Priorities', 'Type', 'architecture', 'capabilities', 'full_name', 'gops', 'id', 'luid', 'pci_info', 'priorities', 'properties', 'thermal', 'type', 'uuid']
class Capability:
    """
    openvino.properties.device.Capability that simulates ov::device::capability
    """
    BF16: typing.ClassVar[str] = 'BF16'
    BIN: typing.ClassVar[str] = 'BIN'
    EXPORT_IMPORT: typing.ClassVar[str] = 'EXPORT_IMPORT'
    FP16: typing.ClassVar[str] = 'FP16'
    FP32: typing.ClassVar[str] = 'FP32'
    INT16: typing.ClassVar[str] = 'INT16'
    INT8: typing.ClassVar[str] = 'INT8'
    WINOGRAD: typing.ClassVar[str] = 'WINOGRAD'
class PCIInfo:
    def __init__(self, arg0: typing.SupportsInt, arg1: typing.SupportsInt, arg2: typing.SupportsInt, arg3: typing.SupportsInt) -> None:
        ...
    def __repr__(self) -> typing.Any:
        ...
    @property
    def bus(self) -> int:
        ...
    @property
    def device(self) -> int:
        ...
    @property
    def domain(self) -> int:
        ...
    @property
    def function(self) -> int:
        ...
class Priorities:
    pass
class Type:
    """
    Members:
    
      INTEGRATED
    
      DISCRETE
    """
    DISCRETE: typing.ClassVar[Type]  # value = <Type.DISCRETE: 1>
    INTEGRATED: typing.ClassVar[Type]  # value = <Type.INTEGRATED: 0>
    __members__: typing.ClassVar[dict[str, Type]]  # value = {'INTEGRATED': <Type.INTEGRATED: 0>, 'DISCRETE': <Type.DISCRETE: 1>}
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __ge__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __gt__(self, other: typing.Any) -> bool:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: typing.SupportsInt) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __le__(self, other: typing.Any) -> bool:
        ...
    def __lt__(self, other: typing.Any) -> bool:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: typing.SupportsInt) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
def architecture() -> str:
    ...
def capabilities() -> str:
    ...
def full_name() -> str:
    ...
def gops() -> str:
    ...
@typing.overload
def id() -> str:
    ...
@typing.overload
def id(arg0: str) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
def luid() -> str:
    ...
def pci_info() -> str:
    ...
@typing.overload
def priorities() -> str:
    ...
@typing.overload
def priorities(*args) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def properties() -> str:
    ...
@typing.overload
def properties(*args) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
def thermal() -> str:
    ...
def type() -> str:
    ...
def uuid() -> str:
    ...
