#
# Copyright (C) 2015  FreeIPA Contributors see COPYING for license
#

from ipaplatform.arch.paths import paths
from ipaplatform.redhat.tasks import RedHatTaskNamespace


class ArchTaskNamespace(RedHatTaskNamespace):
    def restore_network_configuration(self, fstore, statestore):
        filepath = paths.ETC_HOSTNAME
        if fstore.has_file(filepath):
            fstore.restore_file(filepath)

    def is_fips_enabled(self):
        return False


tasks = ArchTaskNamespace()
