#
# Copyright (C) 2015  FreeIPA Contributors see COPYING for license
#

from ipaplatform.redhat import services as redhat_services

arch_system_units = dict(redhat_services.redhat_system_units)
arch_system_units['messagebus'] = 'dbus.service'
arch_system_units['rpcgssd'] = 'rpc-gssd.service'
arch_system_units['rpcidmapd'] = 'rpc-idmapd.service'
arch_system_units['gssproxy'] = 'gssproxy.service'
arch_system_units['domainname'] = 'nis-domainname.service'


class ArchService(redhat_services.RedHatService):
    system_units = arch_system_units


def arch_service_class_factory(name, api=None):
    if name in {'messagebus', 'rpcgssd', 'rpcidmapd'}:
        return ArchService(name, api)
    return redhat_services.redhat_service_class_factory(name, api)


class ArchServices(redhat_services.RedHatServices):
    def service_class_factory(self, name, api=None):
        return arch_service_class_factory(name, api)


timedate_services = redhat_services.timedate_services
service = arch_service_class_factory
knownservices = ArchServices()
