#
# Copyright (C) 2015  FreeIPA Contributors see COPYING for license
#

from ipaplatform.redhat.paths import RedHatPathNamespace


class ArchPathNamespace(RedHatPathNamespace):
    ETC_SYSCONFIG_DIR = "/etc/conf.d"
    AUTOFS_LDAP_AUTH_CONF = "/etc/autofs/autofs_ldap_auth.conf"
    CERTMONGER_COMMAND_TEMPLATE = "/usr/lib/ipa/certmonger/%s"
    SYSCONFIG_NFS = "/etc/nfs.conf"
    SYSCONFIG_NTPD = "/etc/conf.d/ntpd.conf"
    SYSCONFIG_AUTOFS = "/etc/default/autofs"
    SYSCONF_NETWORK = "/etc/conf.d/network"
    DOGTAG_IPA_CA_RENEW_AGENT_SUBMIT = (
        "/usr/lib/certmonger/certmonger/dogtag-ipa-ca-renew-agent-submit")
    DOGTAG_IPA_RENEW_AGENT_SUBMIT = (
        "/usr/lib/certmonger/certmonger/dogtag-ipa-renew-agent-submit")
    IPA_SERVER_GUARD = "/usr/lib/certmonger/certmonger/ipa-server-guard"
    LIB64_FIREFOX = "/usr/lib/firefox"
    IPA_P11_KIT = "/etc/ca-certificates/trust-source/ipa.p11-kit"
    SYSTEMWIDE_IPA_CA_CRT = "/etc/ca-certificates/trust-source/anchors/ipa-ca.crt"


paths = ArchPathNamespace()
