/****************************************************************************
 *
 * Filename:    PicoConnectProbes.h
 * Copyright:   Pico Technology Limited 2016 - 2022
 * Description:
 *
 * This header defines enumerations relating to PicoConnect (TM)
 * probes and the corresponding voltage/current ranges.
 *
 ****************************************************************************/

#ifndef __PICOCONNECTPROBES_H__
#define __PICOCONNECTPROBES_H__

#include <stdint.h>

typedef int32_t PicoConnectProbe;

typedef enum enPicoConnectProbe
{
  PICO_CONNECT_PROBE_NONE = 0,

  PICO_CONNECT_PROBE_D9_BNC = 4000,
  PICO_CONNECT_PROBE_D9_2X_BNC,
  PICO_CONNECT_PROBE_DIFFERENTIAL,
  PICO_CONNECT_PROBE_CURRENT_CLAMP_200_2KA,
  PICO_CONNECT_PROBE_CURRENT_CLAMP_40A,
  PICO_CONNECT_PROBE_CAT3_HV_1KV,
  PICO_CONNECT_PROBE_CURRENT_CLAMP_2000ARMS,

  PICO_BNC_PLUS_PREMIUM_TEST_LEAD_BLUE = 4404,
  PICO_BNC_PLUS_PREMIUM_TEST_LEAD_RED,
  PICO_BNC_PLUS_PREMIUM_TEST_LEAD_GREEN,
  PICO_BNC_PLUS_PREMIUM_TEST_LEAD_YELLOW,
  PICO_BNC_PLUS_COP_PROBE,

  PICO_BNC_PLUS_TEMPERATURE_PROBE = 5000,
  PICO_BNC_PLUS_100A_CURRENT_CLAMP = 5003,
  PICO_BNC_PLUS_HT_PICKUP = 5005,
  PICO_BNC_PLUS_X10_SCOPE_PROBE = 5006,
  PICO_BNC_PLUS_2000A_CURRENT_CLAMP = 5007,
  PICO_BNC_PLUS_PRESSURE_SENSOR = 5008,
  PICO_BNC_PLUS_RESISTANCE_LEAD = 5009,
  PICO_BNC_PLUS_60A_CURRENT_CLAMP = 5010,
  PICO_BNC_PLUS_OPTICAL_SENSOR = 5011,
  PICO_BNC_PLUS_60A_CURRENT_CLAMP_V2 = 5012,
  PICO_BNC_PLUS_HIGH_VOLTAGE_DIFFERENTIAL = 5013,

  PICO_PASSIVE_PROBE_X10 = 6000,
  PICO_ACTIVE_X10_750MHZ = 6001,
  PICO_ACTIVE_X10_1_3GHZ = 6002,
  PICO_PASSIVE_PROBE_X10_50OHM = 6003,

  PICO_CONNECT_PROBE_INTELLIGENT = -3,

  PICO_CONNECT_PROBE_UNKNOWN_PROBE = -2,
  PICO_CONNECT_PROBE_FAULT_PROBE = -1
} PICO_CONNECT_PROBE;

typedef enum enPicoConnectProbeRange
{
  PICO_X1_PROBE_10MV,
  PICO_X1_PROBE_20MV,
  PICO_X1_PROBE_50MV,
  PICO_X1_PROBE_100MV,
  PICO_X1_PROBE_200MV,
  PICO_X1_PROBE_500MV,
  PICO_X1_PROBE_1V,
  PICO_X1_PROBE_2V,
  PICO_X1_PROBE_5V,
  PICO_X1_PROBE_10V,
  PICO_X1_PROBE_20V,
  PICO_X1_PROBE_50V,
  PICO_X1_PROBE_100V,
  PICO_X1_PROBE_200V,
  PICO_X1_PROBE_RANGES = (PICO_X1_PROBE_200V + 1) - PICO_X1_PROBE_10MV,

  PICO_X10_PROBE_100MV = 0x00000020,
  PICO_X10_PROBE_200MV,
  PICO_X10_PROBE_500MV,
  PICO_X10_PROBE_1V,
  PICO_X10_PROBE_2V,
  PICO_X10_PROBE_5V,
  PICO_X10_PROBE_10V,
  PICO_X10_PROBE_20V,
  PICO_X10_PROBE_50V,
  PICO_X10_PROBE_100V,
  PICO_X10_PROBE_200V,
  PICO_X10_PROBE_500V,
  PICO_X10_PROBE_RANGES = PICO_X10_PROBE_500V - PICO_X10_PROBE_100MV + 1,

  PICO_PS4000A_RESISTANCE_315K = 0x00000200,
  PICO_PS4000A_RESISTANCE_1100K,
  PICO_PS4000A_RESISTANCE_10M,
  PICO_PS4000A_MAX_RESISTANCE_RANGES = (PICO_PS4000A_RESISTANCE_10M + 1) - PICO_PS4000A_RESISTANCE_315K,
  PICO_PS4000A_RESISTANCE_ADCV_FLAG = 0x10000000,

  PICO_CONNECT_PROBE_OFF = 1024,

  PICO_D9_BNC_10MV = 0,
  PICO_D9_BNC_20MV,
  PICO_D9_BNC_50MV,
  PICO_D9_BNC_100MV,
  PICO_D9_BNC_200MV,
  PICO_D9_BNC_500MV,
  PICO_D9_BNC_1V,
  PICO_D9_BNC_2V,
  PICO_D9_BNC_5V,
  PICO_D9_BNC_10V,
  PICO_D9_BNC_20V,
  PICO_D9_BNC_50V,
  PICO_D9_BNC_100V,
  PICO_D9_BNC_200V,
  PICO_MAX_D9_BNC_RANGES = (PICO_D9_BNC_200V + 1) - PICO_D9_BNC_10MV,


  PICO_D9_2X_BNC_10MV = PICO_D9_BNC_10MV,
  PICO_D9_2X_BNC_20MV = PICO_D9_BNC_20MV,
  PICO_D9_2X_BNC_50MV = PICO_D9_BNC_50MV,
  PICO_D9_2X_BNC_100MV = PICO_D9_BNC_100MV,
  PICO_D9_2X_BNC_200MV = PICO_D9_BNC_200MV,
  PICO_D9_2X_BNC_500MV = PICO_D9_BNC_500MV,
  PICO_D9_2X_BNC_1V = PICO_D9_BNC_1V,
  PICO_D9_2X_BNC_2V = PICO_D9_BNC_2V,
  PICO_D9_2X_BNC_5V = PICO_D9_BNC_5V,
  PICO_D9_2X_BNC_10V = PICO_D9_BNC_10V,
  PICO_D9_2X_BNC_20V = PICO_D9_BNC_20V,
  PICO_D9_2X_BNC_50V = PICO_D9_BNC_50V,
  PICO_D9_2X_BNC_100V = PICO_D9_BNC_100V,
  PICO_D9_2X_BNC_200V = PICO_D9_BNC_200V,
  PICO_MAX_D9_2X_BNC_RANGES = (PICO_D9_2X_BNC_200V + 1) - PICO_D9_2X_BNC_10MV,


  PICO_DIFFERENTIAL_10MV = PICO_D9_BNC_10MV,
  PICO_DIFFERENTIAL_20MV = PICO_D9_BNC_20MV,
  PICO_DIFFERENTIAL_50MV = PICO_D9_BNC_50MV,
  PICO_DIFFERENTIAL_100MV = PICO_D9_BNC_100MV,
  PICO_DIFFERENTIAL_200MV = PICO_D9_BNC_200MV,
  PICO_DIFFERENTIAL_500MV = PICO_D9_BNC_500MV,
  PICO_DIFFERENTIAL_1V = PICO_D9_BNC_1V,
  PICO_DIFFERENTIAL_2V = PICO_D9_BNC_2V,
  PICO_DIFFERENTIAL_5V = PICO_D9_BNC_5V,
  PICO_DIFFERENTIAL_10V = PICO_D9_BNC_10V,
  PICO_DIFFERENTIAL_20V = PICO_D9_BNC_20V,
  PICO_DIFFERENTIAL_50V = PICO_D9_BNC_50V,
  PICO_DIFFERENTIAL_100V = PICO_D9_BNC_100V,
  PICO_DIFFERENTIAL_200V = PICO_D9_BNC_200V,
  PICO_MAX_DIFFERENTIAL_RANGES = (PICO_DIFFERENTIAL_200V + 1) - PICO_DIFFERENTIAL_10MV,


  PICO_CURRENT_CLAMP_200A_2kA_1A = 4000,
  PICO_CURRENT_CLAMP_200A_2kA_2A,
  PICO_CURRENT_CLAMP_200A_2kA_5A,
  PICO_CURRENT_CLAMP_200A_2kA_10A,
  PICO_CURRENT_CLAMP_200A_2kA_20A,
  PICO_CURRENT_CLAMP_200A_2kA_50A,
  PICO_CURRENT_CLAMP_200A_2kA_100A,
  PICO_CURRENT_CLAMP_200A_2kA_200A,
  PICO_CURRENT_CLAMP_200A_2kA_500A,
  PICO_CURRENT_CLAMP_200A_2kA_1000A,
  PICO_CURRENT_CLAMP_200A_2kA_2000A,
  PICO_MAX_CURRENT_CLAMP_200A_2kA_RANGES = (PICO_CURRENT_CLAMP_200A_2kA_2000A + 1) - PICO_CURRENT_CLAMP_200A_2kA_1A,


  PICO_CURRENT_CLAMP_40A_100mA = 5000,
  PICO_CURRENT_CLAMP_40A_200mA,
  PICO_CURRENT_CLAMP_40A_500mA,
  PICO_CURRENT_CLAMP_40A_1A,
  PICO_CURRENT_CLAMP_40A_2A,
  PICO_CURRENT_CLAMP_40A_5A,
  PICO_CURRENT_CLAMP_40A_10A,
  PICO_CURRENT_CLAMP_40A_20A,
  PICO_CURRENT_CLAMP_40A_40A,
  PICO_MAX_CURRENT_CLAMP_40A_RANGES = (PICO_CURRENT_CLAMP_40A_40A + 1) - PICO_CURRENT_CLAMP_40A_100mA,

  PICO_1KV_2_5V = 6003,
  PICO_1KV_5V,
  PICO_1KV_12_5V,
  PICO_1KV_25V,
  PICO_1KV_50V,
  PICO_1KV_125V,
  PICO_1KV_250V,
  PICO_1KV_500V,
  PICO_1KV_1000V,
  PICO_MAX_1KV_RANGES = (PICO_1KV_1000V + 1) - PICO_1KV_2_5V,

  PICO_CURRENT_CLAMP_2000ARMS_10A = 6500,
  PICO_CURRENT_CLAMP_2000ARMS_20A,
  PICO_CURRENT_CLAMP_2000ARMS_50A,
  PICO_CURRENT_CLAMP_2000ARMS_100A,
  PICO_CURRENT_CLAMP_2000ARMS_200A,
  PICO_CURRENT_CLAMP_2000ARMS_500A,
  PICO_CURRENT_CLAMP_2000ARMS_1000A,
  PICO_CURRENT_CLAMP_2000ARMS_2000A,
  PICO_CURRENT_CLAMP_2000ARMS_5000A,
  PICO_CURRENT_CLAMP_2000ARMS_RANGES = (PICO_CURRENT_CLAMP_2000ARMS_5000A + 1) - PICO_CURRENT_CLAMP_2000ARMS_10A,

  PICO_RESISTANCE_LEAD_NEG5_TO_20OHM = 7000,
  PICO_RESISTANCE_LEAD_NEG50_TO_200OHM,
  PICO_RESISTANCE_LEAD_NEG500_TO_2KOHM,
  PICO_RESISTANCE_LEAD_NEG5K_TO_20KOHM,
  PICO_RESISTANCE_LEAD_NEG50K_TO_LEAD_200KOHM,
  PICO_RESISTANCE_LEAD_NEG500K_TO_LEAD_2MOHM,
  PICO_RESISTANCE_LEAD_DIODE_TEST,
  PICO_MAX_RESISTANCE_LEAD_RANGES = (PICO_RESISTANCE_LEAD_DIODE_TEST + 1) - PICO_RESISTANCE_LEAD_NEG50_TO_200OHM,

  PICO_HT_NEG3_TO_5KV = 8950,
  PICO_HT_NEG3_TO_10KV,
  PICO_HT_NEG5_TO_20KV,
  PICO_HT_NEG5_TO_50KV,
  PICO_HT_NEG5_TO_100KV,
  PICO_HT_NEG3_TO_5KV_INVERTED,
  PICO_HT_NEG3_TO_10KV_INVERTED,
  PICO_HT_NEG5_TO_20KV_INVERTED,
  PICO_HT_NEG5_TO_50KV_INVERTED,
  PICO_HT_NEG5_TO_100KV_INVERTED,
  PICO_MAX_HT_RANGES = PICO_HT_NEG5_TO_100KV_INVERTED - PICO_HT_NEG3_TO_5KV + 1,

  PICO_TEMPERATURE_NEG50_TO_150DEGC = 9000,
  PICO_TEMPERATURE_NEG4_TO_125DEGC = 9001,

  PICO_PRESSURE_SENSOR_NEG100000_TO_150000_PASCALS = 9100,
  PICO_PRESSURE_SENSOR_NEG100000_TO_400000_PASCALS = 9101,
  PICO_PRESSURE_SENSOR_NEG200000_TO_800000_PASCALS = 9102,
  PICO_PRESSURE_SENSOR_NEG400000_TO_1600000_PASCALS = 9103,
  PICO_PRESSURE_SENSOR_NEG400000_TO_3400000_PASCALS = 9104,
  PICO_PRESSURE_SENSOR_NEG150000_TO_1350000_PASCALS = 9105,

  PICO_CURRENT_CLAMP_100A_2_5A = 10000,
  PICO_CURRENT_CLAMP_100A_5A,
  PICO_CURRENT_CLAMP_100A_10A,
  PICO_CURRENT_CLAMP_100A_25A,
  PICO_CURRENT_CLAMP_100A_50A,
  PICO_CURRENT_CLAMP_100A_100A,

  PICO_CURRENT_CLAMP_60A_2A = 10500,
  PICO_CURRENT_CLAMP_60A_5A,
  PICO_CURRENT_CLAMP_60A_10A,
  PICO_CURRENT_CLAMP_60A_20A,
  PICO_CURRENT_CLAMP_60A_50A,
  PICO_CURRENT_CLAMP_60A_60A,

  PICO_OPTICAL_SENSOR_10V = 10550,

  PICO_CURRENT_CLAMP_60A_V2_0_5A = 10600,
  PICO_CURRENT_CLAMP_60A_V2_1A,
  PICO_CURRENT_CLAMP_60A_V2_2A,
  PICO_CURRENT_CLAMP_60A_V2_5A,
  PICO_CURRENT_CLAMP_60A_V2_10A,
  PICO_CURRENT_CLAMP_60A_V2_20A,
  PICO_CURRENT_CLAMP_60A_V2_50A,
  PICO_CURRENT_CLAMP_60A_V2_60A,

  PICO_HIGH_VOLTAGE_DIFFERENTIAL_5V = 10650,
  PICO_HIGH_VOLTAGE_DIFFERENTIAL_10V,
  PICO_HIGH_VOLTAGE_DIFFERENTIAL_20V,
  PICO_HIGH_VOLTAGE_DIFFERENTIAL_50V,
  PICO_HIGH_VOLTAGE_DIFFERENTIAL_100V,
  PICO_HIGH_VOLTAGE_DIFFERENTIAL_200V,
  PICO_HIGH_VOLTAGE_DIFFERENTIAL_500V,
  PICO_HIGH_VOLTAGE_DIFFERENTIAL_1000V,
  PICO_HIGH_VOLTAGE_DIFFERENTIAL_1400V,

  PICO_X10_ACTIVE_PROBE_100MV = 10700,
  PICO_X10_ACTIVE_PROBE_200MV,
  PICO_X10_ACTIVE_PROBE_500MV,
  PICO_X10_ACTIVE_PROBE_1V,
  PICO_X10_ACTIVE_PROBE_2V,
  PICO_X10_ACTIVE_PROBE_5V,

} PICO_CONNECT_PROBE_RANGE;

typedef enum enPicoProbeRangeInfo
{
  PICO_PROBE_NONE_NV = 0,
  PICO_X1_PROBE_NV = 1,
  PICO_X10_PROBE_NV = 10,
} PICO_PROBE_RANGE_INFO;
#endif
