#pragma once

// NOTE: the commands in this header are only for WinTest use. If some probe-specific commands are
// going to be available to SDK users and user applications in future, they should be added to a
// separate header (ps4000aApiProbeCommands.h).

#include "ps4000aApi.h"

#if defined(WIN32) && defined(_EXTENSION_LEAD_TEST)

/// <summary>
/// Commands the extension lead test dongle to send its internal temperature back to the device over I2C.
/// This is useful for evaluating extension lead I2C performance (i.e. I2C acceleration)
/// </summary>
/// <param name="handle">The handle to the device to which the test dongle is attached.</param>
/// <param name="channel">The channel on which the test dongle is attached.</param>
/// <param name="temperature">Output parameter for the function, the test dongle internal temp. Only populated if PICO_OK is returned.</param>
/// <returns>
/// A status indicating if the operation was successful.
///
/// PICO_INVALID_HANDLE - the given handle is unknown to the driver or has been closed
/// PICO_DRIVER_FUNCTION - a driver function has been called on another thread
/// PICO_NULL_PARAMETER - the given temperature is a null pointer
/// PICO_NOT_SUPPORTED_BY_THIS_DEVICE - the device associated with this handle does not support
///   intelligent probes
/// PICO_PROBE_COLLECTION_NOT_STARTED - no probe interaction callback is currently set
/// PICO_INVALID_CHANNEL - the specified channel does not exist on the given device
/// PICO_NO_PROBE_CONNECTED_ON_REQUESTED_CHANNEL - there is no intelligent probe currently
///   connected on the given channel
///</returns>
PREF0 PREF1 PICO_STATUS PREF2 PREF3(ps4000aProbeCommand_ExtensionLeadTestDongle_GetTemperature)(int16_t handle,
                                                                                                PICO_CHANNEL channel,
                                                                                                double* temperature);

/// <summary>
/// Commands the extension lead to enable or disable I2C acceleration.
/// </summary>
/// <param name="handle">The handle to the device to which the extension lead is attached.</param>
/// <param name="channel">The channel on which the extension lead is attached.</param>
/// <param name="enableI2cAcceleration">Whether I2C should be enabled on the extension lead.</param>
/// <returns>
/// A status indicating if the operation was successful.
///
/// PICO_INVALID_HANDLE - the given handle is unknown to the driver or has been closed
/// PICO_DRIVER_FUNCTION - a driver function has been called on another thread
/// PICO_NOT_SUPPORTED_BY_THIS_DEVICE - the device associated with this handle does not support
///   intelligent probes
/// PICO_PROBE_COLLECTION_NOT_STARTED - no probe interaction callback is currently set
/// PICO_INVALID_CHANNEL - the specified channel does not exist on the given device
/// PICO_NO_PROBE_CONNECTED_ON_REQUESTED_CHANNEL - there is no intelligent probe currently
///   connected on the given channel
///</returns>
PREF0 PREF1 PICO_STATUS PREF2
  PREF3(ps4000aProbeCommand_ExtensionLeadTestDongle_SetI2cAcceleration)(int16_t handle,
                                                                        PICO_CHANNEL channel,
                                                                        uint8_t enableI2cAcceleration);

#endif

#if defined(WIN32) && defined(_DEBUG)

/// <summary>
///  Sends a probe-specific command to a probe, potentially reading back a response.
/// </summary>
///
/// <param name="handle">The handle to the device to which the probe is attached.</param>
/// <param name="channel">The channel on which the probe is attached.</param>
/// <param name="probe">
///   The probe for which the command is intended. This is to ensure that the expected probe is
///   still the one connected to the channel at the time of sending the command.
/// </param>
/// <param name="range">Range that should be applied</param>
/// <param name="attenuationConfiguration">
///   Selects the attenuation mode for the driver that the probe should operate on.
///   0 corresponds to default x500 attenuator configuration
///   1 corresponds to x50/x500 attenuation configuration
///
///   Users will only have access to fixed x500 attenuator configuration,
///   however for purposes of adjustment in production and debugging,
///   a �debug mode� with x50 / x500 attenuator configuration control is required.
/// </param>
///
/// <returns>
/// A status indicating if the operation was successful.
///
/// PICO_INVALID_HANDLE - the given handle is unknown to the driver or has been closed
/// PICO_DRIVER_FUNCTION - a driver function has been called on another thread
/// PICO_NOT_SUPPORTED_BY_THIS_DEVICE - the device associated with this handle does not support
///   intelligent probes
/// PICO_PROBE_COLLECTION_NOT_STARTED - no probe interaction callback is currently set
/// PICO_INVALID_CHANNEL - the specified channel does not exist on the given device
/// PICO_NO_PROBE_CONNECTED_ON_REQUESTED_CHANNEL - there is no intelligent probe currently
///   connected on the given channel
/// PICO_WARNING_PROBE_CHANNEL_OUT_OF_SYNC - the specified probe is not currently connected
/// PICO_INVALID_VOLTAGE_RANGE - the requested range is not supported by this probe
///   to the given channel
/// </returns>
PREF0 PREF1 PICO_STATUS PREF2
  PREF3(ps4000aProbeCommand_HighVoltage_SetAttenuationVariant)(int16_t handle,
                                                               PICO_CHANNEL channel,
                                                               PICO_CONNECT_PROBE probe,
                                                               PICO_CONNECT_PROBE_RANGE range,
                                                               int16_t attenuationConfiguration);

/// <summary>
///  Reads back the internal die temperature of the high voltage differential probe on the specified channel.
///  Note that this may be inaccurate as to the actual temperature, but can be used to detect changes in temperature.
/// </summary>
///
/// <param name="handle">The handle to the device to which the probe is attached.</param>
/// <param name="channel">The channel on which the probe is attached.</param>
/// <param name="temperature">Output parameter for the function. Only populated if PICO_OK is returned.</param>
///
/// <returns>
/// A status indicating if the operation was successful.
///
/// PICO_INVALID_HANDLE - the given handle is unknown to the driver or has been closed
/// PICO_DRIVER_FUNCTION - a driver function has been called on another thread
/// PICO_NULL_PARAMETER - the given temperature is a null pointer
/// PICO_NOT_SUPPORTED_BY_THIS_DEVICE - the device associated with this handle does not support
///   intelligent probes
/// PICO_PROBE_COLLECTION_NOT_STARTED - no probe interaction callback is currently set
/// PICO_INVALID_CHANNEL - the specified channel does not exist on the given device
/// PICO_NO_PROBE_CONNECTED_ON_REQUESTED_CHANNEL - there is no intelligent probe currently
///   connected on the given channel
/// </returns>
PREF0 PREF1 PICO_STATUS PREF2 PREF3(ps4000aProbeCommand_HighVoltage_ReadProbeInternalTemperature)(int16_t handle,
                                                                                                  PICO_CHANNEL channel,
                                                                                                  double* temperature);

#endif
