/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.animation.progress;

import com.github.ajalt.mordant.animation.RefreshableAnimation;
import com.github.ajalt.mordant.animation.RefreshableAnimationKt;
import com.github.ajalt.mordant.animation.progress.BlockingAnimator;
import com.github.ajalt.mordant.terminal.Terminal;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/github/ajalt/mordant/animation/progress/BaseBlockingAnimator;", "Lcom/github/ajalt/mordant/animation/progress/BlockingAnimator;", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "animation", "Lcom/github/ajalt/mordant/animation/RefreshableAnimation;", "<init>", "(Lcom/github/ajalt/mordant/terminal/Terminal;Lcom/github/ajalt/mordant/animation/RefreshableAnimation;)V", "stopped", "", "lock", "", "runBlocking", "", "stop", "clear", "finished", "getFinished", "()Z", "refresh", "refreshAll", "mordant"})
@SourceDebugExtension(value={"SMAP\nThreadAnimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadAnimator.kt\ncom/github/ajalt/mordant/animation/progress/BaseBlockingAnimator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n1#2:289\n*E\n"})
public final class BaseBlockingAnimator
implements BlockingAnimator {
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final RefreshableAnimation animation;
    private boolean stopped;
    @NotNull
    private final Object lock;

    public BaseBlockingAnimator(@NotNull Terminal terminal, @NotNull RefreshableAnimation animation2) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)animation2, (String)"animation");
        this.terminal = terminal;
        this.animation = animation2;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runBlocking() {
        Object object = this.lock;
        synchronized (object) {
            boolean $i$a$-synchronized-BaseBlockingAnimator$runBlocking$52 = false;
            this.stopped = false;
            this.terminal.getCursor().hide(true);
            Unit $i$a$-synchronized-BaseBlockingAnimator$runBlocking$52 = Unit.INSTANCE;
        }
        while (true) {
            boolean bl;
            object = this.lock;
            synchronized (object) {
                bl = false;
                bl = !this.stopped && !this.animation.getFinished();
            }
            if (!bl) break;
            object = this.lock;
            synchronized (object) {
                boolean $i$a$-synchronized-BaseBlockingAnimator$runBlocking$62 = false;
                this.animation.refresh(false);
                Unit $i$a$-synchronized-BaseBlockingAnimator$runBlocking$62 = Unit.INSTANCE;
            }
            Thread.sleep(Duration.getInWholeMilliseconds-impl((long)RefreshableAnimationKt.getRefreshPeriod(this.animation)));
        }
        object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.stopped) {
                this.animation.refresh(true);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.stopped) {
                this.animation.stop();
                this.terminal.getCursor().show();
                this.stopped = true;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.stopped) {
                this.animation.clear();
                this.terminal.getCursor().show();
                this.stopped = true;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public boolean getFinished() {
        return this.animation.getFinished();
    }

    @Override
    public void refresh(boolean refreshAll) {
        this.animation.refresh(refreshAll);
    }

    @Override
    public int getFps() {
        return BlockingAnimator.DefaultImpls.getFps(this);
    }
}

