/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.preproc;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import processing.mode.java.preproc.SourceUtil;

public class ImportStatement {
    private static final String importKw = "import";
    private static final String staticKw = "static";
    private boolean isStarred;
    private boolean isStatic;
    private String memberName;
    private String packageName;

    private ImportStatement() {
    }

    public static ImportStatement wholePackage(String pckg) {
        ImportStatement is = new ImportStatement();
        is.packageName = pckg;
        is.memberName = "*";
        is.isStarred = true;
        return is;
    }

    public static ImportStatement singleClass(String cls) {
        ImportStatement is = new ImportStatement();
        int lastDot = cls.lastIndexOf(46);
        is.memberName = lastDot >= 0 ? cls.substring(lastDot + 1) : cls;
        is.packageName = lastDot >= 0 ? cls.substring(0, lastDot) : "";
        return is;
    }

    public static ImportStatement parse(String importString) {
        Matcher matcher = SourceUtil.IMPORT_REGEX_NO_KEYWORD.matcher(importString);
        if (!matcher.find()) {
            return null;
        }
        return ImportStatement.parse(matcher.toMatchResult());
    }

    public static ImportStatement parse(MatchResult match) {
        ImportStatement is = new ImportStatement();
        is.isStatic = match.group(2) != null;
        String pckg = match.group(3);
        pckg = pckg == null ? "" : pckg.replaceAll("\\s", "");
        String memberName = match.group(4);
        is.isStarred = memberName.equals("*");
        boolean endsWithPeriod = pckg.endsWith(".");
        if (is.isStatic) {
            String withContainingTypeNameAtEnd = endsWithPeriod ? pckg.substring(0, pckg.length() - 1) : pckg;
            int periodOfContainingTypeName = withContainingTypeNameAtEnd.lastIndexOf(".");
            String containingTypeName = withContainingTypeNameAtEnd.substring(periodOfContainingTypeName + 1);
            is.packageName = withContainingTypeNameAtEnd.substring(0, periodOfContainingTypeName);
            is.memberName = containingTypeName + "." + memberName;
        } else {
            is.packageName = endsWithPeriod ? pckg.substring(0, pckg.length() - 1) : pckg;
            is.memberName = memberName;
        }
        return is;
    }

    public String getFullSourceLine() {
        return "import " + (this.isStatic ? "static " : "") + this.packageName + "." + this.memberName + ";";
    }

    public String getFullMemberName() {
        return this.packageName + "." + this.memberName;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isStarredImport() {
        return this.isStarred;
    }

    public boolean isStaticImport() {
        return this.isStatic;
    }

    public boolean isSameAs(ImportStatement is) {
        return this.packageName.equals(is.packageName) && this.memberName.equals(is.memberName) && this.isStatic == is.isStatic;
    }
}

