/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.lsp;

import java.io.IOException;
import java.net.URI;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.services.WorkspaceService;
import processing.mode.java.lsp.PdeAdapter;
import processing.mode.java.lsp.PdeLanguageServer;

class PdeWorkspaceService
implements WorkspaceService {
    PdeLanguageServer pls;

    PdeWorkspaceService(PdeLanguageServer pls) {
        this.pls = pls;
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        System.out.println("didChangeWatchedFiles: " + String.valueOf(params));
        for (FileEvent change : params.getChanges()) {
            URI uri = URI.create(change.getUri());
            this.pls.getAdapter(uri).ifPresent(adapter -> {
                switch (change.getType()) {
                    case Created: {
                        PdeAdapter.uriToPath(uri).ifPresent(path -> {
                            adapter.sketch.loadNewTab(path.getName(), "pde", true);
                            adapter.notifySketchChanged();
                        });
                        break;
                    }
                    case Changed: {
                        adapter.findCodeByUri(uri).ifPresent(code -> {
                            try {
                                code.load();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            adapter.notifySketchChanged();
                        });
                        break;
                    }
                    case Deleted: {
                        adapter.findCodeByUri(uri).ifPresent(code -> {
                            adapter.sketch.removeCode(code);
                            adapter.notifySketchChanged();
                        });
                    }
                }
            });
        }
    }
}

