/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import processing.mode.java.PreprocSketch;
import processing.mode.java.SketchInterval;

class ShowUsageTreeNode {
    final int tabIndex;
    final int startTabOffset;
    final int stopTabOffset;
    final String text;

    ShowUsageTreeNode(int tabIndex, int startTabOffset, int stopTabOffset, String text) {
        this.tabIndex = tabIndex;
        this.startTabOffset = startTabOffset;
        this.stopTabOffset = stopTabOffset;
        this.text = text;
    }

    static ShowUsageTreeNode fromSketchInterval(PreprocSketch ps, SketchInterval in) {
        int lineStartPdeOffset = ps.pdeCode.lastIndexOf(10, in.startPdeOffset) + 1;
        int lineStopPdeOffset = ps.pdeCode.indexOf(10, in.stopPdeOffset);
        if (lineStopPdeOffset == -1) {
            lineStopPdeOffset = ps.pdeCode.length();
        }
        int highlightStartOffset = in.startPdeOffset - lineStartPdeOffset;
        int highlightStopOffset = in.stopPdeOffset - lineStartPdeOffset;
        int tabLine = ps.tabOffsetToTabLine(in.tabIndex, in.startTabOffset);
        Object line = ps.pdeCode.substring(lineStartPdeOffset, lineStopPdeOffset);
        String pre = ((String)line).substring(0, highlightStartOffset).replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
        String highlight = ((String)line).substring(highlightStartOffset, highlightStopOffset).replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
        String post = ((String)line).substring(highlightStopOffset).replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
        line = pre + "<font color=#222222><b>" + highlight + "</b></font>" + post;
        line = ((String)line).trim();
        String text = "<html><font color=#bbbbbb>" + (tabLine + 1) + "</font> <font color=#777777>" + (String)line + "</font></html>";
        return new ShowUsageTreeNode(in.tabIndex, in.startTabOffset, in.stopTabOffset, text);
    }

    public String toString() {
        return this.text;
    }
}

