/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import processing.app.Base;
import processing.app.Formatter;
import processing.app.Language;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Problem;
import processing.app.ReferenceServer;
import processing.app.RunnerListener;
import processing.app.RunnerListenerEdtAdapter;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.Util;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ToolContribution;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeTextAreaDefaults;
import processing.app.syntax.TextAreaDefaults;
import processing.app.ui.About;
import processing.app.ui.Editor;
import processing.app.ui.EditorException;
import processing.app.ui.EditorFooter;
import processing.app.ui.EditorHeader;
import processing.app.ui.EditorState;
import processing.app.ui.EditorToolbar;
import processing.app.ui.ExportPrompt;
import processing.app.ui.Toolkit;
import processing.app.ui.Welcome;
import processing.core.PApplet;
import processing.data.StringList;
import processing.mode.java.ASTViewer;
import processing.mode.java.AutoFormat;
import processing.mode.java.ErrorChecker;
import processing.mode.java.InspectMode;
import processing.mode.java.JavaMode;
import processing.mode.java.JavaProblem;
import processing.mode.java.JavaTextArea;
import processing.mode.java.JavaToolbar;
import processing.mode.java.PreprocService;
import processing.mode.java.Rename;
import processing.mode.java.ShowUsage;
import processing.mode.java.debug.Debugger;
import processing.mode.java.debug.LineBreakpoint;
import processing.mode.java.debug.LineHighlight;
import processing.mode.java.debug.LineID;
import processing.mode.java.preproc.ImportStatement;
import processing.mode.java.preproc.PdePreprocessor;
import processing.mode.java.preproc.SourceUtil;
import processing.mode.java.runner.Runner;
import processing.mode.java.tweak.ColorControlBox;
import processing.mode.java.tweak.Handle;
import processing.mode.java.tweak.SketchParser;
import processing.mode.java.tweak.TweakClient;

public class JavaEditor
extends Editor {
    JavaMode jmode;
    private Runner runtime;
    private boolean runtimeLaunchRequested;
    private final Object runtimeLock = new Object[0];
    protected final List<LineHighlight> breakpointedLines = new ArrayList<LineHighlight>();
    protected LineHighlight currentLine;
    protected final String breakpointMarkerComment = " //<>//";
    JMenu modeMenu;
    protected PreprocService preprocService;
    protected Debugger debugger;
    private final InspectMode inspect;
    private final ShowUsage usage;
    private final Rename rename;
    private final ErrorChecker errorChecker;
    private static final boolean SHOW_AST_VIEWER = false;
    private ASTViewer astViewer;
    static final int REFERENCE_PORT = 8053;
    static final String REFERENCE_URL = "https://github.com/processing/processing4/releases/tag/processing-1300-4.4.0";
    static final String REFERENCE_URL_2 = "https://github.com/processing/processing4/releases/download/processing-1300-4.4.0/processing-4.4.0-reference.zip";
    Boolean useReferenceServer;
    ReferenceServer referenceServer;
    private int previousTabCount = 1;
    JFrame frmImportSuggest;
    static final String PREF_TWEAK_PORT = "tweak.port";
    static final String PREF_TWEAK_SHOW_CODE = "tweak.showcode";
    public String[] baseCode;
    TweakClient tweakClient;

    protected JavaEditor(Base base, String path, EditorState state, Mode mode) throws EditorException {
        super(base, path, state, mode);
        this.jmode = (JavaMode)mode;
        this.debugger = new Debugger(this);
        this.debugger.populateMenu(this.modeMenu);
        for (LineID lineID : this.stripBreakpointComments()) {
            this.debugger.setBreakpoint(lineID);
        }
        this.getSketch().setModified(false);
        this.preprocService = new PreprocService(this.jmode, this.sketch);
        this.usage = new ShowUsage(this, this.preprocService);
        this.inspect = new InspectMode(this, this.preprocService, this.usage);
        this.rename = new Rename(this, this.preprocService, this.usage);
        this.errorChecker = new ErrorChecker(arg_0 -> ((JavaEditor)this).setProblemList(arg_0), this.preprocService);
        for (SketchCode code : this.getSketch().getCode()) {
            Document document = code.getDocument();
            this.addDocumentListener(document);
        }
        this.sketchChanged();
        Toolkit.setMenuMnemonics((JPopupMenu)this.textarea.getRightClickPopup());
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                JavaEditor.this.getJavaTextArea().hideSuggestion();
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        });
    }

    public PdePreprocessor createPreprocessor(String sketchName) {
        return PdePreprocessor.builderFor((String)sketchName).build();
    }

    protected JEditTextArea createTextArea() {
        return new JavaTextArea((TextAreaDefaults)new PdeTextAreaDefaults(), this);
    }

    public EditorToolbar createToolbar() {
        return new JavaToolbar(this);
    }

    public EditorHeader createHeader() {
        return new EditorHeader(this){

            public void rebuild() {
                int currentTabCount;
                super.rebuild();
                if (JavaEditor.this.preprocService != null && (currentTabCount = JavaEditor.this.sketch.getCodeCount()) != JavaEditor.this.previousTabCount) {
                    JavaEditor.this.previousTabCount = currentTabCount;
                    JavaEditor.this.sketchChanged();
                }
            }
        };
    }

    public EditorFooter createFooter() {
        EditorFooter footer = super.createFooter();
        this.addErrorTable(footer);
        return footer;
    }

    public Formatter createFormatter() {
        return new AutoFormat();
    }

    public JMenu buildFileMenu() {
        String appTitle = Language.text((String)"menu.file.export_application");
        JMenuItem exportApplication = Toolkit.newJMenuItemShift((String)appTitle, (int)69);
        exportApplication.addActionListener(e -> {
            if (this.sketch.isUntitled() || this.sketch.isReadOnly()) {
                Messages.showMessage((String)"Save First", (String)"Please first save the sketch.");
            } else {
                this.handleExportApplication();
            }
        });
        JMenuItem exportPDEZ = new JMenuItem(Language.text((String)"menu.file.export_pdez"));
        exportPDEZ.addActionListener(e -> {
            if (this.sketch.isUntitled() || this.sketch.isReadOnly()) {
                Messages.showMessage((String)"Save First", (String)"Please first save the sketch.");
            } else {
                this.handleExportPDEZ();
            }
        });
        return this.buildFileMenu(new JMenuItem[]{exportApplication, exportPDEZ});
    }

    public JMenu buildSketchMenu() {
        JMenuItem runItem = Toolkit.newJMenuItem((String)Language.text((String)"menu.sketch.run"), (int)82);
        runItem.addActionListener(e -> this.handleRun());
        JMenuItem presentItem = Toolkit.newJMenuItemShift((String)Language.text((String)"menu.sketch.present"), (int)82);
        presentItem.addActionListener(e -> this.handlePresent());
        JMenuItem stopItem = new JMenuItem(Language.text((String)"menu.sketch.stop"));
        stopItem.addActionListener(e -> {
            if (this.isDebuggerEnabled()) {
                Messages.log((String)"Invoked 'Stop' menu item");
                this.debugger.stopDebug();
            } else {
                this.handleStop();
            }
        });
        JMenuItem tweakItem = Toolkit.newJMenuItemShift((String)Language.text((String)"menu.sketch.tweak"), (int)84);
        tweakItem.addActionListener(e -> this.handleTweak());
        return this.buildSketchMenu(new JMenuItem[]{runItem, presentItem, tweakItem, stopItem});
    }

    public JMenu buildHelpMenu() {
        boolean contribToolMenuItemAdded;
        boolean isContribLibMenuItemAdded;
        JMenuItem item;
        JMenu menu = new JMenu(Language.text((String)"menu.help"));
        if (!Platform.isMacOS()) {
            item = new JMenuItem(Language.text((String)"menu.help.about"));
            item.addActionListener(e -> new About((Frame)((Object)this)));
            menu.add(item);
        }
        item = new JMenuItem(Language.text((String)"menu.help.welcome"));
        item.addActionListener(e -> {
            try {
                new Welcome(this.base);
            }
            catch (IOException ioe) {
                Messages.showWarning((String)"Unwelcome Error", (String)"Please report this error to\nhttps://github.com/processing/processing4/issues", (Throwable)ioe);
            }
        });
        menu.add(item);
        item = new JMenuItem(Language.text((String)"menu.help.environment"));
        item.addActionListener(e -> this.showReference("../environment/index.html"));
        menu.add(item);
        item = new JMenuItem(Language.text((String)"menu.help.reference"));
        item.addActionListener(e -> this.showReference("index.html"));
        menu.add(item);
        item = Toolkit.newJMenuItemShift((String)Language.text((String)"menu.help.find_in_reference"), (int)70);
        item.addActionListener(e -> {
            if (this.textarea.isSelectionActive()) {
                this.handleFindReference();
            } else {
                this.statusNotice(Language.text((String)"editor.status.find_reference.select_word_first"));
            }
        });
        menu.add(item);
        item = new JMenuItem(Language.text((String)"menu.help.reference.download"));
        item.addActionListener(e -> new Thread(this::downloadReference).start());
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(Language.text((String)"menu.help.report"));
        item.addActionListener(e -> Platform.openURL((String)Language.text((String)"menu.help.report.url")));
        menu.add(item);
        item = new JMenuItem(Language.text((String)"menu.help.ask"));
        item.addActionListener(e -> Platform.openURL((String)Language.text((String)"menu.help.ask.url")));
        menu.add(item);
        menu.addSeparator();
        JMenu libRefSubmenu = new JMenu(Language.text((String)"menu.help.libraries_reference"));
        boolean isCoreLibMenuItemAdded = this.addLibReferencesToSubMenu(this.mode.coreLibraries, libRefSubmenu);
        if (isCoreLibMenuItemAdded && !this.mode.contribLibraries.isEmpty()) {
            libRefSubmenu.addSeparator();
        }
        if (!(isContribLibMenuItemAdded = this.addLibReferencesToSubMenu(this.mode.contribLibraries, libRefSubmenu)) && !isCoreLibMenuItemAdded) {
            JMenuItem emptyMenuItem = new JMenuItem(Language.text((String)"menu.help.empty"));
            emptyMenuItem.setEnabled(false);
            emptyMenuItem.setFocusable(false);
            emptyMenuItem.setFocusPainted(false);
            libRefSubmenu.add(emptyMenuItem);
        } else if (!isContribLibMenuItemAdded && !this.mode.coreLibraries.isEmpty()) {
            libRefSubmenu.removeAll();
            this.addLibReferencesToSubMenu(this.mode.coreLibraries, libRefSubmenu);
        }
        menu.add(libRefSubmenu);
        JMenu toolRefSubmenu = new JMenu(Language.text((String)"menu.help.tools_reference"));
        List contribTools = this.base.getContribTools();
        boolean coreToolMenuItemAdded = this.addToolReferencesToSubMenu(this.base.getCoreTools(), toolRefSubmenu);
        if (coreToolMenuItemAdded && !contribTools.isEmpty()) {
            toolRefSubmenu.addSeparator();
        }
        if (!(contribToolMenuItemAdded = this.addToolReferencesToSubMenu(contribTools, toolRefSubmenu)) && !coreToolMenuItemAdded) {
            toolRefSubmenu.removeAll();
            JMenuItem emptyMenuItem = new JMenuItem(Language.text((String)"menu.help.empty"));
            emptyMenuItem.setEnabled(false);
            emptyMenuItem.setBorderPainted(false);
            emptyMenuItem.setFocusable(false);
            emptyMenuItem.setFocusPainted(false);
            toolRefSubmenu.add(emptyMenuItem);
        } else if (!contribToolMenuItemAdded && !contribTools.isEmpty()) {
            toolRefSubmenu.removeAll();
            this.addToolReferencesToSubMenu(this.base.getCoreTools(), toolRefSubmenu);
        }
        menu.add(toolRefSubmenu);
        menu.addSeparator();
        item = new JMenuItem(Language.text((String)"menu.help.getting_started"));
        item.addActionListener(e -> Platform.openURL((String)Language.text((String)"menu.help.getting_started.url")));
        menu.add(item);
        item = new JMenuItem(Language.text((String)"menu.help.troubleshooting"));
        item.addActionListener(e -> Platform.openURL((String)Language.text((String)"menu.help.troubleshooting.url")));
        menu.add(item);
        item = new JMenuItem(Language.text((String)"menu.help.faq"));
        item.addActionListener(e -> Platform.openURL((String)Language.text((String)"menu.help.faq.url")));
        menu.add(item);
        item = new JMenuItem(Language.text((String)"menu.help.foundation"));
        item.addActionListener(e -> Platform.openURL((String)Language.text((String)"menu.help.foundation.url")));
        menu.add(item);
        item = new JMenuItem(Language.text((String)"menu.help.visit"));
        item.addActionListener(e -> Platform.openURL((String)Language.text((String)"menu.help.visit.url")));
        menu.add(item);
        return menu;
    }

    private boolean addLibReferencesToSubMenu(List<Library> libsList, JMenu subMenu) {
        boolean isItemAdded = false;
        for (Library libContrib : libsList) {
            if (!libContrib.hasReference()) continue;
            JMenuItem libRefItem = new JMenuItem(libContrib.getName());
            libRefItem.addActionListener(arg0 -> this.showReferenceFile(libContrib.getReferenceIndexFile()));
            subMenu.add(libRefItem);
            isItemAdded = true;
        }
        return isItemAdded;
    }

    private boolean addToolReferencesToSubMenu(List<ToolContribution> toolsList, JMenu subMenu) {
        boolean isItemAdded = false;
        for (ToolContribution toolContrib : toolsList) {
            File toolRef = new File(toolContrib.getFolder(), "reference/index.html");
            if (!toolRef.exists()) continue;
            JMenuItem libRefItem = new JMenuItem(toolContrib.getName());
            libRefItem.addActionListener(arg0 -> this.showReferenceFile(toolRef));
            subMenu.add(libRefItem);
            isItemAdded = true;
        }
        return isItemAdded;
    }

    public String getCommentPrefix() {
        return "//";
    }

    public void handleExportApplication() {
        if (this.handleExportCheckModified()) {
            this.statusNotice(Language.text((String)"export.notice.exporting"));
            ExportPrompt ep = new ExportPrompt((Editor)this, () -> {
                try {
                    if (this.jmode.handleExportApplication(this.getSketch())) {
                        Platform.openFolder((File)this.sketch.getFolder());
                        this.statusNotice(Language.text((String)"export.notice.exporting.done"));
                    }
                }
                catch (Exception e) {
                    this.statusNotice(Language.text((String)"export.notice.exporting.error"));
                    e.printStackTrace();
                }
            });
            ep.trigger();
        }
    }

    public void handleExportPDEZ() {
        if (this.handleExportCheckModified()) {
            Sketch sketch = this.getSketch();
            Path folder = sketch.getFolder().toPath();
            Path target = new File(String.valueOf(folder) + ".pdez").toPath();
            if (Files.exists(target, new LinkOption[0])) {
                try {
                    Platform.deleteFile((File)target.toFile());
                }
                catch (IOException e) {
                    Messages.showError((String)"Export Error", (String)("Could not delete existing file: " + String.valueOf(target)), (Throwable)e);
                }
            }
            try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(target, new OpenOption[0]));){
                Files.walk(folder, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                    ZipEntry zipEntry = new ZipEntry(folder.getParent().relativize((Path)path).toString());
                    try {
                        zs.putNextEntry(zipEntry);
                        Files.copy(path, zs);
                        zs.closeEntry();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                if (desktop.isSupported(Desktop.Action.BROWSE_FILE_DIR)) {
                    desktop.browseFileDirectory(target.toFile());
                } else {
                    try {
                        desktop.open(target.getParent().toFile());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    protected boolean handleExportCheckModified() {
        if (this.sketch.isReadOnly()) {
            Messages.showMessage((String)Language.text((String)"export.messages.is_read_only"), (String)Language.text((String)"export.messages.is_read_only.description"));
            return false;
        }
        if (this.sketch.isUntitled()) {
            Messages.showMessage((String)Language.text((String)"export.messages.cannot_export"), (String)Language.text((String)"export.messages.cannot_export.description"));
            return false;
        }
        if (this.sketch.isModified()) {
            Object[] options = new Object[]{Language.text((String)"prompt.ok"), Language.text((String)"prompt.cancel")};
            int result = JOptionPane.showOptionDialog((Component)((Object)this), Language.text((String)"export.unsaved_changes"), Language.text((String)"menu.file.save"), 2, 3, null, options, options[0]);
            if (result == 0) {
                this.handleSave(true);
            } else {
                this.statusNotice(Language.text((String)"export.notice.cancel.unsaved_changes"));
                return false;
            }
        }
        return true;
    }

    public void handleRun() {
        if (this.isDebuggerEnabled()) {
            if (this.debugger.isStarted()) {
                this.debugger.stopDebug();
            }
            this.debugger.continueDebug();
        } else {
            this.handleLaunch(false, false);
        }
    }

    public void handlePresent() {
        this.handleLaunch(true, false);
    }

    public void handleTweak() {
        this.autoSave();
        if (this.sketch.isModified()) {
            Messages.showMessage((String)Language.text((String)"menu.file.save"), (String)Language.text((String)"tweak_mode.save_before_tweak"));
            return;
        }
        this.handleLaunch(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLaunch(boolean present, boolean tweak) {
        this.prepareRun();
        this.toolbar.activateRun();
        Object object = this.runtimeLock;
        synchronized (object) {
            this.runtimeLaunchRequested = true;
        }
        new Thread(() -> {
            try {
                Object object = this.runtimeLock;
                synchronized (object) {
                    if (this.runtimeLaunchRequested) {
                        this.runtimeLaunchRequested = false;
                        RunnerListenerEdtAdapter listener = new RunnerListenerEdtAdapter((RunnerListener)this);
                        this.runtime = !tweak ? this.jmode.handleLaunch(this.sketch, (RunnerListener)listener, present) : this.jmode.handleTweak(this.sketch, (RunnerListener)listener, this);
                    }
                }
            }
            catch (Exception e) {
                EventQueue.invokeLater(() -> this.statusError(e));
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleStop() {
        if (this.debugger.isStarted()) {
            this.debugger.stopDebug();
        } else {
            this.toolbar.activateStop();
            try {
                Object object = this.runtimeLock;
                synchronized (object) {
                    if (this.runtimeLaunchRequested) {
                        this.runtimeLaunchRequested = false;
                    }
                    if (this.runtime != null) {
                        this.runtime.close();
                        this.runtime = null;
                    }
                }
            }
            catch (Exception e) {
                this.statusError(e);
            }
            this.toolbar.deactivateStop();
            this.toolbar.deactivateRun();
            this.toFront();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRunnerExiting(Runner runner) {
        Object object = this.runtimeLock;
        synchronized (object) {
            if (this.runtime == runner) {
                this.deactivateRun();
            }
        }
    }

    public void toggleBreakpoint(int lineIndex) {
        this.debugger.toggleBreakpoint(lineIndex);
    }

    public boolean handleSaveAs() {
        String oldName = this.getSketch().getCode(0).getFileName();
        boolean saved = super.handleSaveAs();
        if (saved) {
            List<LineBreakpoint> bps = this.debugger.getBreakpoints(oldName);
            this.debugger.clearBreakpoints(oldName);
            String newName = this.getSketch().getCode(0).getFileName();
            for (LineBreakpoint bp : bps) {
                LineID line = new LineID(newName, bp.lineID().lineIdx());
                this.debugger.setBreakpoint(line);
            }
            for (SketchCode code : this.getSketch().getCode()) {
                this.addBreakpointComments(code.getFileName());
            }
        }
        return saved;
    }

    public void handleImportLibrary(String libraryName) {
        Library lib;
        this.sketch.ensureExistence();
        if (this.mode.isDefaultExtension(this.sketch.getCurrentCode())) {
            this.sketch.setCurrentCode(0);
        }
        if ((lib = this.mode.findLibraryByName(libraryName)) == null) {
            this.statusError("Unable to locate library: " + libraryName);
            return;
        }
        StringList list = lib.getImports();
        if (list == null) {
            list = Util.packageListFromClassPath((String)lib.getJarPath());
        }
        StringBuilder sb = new StringBuilder();
        for (String item : list) {
            sb.append("import ");
            sb.append(item);
            sb.append(".*;\n");
        }
        sb.append('\n');
        sb.append(this.getText());
        this.setText(sb.toString());
        this.setSelection(0, 0);
        this.sketch.setModified(true);
    }

    public void librariesChanged() {
        this.preprocService.notifyLibrariesChanged();
    }

    public void codeFolderChanged() {
        this.preprocService.notifyCodeFolderChanged();
    }

    public void sketchChanged() {
        this.errorChecker.notifySketchChanged();
        this.preprocService.notifySketchChanged();
    }

    public void addDocumentListener(Document doc) {
        if (doc != null) {
            doc.addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    JavaEditor.this.sketchChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    JavaEditor.this.sketchChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    JavaEditor.this.sketchChanged();
                }
            });
        }
    }

    public void showReference(String name) {
        if (this.useReferenceServer == null) {
            File referenceZip = new File(this.mode.getFolder(), "reference.zip");
            if (!referenceZip.exists()) {
                referenceZip = this.getOfflineReferenceFile();
            }
            if (referenceZip.exists()) {
                try {
                    this.referenceServer = new ReferenceServer(referenceZip, 8053);
                    this.useReferenceServer = true;
                }
                catch (IOException e) {
                    Messages.showWarning((String)"Reference Server Problem", (String)"Error while starting the documentation server.");
                }
            } else {
                this.useReferenceServer = false;
            }
        }
        if (this.useReferenceServer.booleanValue()) {
            String url = this.referenceServer.getPrefix() + "reference/" + name;
            Platform.openURL((String)url);
        } else {
            File file = new File(this.mode.getReferenceFolder(), name);
            if (file.exists()) {
                this.showReferenceFile(file);
            } else {
                Platform.openURL((String)("https://processing.org/reference/" + name));
            }
        }
    }

    private File getOfflineReferenceFile() {
        return new File(Base.getSketchbookFolder(), "reference.zip");
    }

    private String getReferenceDownloadUrl() {
        String versionName = Base.getVersionName();
        int revisionInt = Base.getRevision();
        String revision = String.valueOf(revisionInt);
        if ("unspecified".equals(versionName) || revisionInt == Integer.MAX_VALUE) {
            return REFERENCE_URL_2;
        }
        String url = String.format("https://github.com/processing/processing4/releases/download/processing-%s-%s/processing-%s-reference.zip", revision, versionName, versionName);
        System.out.println("Generated URL: " + url);
        return url;
    }

    private void downloadReference() {
        try {
            URL source = new URL(this.getReferenceDownloadUrl());
            HttpURLConnection conn = (HttpURLConnection)source.openConnection();
            HttpURLConnection.setFollowRedirects(true);
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(60000);
            conn.setRequestMethod("GET");
            conn.connect();
            int length = conn.getContentLength();
            String mb = PApplet.nf((float)((float)(length >> 10) / 1024.0f), (int)0, (int)1);
            if (mb.endsWith(".0")) {
                mb = mb.substring(0, mb.length() - 2);
            }
            ProgressMonitorInputStream input = new ProgressMonitorInputStream((Component)((Object)this), "Downloading reference (" + mb + " MB)\u2026 ", conn.getInputStream());
            input.getProgressMonitor().setMaximum(length);
            PApplet.saveStream((File)this.getOfflineReferenceFile(), (InputStream)input);
            this.useReferenceServer = null;
        }
        catch (InterruptedIOException source) {
        }
        catch (IOException e) {
            Messages.showWarning((String)"Error downloading reference", (String)"Could not download the reference. Try again later.", (Throwable)e);
        }
    }

    public void statusError(String what) {
        super.statusError(what);
        this.toolbar.deactivateRun();
    }

    public void internalCloseRunner() {
        this.handleStop();
    }

    public void dispose() {
        if (this.debugger.isEnabled()) {
            this.debugger.stopDebug();
        }
        this.debugger.dispose();
        this.preprocService.dispose();
        this.inspect.dispose();
        this.usage.dispose();
        this.rename.dispose();
        this.errorChecker.dispose();
        if (this.astViewer != null) {
            this.astViewer.dispose();
        }
        super.dispose();
    }

    public boolean isDebuggerEnabled() {
        return this.debugger.isEnabled();
    }

    public JMenu buildModeMenu() {
        this.modeMenu = new JMenu(Language.text((String)"menu.debug"));
        return this.modeMenu;
    }

    protected List<LineID> stripBreakpointComments() {
        ArrayList<LineID> bps = new ArrayList<LineID>();
        Sketch sketch = this.getSketch();
        for (int i = 0; i < sketch.getCodeCount(); ++i) {
            SketchCode tab = sketch.getCode(i);
            String code = tab.getProgram();
            String[] lines = code.split("\\r?\\n");
            int lineIdx = 0;
            for (String line : lines) {
                if (line.endsWith(" //<>//")) {
                    LineID lineID = new LineID(tab.getFileName(), lineIdx);
                    bps.add(lineID);
                    int index = line.lastIndexOf(" //<>//");
                    lines[lineIdx] = line.substring(0, index);
                }
                ++lineIdx;
            }
            code = PApplet.join((String[])lines, (String)"\n");
            this.setTabContents(tab.getFileName(), code);
        }
        return bps;
    }

    protected void addBreakpointComments(String tabFilename) {
        SketchCode tab = this.getTab(tabFilename);
        if (tab == null) {
            Messages.err((String)("Illegal tab name to addBreakpointComments() " + tabFilename));
            return;
        }
        List<LineBreakpoint> bps = this.debugger.getBreakpoints(tab.getFileName());
        try {
            tab.load();
            String code = tab.getProgram();
            String[] lines = code.split("\\r?\\n");
            for (LineBreakpoint bp : bps) {
                int n = bp.lineID().lineIdx();
                lines[n] = lines[n] + " //<>//";
            }
            code = PApplet.join((String[])lines, (String)"\n");
            tab.setProgram(code);
            tab.save();
        }
        catch (IOException ex) {
            Messages.err(null, (Throwable)ex);
        }
    }

    public boolean handleSave(boolean immediately) {
        ArrayList<String> modified = new ArrayList<String>();
        for (int i = 0; i < this.getSketch().getCodeCount(); ++i) {
            SketchCode tab = this.getSketch().getCode(i);
            if (!tab.isModified()) continue;
            modified.add(tab.getFileName());
        }
        boolean saved = super.handleSave(immediately);
        if (saved) {
            if (immediately) {
                for (String tabFilename : modified) {
                    this.addBreakpointComments(tabFilename);
                }
            } else {
                EventQueue.invokeLater(() -> {
                    for (String tabFilename : modified) {
                        this.addBreakpointComments(tabFilename);
                    }
                });
            }
        }
        return saved;
    }

    protected void setTabContents(String tabFilename, String code) {
        this.debugger.clearBreakpoints(tabFilename);
        SketchCode currentTab = this.getCurrentTab();
        SketchCode tab = this.getTab(tabFilename);
        if (tab != null) {
            tab.setProgram(code);
            tab.setDocument(null);
            this.setCode(tab);
            this.setCode(currentTab);
        }
    }

    public void clearConsole() {
        this.console.clear();
    }

    public void clearSelection() {
        this.setSelection(this.getCaretOffset(), this.getCaretOffset());
    }

    public void selectLine(int lineIdx) {
        this.setSelection(this.getLineStartOffset(lineIdx), this.getLineStopOffset(lineIdx));
    }

    public void cursorToLineStart(int lineIdx) {
        this.setSelection(this.getLineStartOffset(lineIdx), this.getLineStartOffset(lineIdx));
    }

    public void cursorToLineEnd(int lineIdx) {
        this.setSelection(this.getLineStopOffset(lineIdx), this.getLineStopOffset(lineIdx));
    }

    public void switchToTab(String tabFileName) {
        Sketch s = this.getSketch();
        for (int i = 0; i < s.getCodeCount(); ++i) {
            if (!tabFileName.equals(s.getCode(i).getFileName())) continue;
            s.setCurrentCode(i);
            break;
        }
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public JavaTextArea getJavaTextArea() {
        return (JavaTextArea)this.textarea;
    }

    public PreprocService getPreprocessingService() {
        return this.preprocService;
    }

    public void prepareRun() {
        this.autoSave();
        super.prepareRun();
        this.downloadImports();
        this.preprocService.cancel();
    }

    protected void downloadImports() {
        for (SketchCode sc : this.sketch.getCode()) {
            String tabCode;
            List imports;
            if (!sc.isExtension("pde") || (imports = SourceUtil.parseProgramImports((CharSequence)(tabCode = sc.getProgram()))).isEmpty()) continue;
            ArrayList<String> importHeaders = new ArrayList<String>();
            for (ImportStatement importStatement : imports) {
                importHeaders.add(importStatement.getFullMemberName());
            }
            List<AvailableContribution> installLibsHeaders = this.getNotInstalledAvailableLibs(importHeaders);
            if (installLibsHeaders.isEmpty()) continue;
            StringBuilder libList = new StringBuilder("Would you like to install them now?");
            for (AvailableContribution ac : installLibsHeaders) {
                libList.append("\n  \u2022 ").append(ac.getName());
            }
            int option = Messages.showYesNoQuestion((Frame)((Object)this), (String)Language.text((String)"contrib.import.dialog.title"), (String)Language.text((String)"contrib.import.dialog.primary_text"), (String)libList.toString());
            if (option != 0) continue;
            ContributionManager.downloadAndInstallOnImport((Base)this.base, installLibsHeaders);
        }
    }

    private List<AvailableContribution> getNotInstalledAvailableLibs(List<String> importHeadersList) {
        Map importMap = ContributionListing.getInstance().getLibraryExports();
        ArrayList<AvailableContribution> libList = new ArrayList<AvailableContribution>();
        for (String importHeaders : importHeadersList) {
            int dot = importHeaders.lastIndexOf(46);
            String entry = dot == -1 ? importHeaders : importHeaders.substring(0, dot);
            if (entry.startsWith("java.") || entry.startsWith("javax.") || entry.startsWith("processing.")) continue;
            try {
                Contribution c;
                Library library = this.getMode().getLibrary(entry);
                if (library != null || !((c = (Contribution)importMap.get(importHeaders)) instanceof AvailableContribution)) continue;
                libList.add((AvailableContribution)c);
            }
            catch (Exception e) {
                Contribution c = (Contribution)importMap.get(importHeaders);
                if (!(c instanceof AvailableContribution)) continue;
                libList.add((AvailableContribution)c);
            }
        }
        return libList;
    }

    protected void autoSave() {
        if (!JavaMode.autoSaveEnabled) {
            return;
        }
        try {
            if (this.sketch.isModified() && !this.sketch.isUntitled()) {
                if (JavaMode.autoSavePromptEnabled) {
                    JDialog autoSaveDialog = new JDialog((Frame)this.base.getActiveEditor(), this.getSketch().getName(), true);
                    Container container = autoSaveDialog.getContentPane();
                    JPanel panelMain = new JPanel();
                    panelMain.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 2));
                    panelMain.setLayout(new BoxLayout(panelMain, 3));
                    JPanel panelLabel = new JPanel(new FlowLayout(0));
                    JLabel label = new JLabel("<html><body>&nbsp;There are unsaved changes in your sketch.<br />&nbsp;&nbsp;&nbsp; Do you want to save it before running? </body></html>");
                    label.setFont(new Font(label.getFont().getName(), 0, Toolkit.zoom((int)(label.getFont().getSize() + 1))));
                    panelLabel.add(label);
                    panelMain.add(panelLabel);
                    JCheckBox dontRedisplay = new JCheckBox("Remember this decision");
                    JPanel panelButtons = new JPanel(new FlowLayout(1, 8, 2));
                    JButton btnRunSave = new JButton("Save and Run");
                    btnRunSave.addActionListener(e -> {
                        this.handleSave(true);
                        if (dontRedisplay.isSelected()) {
                            JavaMode.autoSavePromptEnabled = !dontRedisplay.isSelected();
                            JavaMode.defaultAutoSaveEnabled = true;
                            this.jmode.savePreferences();
                        }
                        autoSaveDialog.dispose();
                    });
                    panelButtons.add(btnRunSave);
                    JButton btnRunNoSave = new JButton("Run, Don't Save");
                    btnRunNoSave.addActionListener(e -> {
                        if (dontRedisplay.isSelected()) {
                            JavaMode.autoSavePromptEnabled = !dontRedisplay.isSelected();
                            JavaMode.defaultAutoSaveEnabled = false;
                            this.jmode.savePreferences();
                        }
                        autoSaveDialog.dispose();
                    });
                    panelButtons.add(btnRunNoSave);
                    panelMain.add(panelButtons);
                    JPanel panelCheck = new JPanel();
                    panelCheck.setLayout(new FlowLayout(1, 0, 0));
                    panelCheck.add(dontRedisplay);
                    panelMain.add(panelCheck);
                    container.add(panelMain);
                    autoSaveDialog.setResizable(false);
                    autoSaveDialog.pack();
                    autoSaveDialog.setLocationRelativeTo((Component)this.base.getActiveEditor());
                    autoSaveDialog.setVisible(true);
                } else if (JavaMode.defaultAutoSaveEnabled) {
                    this.handleSave(true);
                }
            }
        }
        catch (Exception e2) {
            this.statusError(e2);
        }
    }

    public void activateRun() {
        this.debugger.enableMenuItem(false);
        this.toolbar.activateRun();
    }

    public void deactivateRun() {
        this.toolbar.deactivateRun();
        this.debugger.enableMenuItem(true);
    }

    public void activateContinue() {
        ((JavaToolbar)this.toolbar).activateContinue();
    }

    public void deactivateContinue() {
        ((JavaToolbar)this.toolbar).deactivateContinue();
    }

    public void activateStep() {
        ((JavaToolbar)this.toolbar).activateStep();
    }

    public void deactivateStep() {
        ((JavaToolbar)this.toolbar).deactivateStep();
    }

    public void toggleDebug() {
        this.debugger.toggleEnabled();
        this.rebuildToolbar();
        this.repaint();
    }

    public void setCurrentLine(LineID line) {
        this.clearCurrentLine();
        if (line == null) {
            return;
        }
        this.switchToTab(line.fileName());
        this.cursorToLineStart(line.lineIdx());
        this.currentLine = new LineHighlight(line.lineIdx(), this);
        this.currentLine.setMarker("->");
        this.currentLine.setPriority(10);
    }

    public void clearCurrentLine() {
        if (this.currentLine != null) {
            this.currentLine.clear();
            this.currentLine.dispose();
            for (LineHighlight hl : this.breakpointedLines) {
                if (!hl.getLineID().equals(this.currentLine.getLineID())) continue;
                hl.paint();
                break;
            }
            this.currentLine = null;
        }
    }

    public void addBreakpointedLine(LineID lineID) {
        LineHighlight hl = new LineHighlight(lineID, this);
        hl.setMarker("<>");
        this.breakpointedLines.add(hl);
        if (this.currentLine != null && this.currentLine.getLineID().equals(lineID)) {
            this.currentLine.paint();
        }
    }

    public void removeBreakpointedLine(int lineIdx) {
        LineID line = this.getLineIDInCurrentTab(lineIdx);
        LineHighlight foundLine = null;
        for (LineHighlight hl : this.breakpointedLines) {
            if (!hl.getLineID().equals(line)) continue;
            foundLine = hl;
            break;
        }
        if (foundLine != null) {
            foundLine.clear();
            this.breakpointedLines.remove(foundLine);
            foundLine.dispose();
            if (this.currentLine != null && this.currentLine.getLineID().equals(line)) {
                this.currentLine.paint();
            }
        }
    }

    public LineID getLineIDInCurrentTab(int lineIdx) {
        return new LineID(this.getSketch().getCurrentCode().getFileName(), lineIdx);
    }

    public LineID getCurrentLineID() {
        String tab = this.getSketch().getCurrentCode().getFileName();
        int lineNo = this.getTextArea().getCaretLine();
        return new LineID(tab, lineNo);
    }

    public boolean isInCurrentTab(LineID line) {
        return line.fileName().equals(this.getSketch().getCurrentCode().getFileName());
    }

    public void setCode(SketchCode code) {
        JavaTextArea ta;
        Document oldDoc = code.getDocument();
        super.setCode(code);
        Document newDoc = code.getDocument();
        if (oldDoc != newDoc) {
            this.addDocumentListener(newDoc);
        }
        if ((ta = this.getJavaTextArea()) != null) {
            ta.clearGutterText();
            if (this.breakpointedLines != null) {
                for (LineHighlight hl : this.breakpointedLines) {
                    if (!this.isInCurrentTab(hl.getLineID())) continue;
                    hl.paint();
                }
            }
            if (this.currentLine != null && this.isInCurrentTab(this.currentLine.getLineID())) {
                this.currentLine.paint();
            }
        }
        if (this.getDebugger() != null && this.getDebugger().isStarted()) {
            this.getDebugger().startTrackingLineChanges();
        }
        if (this.errorColumn != null) {
            this.errorColumn.repaint();
        }
    }

    public SketchCode getTab(String filename) {
        Sketch s = this.getSketch();
        for (SketchCode c : s.getCode()) {
            if (!c.getFileName().equals(filename)) continue;
            return c;
        }
        return null;
    }

    public SketchCode getCurrentTab() {
        return this.getSketch().getCurrentCode();
    }

    public Document currentDocument() {
        return this.getCurrentTab().getDocument();
    }

    public void statusBusy() {
        this.statusNotice(Language.text((String)"editor.status.debug.busy"));
    }

    public void statusHalted() {
        this.statusNotice(Language.text((String)"editor.status.debug.halt"));
    }

    public void updateErrorTable(List<Problem> problems) {
        this.errorTable.clearRows();
        for (Problem p : problems) {
            Object message = p.getMessage();
            if (p.getClass().equals(JavaProblem.class)) {
                JavaProblem jp = (JavaProblem)p;
                if (JavaMode.importSuggestEnabled && jp.getImportSuggestions() != null && jp.getImportSuggestions().length > 0) {
                    message = (String)message + " (double-click for suggestions)";
                }
            }
            this.errorTable.addRow(p, (String)message, this.sketch.getCode(p.getTabIndex()).getPrettyName(), Integer.toString(p.getLineNumber() + 1));
        }
    }

    public void errorTableDoubleClick(Object item) {
        JavaProblem p;
        String[] suggs;
        if (!item.getClass().equals(JavaProblem.class)) {
            this.errorTableClick(item);
        }
        if ((suggs = (p = (JavaProblem)item).getImportSuggestions()) != null && suggs.length > 0) {
            String[] list = p.getImportSuggestions();
            String className = list[0].substring(list[0].lastIndexOf(46) + 1);
            String[] temp = new String[list.length];
            for (int i = 0; i < list.length; ++i) {
                temp[i] = "<html>Import '" + className + "' <font color=#777777>(" + list[i] + ")</font></html>";
            }
            Point mouse = MouseInfo.getPointerInfo().getLocation();
            this.showImportSuggestion(temp, mouse.x, mouse.y);
        } else {
            this.errorTableClick(item);
        }
    }

    private void showImportSuggestion(String[] list, int x, int y) {
        if (this.frmImportSuggest != null) {
            return;
        }
        JList<String> classList = new JList<String>(list);
        classList.setSelectionMode(0);
        this.frmImportSuggest = new JFrame();
        this.frmImportSuggest.setUndecorated(true);
        this.frmImportSuggest.setDefaultCloseOperation(2);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBackground(Color.WHITE);
        this.frmImportSuggest.setBackground(Color.WHITE);
        panel.add(classList);
        JLabel label = new JLabel("<html><div alight = \"left\"><font size = \"2\"><br>(Click to insert)</font></div></html>");
        label.setBackground(Color.WHITE);
        label.setHorizontalTextPosition(2);
        panel.add(label);
        panel.validate();
        this.frmImportSuggest.getContentPane().add(panel);
        this.frmImportSuggest.pack();
        classList.addListSelectionListener(e -> {
            if (classList.getSelectedValue() != null) {
                try {
                    String t = ((String)classList.getSelectedValue()).trim();
                    Messages.log((String)t);
                    int x1 = t.indexOf(40);
                    String impString = "import " + t.substring(x1 + 1, t.indexOf(41)) + ";\n";
                    int ct = this.getSketch().getCurrentCodeIndex();
                    this.getSketch().setCurrentCode(0);
                    this.getTextArea().getDocument().insertString(0, impString, null);
                    this.getSketch().setCurrentCode(ct);
                }
                catch (BadLocationException ble) {
                    Messages.log((String)"Failed to insert import");
                    ble.printStackTrace();
                }
            }
            this.frmImportSuggest.setVisible(false);
            this.frmImportSuggest.dispose();
            this.frmImportSuggest = null;
        });
        this.frmImportSuggest.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (JavaEditor.this.frmImportSuggest != null) {
                    JavaEditor.this.frmImportSuggest.dispose();
                    JavaEditor.this.frmImportSuggest = null;
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        });
        this.frmImportSuggest.setLocation(x, y);
        this.frmImportSuggest.setBounds(x, y, 250, 100);
        this.frmImportSuggest.pack();
        this.frmImportSuggest.setVisible(true);
    }

    public void applyPreferences() {
        super.applyPreferences();
        if (this.jmode != null) {
            this.jmode.loadPreferences();
            Messages.log((String)"Applying prefs");
            this.errorChecker.preferencesChanged();
            this.sketchChanged();
        }
    }

    protected void startTweakMode() {
        this.getJavaTextArea().startTweakMode();
    }

    protected void stopTweakMode(List<List<Handle>> handles) {
        this.tweakClient.shutdown();
        this.getJavaTextArea().stopTweakMode();
        boolean[] tweakedTabs = JavaEditor.getTweakedTabs(handles);
        boolean modified = JavaEditor.anythingTrue(tweakedTabs);
        if (modified) {
            if (Messages.showYesNoQuestion((Frame)((Object)this), (String)Language.text((String)"tweak_mode"), (String)Language.text((String)"tweak_mode.keep_changes.line1"), (String)Language.text((String)"tweak_mode.keep_changes.line2")) == 0) {
                for (int i = 0; i < this.sketch.getCodeCount(); ++i) {
                    if (tweakedTabs[i]) {
                        this.sketch.getCode(i).setModified(true);
                        continue;
                    }
                    this.sketch.getCode(i).setProgram(this.sketch.getCode(i).getSavedProgram());
                    this.sketch.getCode(i).setDocument(null);
                    if (i != this.sketch.getCurrentCodeIndex()) continue;
                    this.setCode(this.sketch.getCurrentCode());
                }
                try {
                    this.sketch.save();
                }
                catch (IOException e) {
                    Messages.showWarning((String)"Error", (String)"Could not save the modified sketch.", (Throwable)e);
                }
                this.header.repaint();
                this.textarea.invalidate();
            } else {
                this.loadSavedCode();
                this.textarea.invalidate();
            }
        } else {
            this.loadSavedCode();
            this.textarea.invalidate();
        }
    }

    private static boolean anythingTrue(boolean[] list) {
        for (boolean b : list) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    protected void updateInterface(List<List<Handle>> handles, List<List<ColorControlBox>> colorBoxes) {
        this.getJavaTextArea().updateInterface(handles, colorBoxes);
    }

    private static boolean[] getTweakedTabs(List<List<Handle>> handles) {
        boolean[] outgoing = new boolean[handles.size()];
        for (int i = 0; i < handles.size(); ++i) {
            for (Handle h : handles.get(i)) {
                if (!h.valueChanged()) continue;
                outgoing[i] = true;
            }
        }
        return outgoing;
    }

    protected void initBaseCode() {
        SketchCode[] code = this.sketch.getCode();
        this.baseCode = new String[code.length];
        for (int i = 0; i < code.length; ++i) {
            this.baseCode[i] = code[i].getSavedProgram();
        }
    }

    protected void initEditorCode(List<List<Handle>> handles) {
        SketchCode[] sketchCode = this.sketch.getCode();
        for (int tab = 0; tab < this.baseCode.length; ++tab) {
            int charInc = 0;
            String code = this.baseCode[tab];
            for (Handle n : handles.get(tab)) {
                int s = n.startChar + charInc;
                int e = n.endChar + charInc;
                String newStr = n.strNewValue;
                code = JavaEditor.replaceString(code, s, e, newStr);
                n.newStartChar = n.startChar + charInc;
                n.newEndChar = n.endChar + (charInc += n.strNewValue.length() - n.strValue.length());
            }
            sketchCode[tab].setProgram(code);
            sketchCode[tab].setDocument(null);
        }
        this.setCode(this.sketch.getCurrentCode());
    }

    private void loadSavedCode() {
        for (SketchCode code : this.sketch.getCode()) {
            if (code.getProgram().equals(code.getSavedProgram())) continue;
            code.setProgram(code.getSavedProgram());
            code.setDocument(null);
        }
        this.setCode(this.sketch.getCurrentCode());
    }

    protected boolean automateSketch(Sketch sketch, SketchParser parser) {
        int tab;
        SketchCode[] code = sketch.getCode();
        List<List<Handle>> handles = parser.allHandles;
        if (code.length < 1) {
            return false;
        }
        if (handles.size() == 0) {
            return false;
        }
        int afterSizePos = SketchParser.getAfterSizePos(this.baseCode[0]);
        if (afterSizePos < 0) {
            return false;
        }
        String portStr = Preferences.get((String)PREF_TWEAK_PORT);
        if (portStr == null) {
            Preferences.set((String)PREF_TWEAK_PORT, (String)"auto");
            portStr = "auto";
        }
        int port = portStr.equals("auto") ? (int)(Math.random() * 16383.0) + 49152 : Preferences.getInteger((String)PREF_TWEAK_PORT);
        this.tweakClient = new TweakClient(port);
        for (tab = 0; tab < code.length; ++tab) {
            for (Handle h : handles.get(tab)) {
                h.setTweakClient(this.tweakClient);
            }
        }
        for (tab = 0; tab < code.length; ++tab) {
            int charInc = 0;
            String c = this.baseCode[tab];
            for (Handle handle : handles.get(tab)) {
                c = JavaEditor.replaceString(c, handle.startChar + charInc, handle.endChar + charInc, handle.name);
                charInc += handle.name.length() - handle.strValue.length();
            }
            code[tab].setProgram(c);
        }
        String c = code[0].getProgram();
        Object header = "\n\n/*************************/\n/* MODIFIED BY TWEAKMODE */\n/*************************/\n\n\n";
        header = (String)header + "import java.net.*;\n";
        header = (String)header + "import java.io.*;\n";
        header = (String)header + "import java.nio.*;\n\n";
        int numOfInts = JavaEditor.howManyInts(handles);
        int numOfFloats = JavaEditor.howManyFloats(handles);
        if (numOfInts > 0) {
            header = (String)header + "int[] tweakmode_int = new int[" + numOfInts + "];\n";
        }
        if (numOfFloats > 0) {
            header = (String)header + "float[] tweakmode_float = new float[" + numOfFloats + "];\n\n";
        }
        header = (String)header + "TweakModeServer tweakmode_Server;\n";
        header = (String)header + "void tweakmode_initAllVars() {\n";
        for (List<Handle> list : handles) {
            for (Handle n : list) {
                header = (String)header + "  " + n.name + " = " + n.strValue + ";\n";
            }
        }
        header = (String)header + "}\n\n";
        header = (String)header + "void tweakmode_initCommunication() {\n";
        header = (String)header + " tweakmode_Server = new TweakModeServer();\n";
        header = (String)header + " tweakmode_Server.setup();\n";
        header = (String)header + " tweakmode_Server.start();\n";
        header = (String)header + "}\n";
        header = (String)header + "\n\n\n\n\n";
        String string = "\n\n\n  /* TWEAKMODE */\n    tweakmode_initAllVars();\n    tweakmode_initCommunication();\n  /* TWEAKMODE */\n\n";
        afterSizePos = SketchParser.getAfterSizePos(c);
        c = JavaEditor.replaceString(c, afterSizePos, afterSizePos, string);
        String string2 = TweakClient.getServerCode(port, numOfInts > 0, numOfFloats > 0);
        code[0].setProgram((String)header + c + string2);
        String showModCode = Preferences.get((String)PREF_TWEAK_SHOW_CODE);
        if (showModCode == null) {
            Preferences.setBoolean((String)PREF_TWEAK_SHOW_CODE, (boolean)false);
        }
        if (Preferences.getBoolean((String)PREF_TWEAK_SHOW_CODE)) {
            System.out.println("\nTweakMode modified code:\n");
            for (int i = 0; i < code.length; ++i) {
                System.out.println("tab " + i + "\n");
                System.out.println("=======================================================\n");
                System.out.println(code[i].getProgram());
            }
        }
        return true;
    }

    private static String replaceString(String str, int start, int end, String put) {
        return str.substring(0, start) + put + str.substring(end);
    }

    private static int howManyInts(List<List<Handle>> handles) {
        int count = 0;
        for (List<Handle> list : handles) {
            for (Handle n : list) {
                if (!"int".equals(n.type) && !"hex".equals(n.type) && !"webcolor".equals(n.type)) continue;
                ++count;
            }
        }
        return count;
    }

    private static int howManyFloats(List<List<Handle>> handles) {
        int count = 0;
        for (List<Handle> list : handles) {
            for (Handle n : list) {
                if (!"float".equals(n.type)) continue;
                ++count;
            }
        }
        return count;
    }
}

