/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashMap;
import processing.app.Util;
import processing.app.ui.Editor;
import processing.core.PApplet;
import processing.mode.java.JavaBuild;
import processing.utils.SketchException;

public class Compiler {
    static HashMap<String, String> importSuggestions = new HashMap();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compile(JavaBuild build) throws SketchException {
        boolean success;
        SketchException exception;
        block25: {
            exception = null;
            String classpath = build.getClassPath();
            String classpathEmptyRemoved = classpath.replace("::", ":");
            String[] baseCommand = new String[]{"-g", "-Xemacs", "-source", "11", "-target", "11", "-encoding", "utf8", "-classpath", classpathEmptyRemoved, "-nowarn", "-d", build.getBinFolder().getAbsolutePath()};
            String[] sourceFiles = Util.listFiles((File)build.getSrcFolder(), (boolean)false, (String)".java");
            String[] command = PApplet.concat((String[])baseCommand, (String[])sourceFiles);
            try {
                block26: {
                    String errorMessage;
                    block30: {
                        String what;
                        block32: {
                            block31: {
                                block28: {
                                    String what2;
                                    block29: {
                                        block27: {
                                            final StringBuilder errorBuffer = new StringBuilder();
                                            Writer internalWriter = new Writer(){

                                                @Override
                                                public void write(char[] buf, int off, int len) {
                                                    errorBuffer.append(buf, off, len);
                                                }

                                                @Override
                                                public void flush() {
                                                }

                                                @Override
                                                public void close() {
                                                }
                                            };
                                            PrintWriter writer = new PrintWriter(internalWriter);
                                            PrintWriter outWriter = new PrintWriter(System.out);
                                            ClassLoader loader = build.mode.getClassLoader();
                                            try {
                                                Class<?> batchClass = Class.forName("org.eclipse.jdt.core.compiler.batch.BatchCompiler", false, loader);
                                                Class<?> progressClass = Class.forName("org.eclipse.jdt.core.compiler.CompilationProgress", false, loader);
                                                Class[] compileArgs = new Class[]{String[].class, PrintWriter.class, PrintWriter.class, progressClass};
                                                Method compileMethod = batchClass.getMethod("compile", compileArgs);
                                                success = (Boolean)compileMethod.invoke(null, command, outWriter, writer, null);
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                                throw new SketchException("Unknown error inside the compiler.");
                                            }
                                            writer.flush();
                                            writer.close();
                                            BufferedReader reader = new BufferedReader(new StringReader(errorBuffer.toString()));
                                            String line = reader.readLine();
                                            if (line == null) break block25;
                                            String errorFormat = "([\\w\\d_]+\\.java):(\\d+):\\s*([^:]*):\\s*(.*)\\s*";
                                            String[] pieces = PApplet.match((String)line, (String)errorFormat);
                                            if (pieces == null) {
                                                exception = new SketchException("Cannot parse error text: " + line);
                                                exception.hideStackTrace();
                                                System.err.println(line);
                                                while ((line = reader.readLine()) != null) {
                                                    System.err.println(line);
                                                }
                                                break block25;
                                            }
                                            errorMessage = pieces[4];
                                            String dotJavaFilename = pieces[1];
                                            int dotJavaLineIndex = PApplet.parseInt((String)pieces[2]) - 1;
                                            exception = build.placeException(errorMessage, dotJavaFilename, dotJavaLineIndex);
                                            if (exception == null) {
                                                exception = new SketchException(errorMessage);
                                            }
                                            if (!errorMessage.startsWith("The import ") || !errorMessage.endsWith("cannot be resolved")) break block27;
                                            String[] m = PApplet.match((String)errorMessage, (String)"The import (.*) cannot be resolved");
                                            if (m != null) {
                                                if (m[1].equals("processing.xml")) {
                                                    exception.setMessage("processing.xml no longer exists, this code needs to be updated for 2.0.");
                                                    System.err.println("The processing.xml library has been replaced with a new 'XML' class that's built-in.");
                                                    Compiler.handleCrustyCode();
                                                    break block26;
                                                } else {
                                                    exception.setMessage("The package \u201c" + m[1] + "\u201d does not exist. You might be missing a library.");
                                                    System.err.println("Libraries must be installed in a folder named 'libraries' inside the sketchbook folder (see the Preferences window).");
                                                }
                                            }
                                            break block26;
                                        }
                                        if (!errorMessage.endsWith("cannot be resolved to a type")) break block28;
                                        what2 = errorMessage.substring(0, errorMessage.indexOf(32));
                                        if (!what2.equals("BFont") && !what2.equals("BGraphics") && !what2.equals("BImage")) break block29;
                                        exception.setMessage(what2 + " has been replaced with P" + what2.substring(1));
                                        Compiler.handleCrustyCode();
                                        break block26;
                                    }
                                    exception.setMessage("Cannot find a class or type named \u201c" + what2 + "\u201d");
                                    String suggestion = importSuggestions.get(what2);
                                    if (suggestion == null) break block26;
                                    System.err.println("You may need to add \"import " + suggestion + ";\" to the top of your sketch.");
                                    System.err.println("To make sketches more portable, imports that are not part of the Processing API were removed in Processing 2.");
                                    System.err.println("See the changes page for more information: https://github.com/processing/processing/wiki/Changes");
                                    break block26;
                                }
                                if (!errorMessage.endsWith("cannot be resolved")) break block30;
                                what = errorMessage.substring(0, errorMessage.indexOf(32));
                                if (!what.equals("LINE_LOOP") && !what.equals("LINE_STRIP")) break block31;
                                exception.setMessage("LINE_LOOP and LINE_STRIP are not available, please update your code.");
                                Compiler.handleCrustyCode();
                                break block26;
                            }
                            if (!what.equals("framerate")) break block32;
                            exception.setMessage("framerate should be changed to frameRate.");
                            Compiler.handleCrustyCode();
                            break block26;
                        }
                        if (what.equals("screen")) {
                            exception.setMessage("Change screen.width and screen.height to displayWidth and displayHeight.");
                            Compiler.handleCrustyCode();
                            break block26;
                        } else if (what.equals("screenWidth") || what.equals("screenHeight")) {
                            exception.setMessage("Change screenWidth and screenHeight to displayWidth and displayHeight.");
                            Compiler.handleCrustyCode();
                            break block26;
                        } else {
                            exception.setMessage("Cannot find anything named \u201c" + what + "\u201d");
                        }
                        break block26;
                    }
                    if (!errorMessage.startsWith("Duplicate")) {
                        String[] parts = PApplet.match((String)errorMessage, (String)"literal (\\S*) of type (\\S*) is out of range");
                        if (null != parts) {
                            if ("int".equals(parts[2])) {
                                exception.setMessage("The type int can't handle numbers that big. Try " + parts[1] + "L to upgrade to long.");
                            } else {
                                exception.setMessage("Even the type " + parts[2] + " can't handle " + parts[1] + ". Research big numbers in Java.");
                            }
                        } else {
                            String undefined = "The method (\\S+\\(.*\\)) is undefined for the type (.*)";
                            parts = PApplet.match((String)errorMessage, (String)undefined);
                            if (parts != null) {
                                if (parts[1].equals("framerate(int)")) {
                                    exception.setMessage("framerate() no longer exists, use frameRate() instead.");
                                    Compiler.handleCrustyCode();
                                    break block25;
                                }
                                if (parts[1].equals("push()")) {
                                    exception.setMessage("push() no longer exists, use pushMatrix() instead.");
                                    Compiler.handleCrustyCode();
                                    break block25;
                                }
                                if (parts[1].equals("pop()")) {
                                    exception.setMessage("pop() no longer exists, use popMatrix() instead.");
                                    Compiler.handleCrustyCode();
                                    break block25;
                                } else {
                                    String mess = "The function " + parts[1] + " does not exist.";
                                    exception.setMessage(mess);
                                }
                                break block25;
                            }
                        }
                    }
                }
                exception.hideStackTrace();
            }
            catch (IOException e) {
                String bigSigh = "Error while compiling. (" + e.getMessage() + ")";
                exception = new SketchException(bigSigh);
                e.printStackTrace();
                success = false;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return success;
    }

    protected static void handleCrustyCode() {
        System.err.println("This code needs to be updated for this version of Processing, please read the Changes page on the Wiki.");
        Editor.showChanges();
    }

    static {
        importSuggestions.put("Arrays", "java.util.Arrays");
        importSuggestions.put("Collections", "java.util.Collections");
        importSuggestions.put("Date", "java.util.Date");
        importSuggestions.put("Frame", "java.awt.Frame");
        importSuggestions.put("Iterator", "java.util.Iterator");
    }
}

