/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.FloatAnimationSpec;
import androidx.compose.animation.core.VectorConvertersKt;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J(\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J(\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/compose/animation/core/FloatTweenSpec;", "Landroidx/compose/animation/core/FloatAnimationSpec;", "duration", "", "delay", "easing", "Landroidx/compose/animation/core/Easing;", "(IILandroidx/compose/animation/core/Easing;)V", "getDelay", "()I", "delayNanos", "", "getDuration", "durationNanos", "clampPlayTimeNanos", "playTimeNanos", "getDurationNanos", "initialValue", "", "targetValue", "initialVelocity", "getValueFromNanos", "getVelocityFromNanos", "animation-core"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nFloatAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatAnimationSpec.kt\nandroidx/compose/animation/core/FloatTweenSpec\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,265:1\n71#2,16:266\n*S KotlinDebug\n*F\n+ 1 FloatAnimationSpec.kt\nandroidx/compose/animation/core/FloatTweenSpec\n*L\n218#1:266,16\n*E\n"})
public final class FloatTweenSpec
implements FloatAnimationSpec {
    private final int duration;
    private final int delay;
    @NotNull
    private final Easing easing;
    private final long durationNanos;
    private final long delayNanos;
    public static final int $stable;

    public FloatTweenSpec(int duration, int delay, @NotNull Easing easing) {
        Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
        this.duration = duration;
        this.delay = delay;
        this.easing = easing;
        this.durationNanos = (long)this.duration * 1000000L;
        this.delayNanos = (long)this.delay * 1000000L;
    }

    public /* synthetic */ FloatTweenSpec(int n, int n2, Easing easing, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 300;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            easing = EasingKt.getFastOutSlowInEasing();
        }
        this(n, n2, easing);
    }

    public final int getDuration() {
        return this.duration;
    }

    public final int getDelay() {
        return this.delay;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getValueFromNanos(long playTimeNanos, float initialValue, float targetValue, float initialVelocity) {
        void $this$fastCoerceAtMost$iv$iv;
        void minimumValue$iv;
        void $this$fastCoerceIn$iv;
        float rawFraction;
        long clampedPlayTimeNanos = this.clampPlayTimeNanos(playTimeNanos);
        float f = rawFraction = this.duration == 0 ? 1.0f : (float)clampedPlayTimeNanos / (float)this.durationNanos;
        float f2 = 0.0f;
        float maximumValue$iv = 1.0f;
        boolean $i$f$fastCoerceIn = false;
        void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv ? minimumValue$iv : $this$fastCoerceAtLeast$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        float fraction = this.easing.transform($this$fastCoerceAtMost$iv$iv > maximumValue$iv ? maximumValue$iv : $this$fastCoerceAtMost$iv$iv);
        return VectorConvertersKt.lerp(initialValue, targetValue, fraction);
    }

    private final long clampPlayTimeNanos(long playTimeNanos) {
        return RangesKt.coerceIn((long)(playTimeNanos - this.delayNanos), (long)0L, (long)this.durationNanos);
    }

    @Override
    public long getDurationNanos(float initialValue, float targetValue, float initialVelocity) {
        return (long)(this.delay + this.duration) * 1000000L;
    }

    @Override
    public float getVelocityFromNanos(long playTimeNanos, float initialValue, float targetValue, float initialVelocity) {
        long clampedPlayTimeNanos = this.clampPlayTimeNanos(playTimeNanos);
        if (clampedPlayTimeNanos < 0L) {
            return 0.0f;
        }
        if (clampedPlayTimeNanos == 0L) {
            return initialVelocity;
        }
        float startNum = this.getValueFromNanos(clampedPlayTimeNanos - 1000000L, initialValue, targetValue, initialVelocity);
        float endNum = this.getValueFromNanos(clampedPlayTimeNanos, initialValue, targetValue, initialVelocity);
        return (endNum - startNum) * 1000.0f;
    }

    public FloatTweenSpec() {
        this(0, 0, null, 7, null);
    }
}

