/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import processing.app.Base;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Sketch;
import processing.app.Util;
import processing.app.tools.Tool;
import processing.app.ui.Editor;
import processing.awt.ShimAWT;

public class Archiver
implements Tool {
    Base base;
    Editor editor;
    boolean useDate;
    int digits = 3;
    NumberFormat numberFormat;
    SimpleDateFormat dateFormat;

    @Override
    public String getMenuTitle() {
        return Language.text("menu.tools.archive_sketch");
    }

    @Override
    public void init(Base base) {
        this.base = base;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setMinimumIntegerDigits(this.digits);
        this.dateFormat = new SimpleDateFormat("yyMMdd");
    }

    @Override
    public void run() {
        this.editor = this.base.getActiveEditor();
        Sketch sketch = this.editor.getSketch();
        if (sketch.isModified()) {
            Messages.showWarning("Save", "Please save the sketch before archiving.");
            return;
        }
        File location = sketch.getFolder();
        String name = location.getName();
        File parent = new File(location.getParent());
        File newbie = null;
        String namely = null;
        int index = 0;
        do {
            boolean bl = this.useDate = !name.startsWith("sketch_");
            if (this.useDate) {
                String purty = this.dateFormat.format(new Date());
                String stamp = purty + (char)(97 + index);
                namely = name + "-" + stamp;
                newbie = new File(parent, (String)namely + ".zip");
            } else {
                String diggie = this.numberFormat.format(index + 1);
                namely = name + "-" + diggie;
                newbie = new File(parent, namely + ".zip");
            }
            ++index;
        } while (newbie.exists());
        ShimAWT.selectOutput((String)Language.text("archive_sketch"), (String)"fileSelected", (File)newbie, (Object)this);
    }

    public void fileSelected(File newbie) {
        if (newbie != null) {
            try {
                if (!newbie.getName().toLowerCase().endsWith(".zip")) {
                    newbie = new File(newbie.getAbsolutePath() + ".zip");
                }
                FileOutputStream zipOutputFile = new FileOutputStream(newbie);
                ZipOutputStream zos = new ZipOutputStream(zipOutputFile);
                File sketchFolder = this.editor.getSketch().getFolder();
                this.buildZip(sketchFolder, sketchFolder.getName(), zos);
                zos.flush();
                zos.close();
                String msg = Language.interpolate("editor.status.archiver.create", newbie.getName());
                this.editor.statusNotice(msg);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.editor.statusNotice(Language.text("editor.status.archiver.cancel"));
        }
    }

    private void buildZip(File dir, String sofar, ZipOutputStream zos) throws IOException {
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            ZipEntry entry;
            String nowfar;
            if (files[i].equals(".") || files[i].equals("..")) continue;
            File sub = new File(dir, files[i]);
            String string2 = nowfar = sofar == null ? files[i] : sofar + "/" + files[i];
            if (sub.isDirectory()) {
                entry = new ZipEntry(nowfar + "/");
                zos.putNextEntry(entry);
                zos.closeEntry();
                this.buildZip(sub, nowfar, zos);
                continue;
            }
            entry = new ZipEntry(nowfar);
            entry.setTime(sub.lastModified());
            zos.putNextEntry(entry);
            zos.write(Util.loadBytesRaw(sub));
            zos.closeEntry();
        }
    }
}

