/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import processing.app.Preferences;
import processing.app.syntax.JEditTextArea;
import processing.data.StringDict;

public abstract class InputHandler
extends KeyAdapter {
    public static final String SMART_HOME_END_PROPERTY = "InputHandler.homeEnd";
    public static final String CONTEXT_AWARE_HOME_END = "editor.keys.home_and_end_travel_smart";
    public static final ActionListener BACKSPACE = new backspace();
    public static final ActionListener BACKSPACE_WORD = new backspace_word();
    public static final ActionListener DELETE = new delete();
    public static final ActionListener DELETE_WORD = new delete_word();
    public static final ActionListener END = new end(false);
    public static final ActionListener DOCUMENT_END = new document_end(false);
    public static final ActionListener SELECT_END = new end(true);
    public static final ActionListener SELECT_DOC_END = new document_end(true);
    public static final ActionListener INSERT_BREAK = new insert_break();
    public static final ActionListener INSERT_TAB = new insert_tab();
    public static final ActionListener HOME = new home(false);
    public static final ActionListener DOCUMENT_HOME = new document_home(false);
    public static final ActionListener SELECT_HOME = new home(true);
    public static final ActionListener SELECT_DOC_HOME = new document_home(true);
    public static final ActionListener NEXT_CHAR = new next_char(false);
    public static final ActionListener NEXT_LINE = new next_line(false);
    public static final ActionListener NEXT_PAGE = new next_page(false);
    public static final ActionListener NEXT_WORD = new next_word(false);
    public static final ActionListener SELECT_NEXT_CHAR = new next_char(true);
    public static final ActionListener SELECT_NEXT_LINE = new next_line(true);
    public static final ActionListener SELECT_NEXT_PAGE = new next_page(true);
    public static final ActionListener SELECT_NEXT_WORD = new next_word(true);
    public static final ActionListener OVERWRITE = new overwrite();
    public static final ActionListener PREV_CHAR = new prev_char(false);
    public static final ActionListener PREV_LINE = new prev_line(false);
    public static final ActionListener PREV_PAGE = new prev_page(false);
    public static final ActionListener PREV_WORD = new prev_word(false);
    public static final ActionListener SELECT_PREV_CHAR = new prev_char(true);
    public static final ActionListener SELECT_PREV_LINE = new prev_line(true);
    public static final ActionListener SELECT_PREV_PAGE = new prev_page(true);
    public static final ActionListener SELECT_PREV_WORD = new prev_word(true);
    public static final ActionListener REPEAT = new repeat();
    public static final ActionListener CLIPBOARD_CUT = new clipboard_cut();
    public static final ActionListener CLIPBOARD_COPY = new clipboard_copy();
    public static final ActionListener CLIPBOARD_PASTE = new clipboard_paste();
    public static final ActionListener INSERT_CHAR = new insert_char();
    private static Map<String, ActionListener> actions;
    private static final StringDict bracketsAndQuotesMap;
    protected ActionListener grabAction;
    protected boolean repeat;
    protected int repeatCount;
    protected MacroRecorder recorder;

    public static ActionListener getAction(String name) {
        return actions.get(name);
    }

    public static String getActionName(ActionListener listener) {
        Set<String> set = InputHandler.getActions();
        for (String name : set) {
            ActionListener _listener = InputHandler.getAction(name);
            if (_listener != listener) continue;
            return name;
        }
        return null;
    }

    public static Set<String> getActions() {
        return actions.keySet();
    }

    public abstract void addDefaultKeyBindings();

    public abstract void addKeyBinding(String var1, ActionListener var2);

    public abstract void removeKeyBinding(String var1);

    public abstract void removeAllKeyBindings();

    public void grabNextKeyStroke(ActionListener listener) {
        this.grabAction = listener;
    }

    public boolean isRepeatEnabled() {
        return this.repeat;
    }

    public void setRepeatEnabled(boolean repeat2) {
        this.repeat = repeat2;
    }

    public int getRepeatCount() {
        return this.repeat ? Math.max(1, this.repeatCount) : 1;
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    public MacroRecorder getMacroRecorder() {
        return this.recorder;
    }

    public void setMacroRecorder(MacroRecorder recorder) {
        this.recorder = recorder;
    }

    public abstract InputHandler copy();

    public void executeAction(ActionListener listener, Object source, String actionCommand) {
        ActionEvent evt = new ActionEvent(source, 1001, actionCommand);
        if (listener instanceof Wrapper) {
            listener.actionPerformed(evt);
            return;
        }
        boolean _repeat = this.repeat;
        int _repeatCount = this.getRepeatCount();
        if (listener instanceof NonRepeatable) {
            listener.actionPerformed(evt);
        } else {
            for (int i = 0; i < Math.max(1, this.repeatCount); ++i) {
                listener.actionPerformed(evt);
            }
        }
        if (this.grabAction == null) {
            if (this.recorder != null && !(listener instanceof NonRecordable)) {
                if (_repeatCount != 1) {
                    this.recorder.actionPerformed(REPEAT, String.valueOf(_repeatCount));
                }
                this.recorder.actionPerformed(listener, actionCommand);
            }
            if (_repeat) {
                this.repeat = false;
                this.repeatCount = 0;
            }
        }
    }

    public static JEditTextArea getTextArea(EventObject evt) {
        Object o;
        if (evt != null && (o = evt.getSource()) instanceof Component) {
            Component c = (Component)o;
            while (true) {
                if (c instanceof JEditTextArea) {
                    return (JEditTextArea)c;
                }
                if (c == null) break;
                if (c instanceof JPopupMenu) {
                    c = ((JPopupMenu)c).getInvoker();
                    continue;
                }
                c = c.getParent();
            }
        }
        System.err.println("BUG: getTextArea() returning null");
        System.err.println("Report this to Slava Pestov <sp@gjt.org>");
        return null;
    }

    protected void handleGrabAction(KeyEvent evt) {
        ActionListener _grabAction = this.grabAction;
        this.grabAction = null;
        this.executeAction(_grabAction, evt.getSource(), String.valueOf(evt.getKeyChar()));
    }

    public static int findWordStart(String line, int pos, String noWordSep) {
        char ch = line.charAt(pos - 1);
        if (noWordSep == null) {
            noWordSep = "";
        }
        boolean selectNoLetter = !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1;
        int wordStart = 0;
        for (int i = pos - 1; i >= 0; --i) {
            ch = line.charAt(i);
            if (!(selectNoLetter ^ (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1))) continue;
            wordStart = i + 1;
            break;
        }
        return wordStart;
    }

    public static int findWordEnd(String line, int pos, String noWordSep) {
        char ch = line.charAt(pos);
        if (noWordSep == null) {
            noWordSep = "";
        }
        boolean selectNoLetter = !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1;
        int wordEnd = line.length();
        for (int i = pos; i < line.length(); ++i) {
            ch = line.charAt(i);
            if (!(selectNoLetter ^ (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1))) continue;
            wordEnd = i;
            break;
        }
        return wordEnd;
    }

    public void handleInputMethodCommit() {
    }

    static {
        bracketsAndQuotesMap = new StringDict((String[][])new String[][]{{"(", ")"}, {"{", "}"}, {"[", "]"}, {"\"", "\""}, {"'", "'"}});
        actions = new HashMap<String, ActionListener>();
        actions.put("backspace", BACKSPACE);
        actions.put("backspace-word", BACKSPACE_WORD);
        actions.put("delete", DELETE);
        actions.put("delete-word", DELETE_WORD);
        actions.put("end", END);
        actions.put("select-end", SELECT_END);
        actions.put("document-end", DOCUMENT_END);
        actions.put("select-doc-end", SELECT_DOC_END);
        actions.put("insert-break", INSERT_BREAK);
        actions.put("insert-tab", INSERT_TAB);
        actions.put("home", HOME);
        actions.put("select-home", SELECT_HOME);
        actions.put("document-home", DOCUMENT_HOME);
        actions.put("select-doc-home", SELECT_DOC_HOME);
        actions.put("next-char", NEXT_CHAR);
        actions.put("next-line", NEXT_LINE);
        actions.put("next-page", NEXT_PAGE);
        actions.put("next-word", NEXT_WORD);
        actions.put("select-next-char", SELECT_NEXT_CHAR);
        actions.put("select-next-line", SELECT_NEXT_LINE);
        actions.put("select-next-page", SELECT_NEXT_PAGE);
        actions.put("select-next-word", SELECT_NEXT_WORD);
        actions.put("overwrite", OVERWRITE);
        actions.put("prev-char", PREV_CHAR);
        actions.put("prev-line", PREV_LINE);
        actions.put("prev-page", PREV_PAGE);
        actions.put("prev-word", PREV_WORD);
        actions.put("select-prev-char", SELECT_PREV_CHAR);
        actions.put("select-prev-line", SELECT_PREV_LINE);
        actions.put("select-prev-page", SELECT_PREV_PAGE);
        actions.put("select-prev-word", SELECT_PREV_WORD);
        actions.put("repeat", REPEAT);
        actions.put("insert-char", INSERT_CHAR);
        actions.put("clipboard-cut", CLIPBOARD_CUT);
        actions.put("clipboard-copy", CLIPBOARD_COPY);
        actions.put("clipboard-paste", CLIPBOARD_PASTE);
    }

    public static interface MacroRecorder {
        public void actionPerformed(ActionListener var1, String var2);
    }

    public static interface Wrapper {
    }

    public static interface NonRepeatable {
    }

    public static interface NonRecordable {
    }

    public static class backspace
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            if (!textArea.isEditable()) {
                textArea.getToolkit().beep();
                return;
            }
            if (textArea.getSelectionStart() != textArea.getSelectionStop()) {
                textArea.setSelectedText("");
            } else {
                int caret = textArea.getCaretPosition();
                if (caret == 0) {
                    textArea.getToolkit().beep();
                    return;
                }
                try {
                    textArea.getDocument().remove(caret - 1, 1);
                }
                catch (BadLocationException bl) {
                    bl.printStackTrace();
                }
            }
        }
    }

    public static class backspace_word
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int start = textArea.getSelectionStart();
            if (start != textArea.getSelectionStop()) {
                textArea.setSelectedText("");
            }
            int line = textArea.getCaretLine();
            int lineStart = textArea.getLineStartOffset(line);
            int caret = start - lineStart;
            String lineText = textArea.getLineText(textArea.getCaretLine());
            if (caret == 0) {
                if (lineStart == 0) {
                    textArea.getToolkit().beep();
                    return;
                }
                --caret;
            } else {
                String noWordSep = (String)textArea.getDocument().getProperty("noWordSep");
                caret = InputHandler.findWordStart(lineText, caret, noWordSep);
            }
            try {
                textArea.getDocument().remove(caret + lineStart, start - (caret + lineStart));
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
        }
    }

    public static class delete
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            if (!textArea.isEditable()) {
                textArea.getToolkit().beep();
                return;
            }
            if (textArea.getSelectionStart() != textArea.getSelectionStop()) {
                textArea.setSelectedText("");
            } else {
                int caret = textArea.getCaretPosition();
                if (caret == textArea.getDocumentLength()) {
                    textArea.getToolkit().beep();
                    return;
                }
                try {
                    textArea.getDocument().remove(caret, 1);
                }
                catch (BadLocationException bl) {
                    bl.printStackTrace();
                }
            }
        }
    }

    public static class delete_word
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            String lineText;
            int line;
            int lineStart;
            int caret;
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int start = textArea.getSelectionStart();
            if (start != textArea.getSelectionStop()) {
                textArea.setSelectedText("");
            }
            if ((caret = start - (lineStart = textArea.getLineStartOffset(line = textArea.getCaretLine()))) == (lineText = textArea.getLineText(textArea.getCaretLine())).length()) {
                if (lineStart + caret == textArea.getDocumentLength()) {
                    textArea.getToolkit().beep();
                    return;
                }
                ++caret;
            } else {
                String noWordSep = (String)textArea.getDocument().getProperty("noWordSep");
                caret = InputHandler.findWordEnd(lineText, caret, noWordSep);
            }
            try {
                textArea.getDocument().remove(start, caret + lineStart - start);
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
        }
    }

    public static class end
    implements ActionListener {
        private boolean select;

        public end(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int caretLine = textArea.getCaretLine();
            int lastOfLine = textArea.getLineStopOffset(caretLine) - 1;
            int lastNonWhiteSpaceOfLine = textArea.getLineStopNonWhiteSpaceOffset(caretLine) - 1;
            int lastVisibleLine = textArea.getFirstLine() + textArea.getVisibleLines();
            lastVisibleLine = lastVisibleLine >= textArea.getLineCount() ? Math.min(textArea.getLineCount() - 1, lastVisibleLine) : (lastVisibleLine -= textArea.getElectricScroll() + 1);
            int lastVisible = textArea.getLineStopOffset(lastVisibleLine) - 1;
            int lastDocument = textArea.getDocumentLength();
            if (caret == lastDocument && !Preferences.getBoolean(InputHandler.CONTEXT_AWARE_HOME_END)) {
                textArea.getToolkit().beep();
                return;
            }
            caret = !Boolean.TRUE.equals(textArea.getClientProperty(InputHandler.SMART_HOME_END_PROPERTY)) ? (!Preferences.getBoolean(InputHandler.CONTEXT_AWARE_HOME_END) || caret == lastNonWhiteSpaceOfLine ? lastOfLine : lastNonWhiteSpaceOfLine) : (caret == lastVisible ? lastDocument : (caret == lastOfLine ? lastVisible : lastOfLine));
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
        }
    }

    public static class document_end
    implements ActionListener {
        private boolean select;

        public document_end(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), textArea.getDocumentLength());
            } else {
                textArea.setCaretPosition(textArea.getDocumentLength());
            }
        }
    }

    public static class insert_break
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            if (!textArea.isEditable()) {
                textArea.getToolkit().beep();
                return;
            }
            textArea.setSelectedText("\n");
        }
    }

    public static class insert_tab
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            if (!textArea.isEditable()) {
                textArea.getToolkit().beep();
                return;
            }
            textArea.overwriteSetSelectedText("\t");
        }
    }

    public static class home
    implements ActionListener {
        private boolean select;

        public home(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int firstLine = textArea.getFirstLine();
            int caretLine = textArea.getCaretLine();
            int firstOfLine = textArea.getLineStartOffset(caretLine);
            int firstNonWhiteSpaceOfLine = textArea.getLineStartNonWhiteSpaceOffset(caretLine);
            int firstVisibleLine = firstLine == 0 ? 0 : firstLine + textArea.getElectricScroll();
            int firstVisible = textArea.getLineStartOffset(firstVisibleLine);
            if (caret == 0 && !Preferences.getBoolean(InputHandler.CONTEXT_AWARE_HOME_END)) {
                textArea.getToolkit().beep();
                return;
            }
            caret = !Boolean.TRUE.equals(textArea.getClientProperty(InputHandler.SMART_HOME_END_PROPERTY)) ? (!Preferences.getBoolean(InputHandler.CONTEXT_AWARE_HOME_END) || caret == firstNonWhiteSpaceOfLine ? firstOfLine : firstNonWhiteSpaceOfLine) : (caret == firstVisible ? 0 : (caret == firstOfLine ? firstVisible : firstOfLine));
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
        }
    }

    public static class document_home
    implements ActionListener {
        private boolean select;

        public document_home(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), 0);
            } else {
                textArea.setCaretPosition(0);
            }
        }
    }

    public static class next_char
    implements ActionListener {
        private boolean select;

        public next_char(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            if (caret == textArea.getDocumentLength()) {
                if (textArea.getSelectionStart() != textArea.getSelectionStop()) {
                    textArea.select(caret, caret);
                } else {
                    textArea.getToolkit().beep();
                }
            } else if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret + 1);
            } else {
                int end2;
                int start = textArea.getSelectionStart();
                if (start != (end2 = textArea.getSelectionStop())) {
                    textArea.select(end2, end2);
                } else {
                    textArea.setCaretPosition(caret + 1);
                }
            }
        }
    }

    public static class next_line
    implements ActionListener {
        private boolean select;

        public next_line(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int line = textArea.getCaretLine();
            if (line == textArea.getLineCount() - 1) {
                int doc = textArea.getDocumentLength();
                if (this.select) {
                    textArea.select(textArea.getMarkPosition(), doc);
                } else {
                    textArea.setCaretPosition(doc);
                }
                return;
            }
            int magic = textArea.getMagicCaretPosition();
            if (magic == -1) {
                magic = textArea.offsetToX(line, caret - textArea.getLineStartOffset(line));
            }
            caret = textArea.getLineStartOffset(line + 1) + textArea.xToOffset(line + 1, magic);
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
            textArea.setMagicCaretPosition(magic);
        }
    }

    public static class next_page
    implements ActionListener {
        private boolean select;

        public next_page(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int lineCount = textArea.getLineCount();
            int firstLine = textArea.getFirstLine();
            int visibleLines = textArea.getVisibleLines();
            int line = textArea.getCaretLine();
            if (lineCount > visibleLines) {
                if ((firstLine += visibleLines) + visibleLines >= lineCount - 1) {
                    firstLine = lineCount - visibleLines;
                }
                textArea.setFirstLine(firstLine);
                int caret = textArea.getLineStartOffset(Math.min(textArea.getLineCount() - 1, line + visibleLines));
                if (this.select) {
                    textArea.select(textArea.getMarkPosition(), caret);
                } else {
                    textArea.setCaretPosition(caret);
                }
            }
        }
    }

    public static class next_word
    implements ActionListener {
        private boolean select;

        public next_word(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String lineText;
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int line = textArea.getCaretLine();
            int lineStart = textArea.getLineStartOffset(line);
            if ((caret -= lineStart) == (lineText = textArea.getLineText(textArea.getCaretLine())).length()) {
                if (lineStart + caret == textArea.getDocumentLength()) {
                    textArea.getToolkit().beep();
                    return;
                }
                ++caret;
            } else {
                String noWordSep = (String)textArea.getDocument().getProperty("noWordSep");
                caret = InputHandler.findWordEnd(lineText, caret, noWordSep);
            }
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), lineStart + caret);
            } else {
                textArea.setCaretPosition(lineStart + caret);
            }
        }
    }

    public static class overwrite
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea;
            textArea.setOverwriteEnabled(!(textArea = InputHandler.getTextArea(evt)).isOverwriteEnabled());
        }
    }

    public static class prev_char
    implements ActionListener {
        private boolean select;

        public prev_char(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            if (caret == 0) {
                textArea.getToolkit().beep();
                return;
            }
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret - 1);
            } else {
                int end2;
                int start = textArea.getSelectionStart();
                if (start != (end2 = textArea.getSelectionStop())) {
                    textArea.select(start, start);
                } else {
                    textArea.setCaretPosition(caret - 1);
                }
            }
        }
    }

    public static class prev_line
    implements ActionListener {
        private boolean select;

        public prev_line(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int line = textArea.getCaretLine();
            if (line == 0) {
                if (this.select) {
                    if (textArea.getSelectionStart() != 0) {
                        textArea.select(textArea.getMarkPosition(), 0);
                    }
                } else {
                    textArea.setCaretPosition(0);
                }
                return;
            }
            int magic = textArea.getMagicCaretPosition();
            if (magic == -1) {
                magic = textArea.offsetToX(line, caret - textArea.getLineStartOffset(line));
            }
            caret = textArea.getLineStartOffset(line - 1) + textArea.xToOffset(line - 1, magic);
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
            textArea.setMagicCaretPosition(magic);
        }
    }

    public static class prev_page
    implements ActionListener {
        private boolean select;

        public prev_page(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int firstLine = textArea.getFirstLine();
            int visibleLines = textArea.getVisibleLines();
            int line = textArea.getCaretLine();
            if (firstLine < visibleLines) {
                firstLine = visibleLines;
            }
            textArea.setFirstLine(firstLine - visibleLines);
            int caret = textArea.getLineStartOffset(Math.max(0, line - visibleLines));
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
        }
    }

    public static class prev_word
    implements ActionListener {
        private boolean select;

        public prev_word(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int line = textArea.getCaretLine();
            int lineStart = textArea.getLineStartOffset(line);
            String lineText = textArea.getLineText(textArea.getCaretLine());
            if ((caret -= lineStart) == 0) {
                if (lineStart == 0) {
                    textArea.getToolkit().beep();
                    return;
                }
                --caret;
            } else {
                String noWordSep = (String)textArea.getDocument().getProperty("noWordSep");
                caret = InputHandler.findWordStart(lineText, caret, noWordSep);
            }
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), lineStart + caret);
            } else {
                textArea.setCaretPosition(lineStart + caret);
            }
        }
    }

    public static class repeat
    implements ActionListener,
    NonRecordable {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            textArea.getInputHandler().setRepeatEnabled(true);
            String actionCommand = evt.getActionCommand();
            if (actionCommand != null) {
                textArea.getInputHandler().setRepeatCount(Integer.parseInt(actionCommand));
            }
        }
    }

    public static class clipboard_cut
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            InputHandler.getTextArea(evt).cut();
        }
    }

    public static class clipboard_copy
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            InputHandler.getTextArea(evt).copy();
        }
    }

    public static class clipboard_paste
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            InputHandler.getTextArea(evt).paste();
        }
    }

    public static class insert_char
    implements ActionListener,
    NonRepeatable {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            String str = evt.getActionCommand();
            int repeatCount = textArea.getInputHandler().getRepeatCount();
            if (textArea.isEditable()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < repeatCount; ++i) {
                    sb.append(str);
                }
                if (Preferences.getBoolean("editor.completion.auto_close") && this.hasBracketsAndQuotes(str)) {
                    this.matchBracketsAndQuotes(str, evt, textArea, sb);
                } else {
                    textArea.overwriteSetSelectedText(sb.toString());
                }
            } else {
                textArea.getToolkit().beep();
            }
        }

        private void matchBracketsAndQuotes(String str, ActionEvent evt, JEditTextArea ta, StringBuilder sb) {
            sb.append(bracketsAndQuotesMap.get(str));
            ta.overwriteSetSelectedText(sb.toString());
            PREV_CHAR.actionPerformed(evt);
        }

        private boolean hasBracketsAndQuotes(String str) {
            for (String item : bracketsAndQuotesMap.keys()) {
                if (!str.equals(item)) continue;
                return true;
            }
            return false;
        }
    }
}

