/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import processing.app.Base;
import processing.app.Mode;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionType;
import processing.app.contrib.LocalContribution;
import processing.data.StringDict;
import processing.data.StringList;

public class ExamplesContribution
extends LocalContribution {
    private ExamplesContribution(File folder) {
        super(folder);
    }

    public static ExamplesContribution load(File folder) {
        return new ExamplesContribution(folder);
    }

    public static List<ExamplesContribution> loadAll(File examplesFolder) {
        ArrayList<ExamplesContribution> outgoing = new ArrayList<ExamplesContribution>();
        File[] potential = ContributionType.EXAMPLES.listCandidates(examplesFolder);
        if (potential != null) {
            for (File folder : potential) {
                outgoing.add(ExamplesContribution.load(folder));
            }
        }
        outgoing.sort(Comparator.comparing(Contribution::getName));
        return outgoing;
    }

    public static boolean isModeCompatible(Base base, StringDict props) {
        return ExamplesContribution.isModeCompatible(base.getActiveEditor().getMode(), props);
    }

    public static boolean isModeCompatible(Mode mode, StringDict props) {
        String currentIdentifier = mode.getIdentifier();
        StringList compatibleList = ExamplesContribution.parseModeList(props);
        if (compatibleList.size() == 0) {
            return !mode.requireExampleCompatibility();
        }
        return compatibleList.hasValue(currentIdentifier);
    }

    @Override
    public ContributionType getType() {
        return ContributionType.EXAMPLES;
    }
}

