/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Preferences;
import processing.app.SketchName;
import processing.app.ui.Editor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lprocessing/app/Schema;", "", "<init>", "()V", "Companion", "app"})
@StabilityInferred(parameters=1)
public final class Schema {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @Nullable
    private static Base base;
    @NotNull
    private static final List<Job> jobs;
    @NotNull
    private static final CoroutineScope scope;

    @JvmStatic
    @Nullable
    public static final Editor handleSchema(@NotNull String input, @NotNull Base base) {
        return Companion.handleSchema(input, base);
    }

    static {
        jobs = new ArrayList();
        scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J*\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00192\b\b\u0002\u0010\u001f\u001a\u00020\u000eH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lprocessing/app/Schema$Companion;", "", "<init>", "()V", "base", "Lprocessing/app/Base;", "jobs", "", "Lkotlinx/coroutines/Job;", "getJobs", "()Ljava/util/List;", "handleSchema", "Lprocessing/app/ui/Editor;", "input", "", "handleLocalFile", "handleSketch", "uri", "Ljava/net/URI;", "handleSketchNew", "handleSketchBase64", "handleSketchUrl", "handleSketchOptions", "", "sketchFolder", "Ljava/io/File;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "downloadFiles", "urlList", "targetFolder", "extension", "handlePreferences", "app"})
    @SourceDebugExtension(value={"SMAP\nSchema.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Schema.kt\nprocessing/app/Schema$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1557#2:172\n1628#2,3:173\n1557#2:176\n1628#2,3:177\n1187#2,2:180\n1261#2,4:182\n774#2:186\n865#2,2:187\n1557#2:189\n1628#2,3:190\n1557#2:193\n1628#2,3:194\n1863#2,2:197\n1557#2:199\n1628#2,3:200\n1187#2,2:203\n1261#2,4:205\n*S KotlinDebug\n*F\n+ 1 Schema.kt\nprocessing/app/Schema$Companion\n*L\n63#1:172\n63#1:173,3\n81#1:176\n81#1:177,3\n82#1:180,2\n82#1:182,4\n113#1:186\n113#1:187,2\n114#1:189\n114#1:190,3\n118#1:193\n118#1:194,3\n119#1:197,2\n157#1:199\n157#1:200,3\n158#1:203,2\n158#1:205,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Job> getJobs() {
            return jobs;
        }

        @JvmStatic
        @Nullable
        public final Editor handleSchema(@NotNull String input, @NotNull Base base) {
            Editor editor;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Schema.base = base;
            URI uri = URI.create(input);
            String string2 = uri.getHost();
            if (string2 == null) {
                String string3 = uri.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                editor = this.handleLocalFile(string3);
            } else if (Intrinsics.areEqual((Object)string2, (Object)"sketch")) {
                Intrinsics.checkNotNull((Object)uri);
                editor = this.handleSketch(uri);
            } else if (Intrinsics.areEqual((Object)string2, (Object)"preferences")) {
                Intrinsics.checkNotNull((Object)uri);
                editor = this.handlePreferences(uri);
            } else {
                editor = null;
            }
            return editor;
        }

        private final Editor handleLocalFile(String input) {
            Base base = base;
            return base != null ? base.handleOpen(input) : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final Editor handleSketch(URI uri) {
            String string2 = uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            Object object = new String[]{"/"};
            List paths = StringsKt.split$default((CharSequence)string2, (String[])object, (boolean)false, (int)0, (int)6, null);
            object = (String)CollectionsKt.getOrNull((List)paths, (int)1);
            if (object == null) return null;
            int n = -1;
            switch (((String)object).hashCode()) {
                case 108960: {
                    if (((String)object).equals("new")) {
                        n = 1;
                    }
                    break;
                }
                case -1396204209: {
                    if (((String)object).equals("base64")) {
                        n = 2;
                    }
                    break;
                }
                case 116079: {
                    if (((String)object).equals("url")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    Editor editor = this.handleSketchNew(uri);
                    return editor;
                }
                case 2: {
                    Editor editor = this.handleSketchBase64(uri);
                    return editor;
                }
                case 3: {
                    Editor editor = this.handleSketchUrl(uri);
                    return editor;
                }
                default: {
                    return null;
                }
            }
        }

        private final Editor handleSketchNew(URI uri) {
            block0: {
                Base base = base;
                if (base == null) break block0;
                base.handleNew();
            }
            return null;
        }

        private final Editor handleSketchBase64(URI uri) {
            File tempSketchFolder = SketchName.nextFolder(Base.untitledFolder);
            tempSketchFolder.mkdirs();
            File tempSketchFile = new File(tempSketchFolder, tempSketchFolder.getName() + ".pde");
            String string2 = uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String sketchB64 = StringsKt.replace$default((String)string2, (String)"/base64/", (String)"", (boolean)false, (int)4, null);
            byte[] sketch = Base64.getDecoder().decode(sketchB64);
            Intrinsics.checkNotNull((Object)sketch);
            FilesKt.writeBytes((File)tempSketchFile, (byte[])sketch);
            Intrinsics.checkNotNull((Object)tempSketchFolder);
            this.handleSketchOptions(uri, tempSketchFolder);
            Base base = base;
            return base != null ? base.handleOpenUntitled(tempSketchFile.getAbsolutePath()) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final Editor handleSketchUrl(URI uri) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string2 = uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            File url = new File(StringsKt.replace$default((String)string2, (String)"/url/", (String)"", (boolean)false, (int)4, null));
            Iterable iterable = (Iterable)new IntRange(1, 6);
            boolean $i$f$map = false;
            Closeable closeable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Character.valueOf(((Character)CollectionsKt.random((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Random)((Random)Random.Default))).charValue()));
            }
            String rand = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            File tempSketchFolder = new File(new File(Base.untitledFolder, rand), FilesKt.getNameWithoutExtension((File)url));
            tempSketchFolder.mkdirs();
            File tempSketchFile = new File(tempSketchFolder, tempSketchFolder.getName() + ".pde");
            closeable = new URL("https://" + url).openStream();
            Throwable throwable = null;
            try {
                long l;
                InputStream input = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new FileOutputStream(tempSketchFile);
                Throwable throwable2 = null;
                try {
                    FileOutputStream output = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)input);
                    l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            this.handleSketchOptions(uri, tempSketchFolder);
            Base base = base;
            return base != null ? base.handleOpenUntitled(tempSketchFile.getAbsolutePath()) : null;
        }

        /*
         * Unable to fully structure code
         */
        private final void handleSketchOptions(URI uri, File sketchFolder) {
            block7: {
                var4_3 = uri.getQuery();
                if (var4_3 == null) ** GOTO lbl-1000
                var6_4 = new String[]{"&"};
                var5_5 = StringsKt.split$default((CharSequence)var4_3, (String[])var6_4, (boolean)false, (int)0, (int)6, null);
                if (var5_5 != null) {
                    var7_6 = var5_5;
                    $i$f$map = false;
                    var9_13 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var14_22 = (String)item$iv$iv;
                        var19_26 = destination$iv$iv;
                        $i$a$-map-Schema$Companion$handleSketchOptions$options$1 = false;
                        var16_25 = new String[]{"="};
                        var19_26.add(StringsKt.split$default((CharSequence)((CharSequence)it), (String[])var16_25, (boolean)false, (int)2, (int)2, null));
                    }
                    $i$f$map = (List)destination$iv$iv;
                    $i$f$associate = false;
                    capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    $i$f$mapTo = $this$associate$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                    $i$f$associateTo = false;
                    for (E element$iv$iv : $this$associateTo$iv$iv) {
                        var16_25 = destination$iv$iv;
                        it = (List)element$iv$iv;
                        $i$a$-associate-Schema$Companion$handleSketchOptions$options$2 = false;
                        var17_27 = TuplesKt.to(it.get(0), it.get(1));
                        var16_25.put(var17_27.getFirst(), var17_27.getSecond());
                    }
                    v0 = destination$iv$iv;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = MapsKt.emptyMap();
                }
                options = v0;
                v1 = (String)options.get("data");
                if (v1 != null) {
                    data = v1;
                    $i$a$-let-Schema$Companion$handleSketchOptions$1 = false;
                    processing.app.Schema$Companion.downloadFiles$default(Schema.Companion, uri, data, new File(sketchFolder, "data"), null, 8, null);
                }
                v2 = (String)options.get("code");
                if (v2 != null) {
                    code = v2;
                    $i$a$-let-Schema$Companion$handleSketchOptions$2 = false;
                    processing.app.Schema$Companion.downloadFiles$default(Schema.Companion, uri, code, new File(sketchFolder, "code"), null, 8, null);
                }
                v3 = (String)options.get("pde");
                if (v3 != null) {
                    pde = v3;
                    $i$a$-let-Schema$Companion$handleSketchOptions$3 = false;
                    Schema.Companion.downloadFiles(uri, pde, sketchFolder, "pde");
                }
                v4 = (String)options.get("mode");
                if (v4 == null) break block7;
                mode = v4;
                $i$a$-let-Schema$Companion$handleSketchOptions$4 = false;
                modeFile = new File(sketchFolder, "sketch.properties");
                FilesKt.writeText$default((File)modeFile, (String)("mode.id=" + mode), null, (int)2, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void downloadFiles(URI uri, String urlList, File targetFolder, String extension) {
            void $this$forEach$iv;
            String[] stringArray;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String it;
            void $this$filterTo$iv$iv;
            targetFolder.mkdirs();
            String string2 = uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String[] stringArray2 = new String[]{"/"};
            String base = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)string2, (String[])stringArray2, (boolean)false, (int)0, (int)6, null), (int)2), (int)1), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
            String[] stringArray3 = new String[]{","};
            List files = StringsKt.split$default((CharSequence)urlList, (String[])stringArray3, (boolean)false, (int)0, (int)6, null);
            Iterable $this$filter$iv = files;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.contains$default((CharSequence)it, (CharSequence)":", (boolean)false, (int)2, null) ? it : it + ":" + it);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                stringArray = new String[]{":"};
                collection.add(StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)2, (int)2, null));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List list = (List)element$iv;
                boolean bl = false;
                String name = (String)list.get(0);
                String content = (String)list.get(1);
                Ref.ObjectRef target = new Ref.ObjectRef();
                target.element = new File(targetFolder, name);
                if (!StringsKt.isBlank((CharSequence)extension) && !Intrinsics.areEqual((Object)FilesKt.getExtension((File)((File)target.element)), (Object)extension)) {
                    target.element = new File(targetFolder, name + "." + extension);
                }
                try {
                    byte[] file = Base64.getDecoder().decode(content);
                    if (StringsKt.isBlank((CharSequence)name)) {
                        Messages.Companion.err$default(Messages.Companion, "Base64 files needs to start with a file name followed by a colon", null, 2, null);
                        continue;
                    }
                    File file2 = (File)target.element;
                    Intrinsics.checkNotNull((Object)file);
                    FilesKt.writeBytes((File)file2, (byte[])file);
                    stringArray = Unit.INSTANCE;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Object object;
                    if (StringsKt.startsWith$default((String)content, (String)"https://", (boolean)false, (int)2, null)) {
                        object = content;
                    } else if (StringsKt.startsWith$default((String)content, (String)"http://", (boolean)false, (int)2, null)) {
                        object = StringsKt.replace$default((String)content, (String)"http://", (String)"https://", (boolean)false, (int)4, null);
                    } else {
                        String string3 = new URL("https://" + content).getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                        object = !StringsKt.isBlank((CharSequence)string3) ? "https://" + content : "https://" + base + "/" + content;
                    }
                    URL url = new URL((String)object);
                    Job download2 = BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(url, (Ref.ObjectRef<File>)target, null){
                        int label;
                        final /* synthetic */ URL $url;
                        final /* synthetic */ Ref.ObjectRef<File> $target;
                        {
                            this.$url = $url;
                            this.$target = $target;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    Closeable closeable = this.$url.openStream();
                                    Ref.ObjectRef<File> objectRef = this.$target;
                                    Throwable throwable = null;
                                    try {
                                        InputStream input = (InputStream)closeable;
                                        boolean bl = false;
                                        Closeable closeable2 = new FileOutputStream((File)objectRef.element);
                                        Throwable throwable2 = null;
                                        try {
                                            FileOutputStream output = (FileOutputStream)closeable2;
                                            boolean bl2 = false;
                                            Intrinsics.checkNotNull((Object)input);
                                            ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                                            Unit unit = Unit.INSTANCE;
                                        }
                                        catch (Throwable throwable3) {
                                            throwable2 = throwable3;
                                            throw throwable3;
                                        }
                                        finally {
                                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                                        }
                                        Unit unit = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable = throwable4;
                                        throw throwable4;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    Companion.getJobs().add(download2);
                    stringArray = download2.invokeOnCompletion(arg_0 -> Companion.downloadFiles$lambda$13$lambda$12(download2, arg_0));
                }
            }
        }

        static /* synthetic */ void downloadFiles$default(Companion companion, URI uRI, String string2, File file, String string3, int n, Object object) {
            if ((n & 8) != 0) {
                string3 = "";
            }
            companion.downloadFiles(uRI, string2, file, string3);
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        private final Editor handlePreferences(URI uri) {
            var3_2 = uri.getQuery();
            if (var3_2 == null) ** GOTO lbl-1000
            var5_3 = new String[]{"&"};
            var4_4 = StringsKt.split$default((CharSequence)var3_2, (String[])var5_3, (boolean)false, (int)0, (int)6, null);
            if (var4_4 != null) {
                var6_5 = (Iterable)var4_4;
                $i$f$map = false;
                var8_8 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var13_17 = (String)item$iv$iv;
                    var18_21 = destination$iv$iv;
                    $i$a$-map-Schema$Companion$handlePreferences$options$1 = false;
                    var15_20 = new String[]{"="};
                    var18_21.add(StringsKt.split$default((CharSequence)((CharSequence)it), (String[])var15_20, (boolean)false, (int)0, (int)6, null));
                }
                $i$f$map = (List)destination$iv$iv;
                $i$f$associate = false;
                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                $i$f$mapTo = $this$associate$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                $i$f$associateTo = false;
                for (E element$iv$iv : $this$associateTo$iv$iv) {
                    var15_20 = destination$iv$iv;
                    it = (List)element$iv$iv;
                    $i$a$-associate-Schema$Companion$handlePreferences$options$2 = false;
                    var16_22 = TuplesKt.to((Object)URLDecoder.decode((String)it.get(0), StandardCharsets.UTF_8), (Object)URLDecoder.decode((String)it.get(1), StandardCharsets.UTF_8));
                    var15_20.put(var16_22.getFirst(), var16_22.getSecond());
                }
                v0 = destination$iv$iv;
            } else lbl-1000:
            // 2 sources

            {
                v0 = MapsKt.emptyMap();
            }
            options = v0;
            for (Object var4_4 : options.entrySet()) {
                key = (String)var4_4.getKey();
                value = (String)var4_4.getValue();
                Preferences.set(key, value);
            }
            Preferences.save();
            return null;
        }

        private static final Unit downloadFiles$lambda$13$lambda$12(Job $download, Throwable it) {
            Companion.getJobs().remove($download);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

